/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.imageconverter.api;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

/**
 * {@link IFileItemWriteAccess}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 * @since v7.10.0
 */
public interface IFileItemWriteAccess extends IFileItemReadAccess {

    /**
     * @return The {@link OutputStream} to write into
     */
    public OutputStream getOutputStream();

    /**
     * Returns the output file to write to.</br>
     * A temporary file will be created, if
     * the chosen access option to acquire the <code>IFileItemWriteAccess</code>
     * interface initially doesn't use a file to work on.</br>
     * For performance reasons, care should be taken to use the right access option
     * if planning to use the <code>getOutputFile</code> method.</br>
     * If this method is called, a possibly previously used <code>OutputStream</code>
     * object is closed and not usable anymore.</br>
     * In essence, it is best practice to initially decide for
     * <code>AccessOption.FILE_BASED</code> write access and use either
     * the file object or the stream obect to write content into throughout
     * the lifetime of this access object.
     * <code></code>
     *
     * @return The <code>File</code> to write
     *  content into
     * @throws IOException
     */
    public File getOutputFile() throws IOException;

    /**
     * @param key
     * @param value
     */
    public void setKeyValue(final String key, final String value) throws FileItemException;
}
