/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.notification.service;


/**
 * Defines common variable names to be used in mail notification templates.
 *
 * @author <a href="mailto:steffen.templin@open-xchange.com">Steffen Templin</a>
 * @since v7.8.0
 */
public class CommonNotificationVariables {

    /**
     * Variable <code>footer_text</code>
     */
    public static final String FOOTER_TEXT = "footer_text";
    /**
     * Variable <code>footer_image_src</code>
     */
    public static final String FOOTER_IMAGE_SRC = "footer_image_src";
    /**
     * Variable <code>footer_image_alt</code>
     */
    public static final String FOOTER_IMAGE_ALT = "footer_image_alt";
    /**
     * Variable <code>button_border_color</code>
     */
    public static final String BUTTON_BORDER_COLOR = "button_border_color";
    /**
     * Variable <code>button_background_color</code>
     */
    public static final String BUTTON_BACKGROUND_COLOR = "button_background_color";
    /**
     * Variable <code>button_color</code>
     */
    public static final String BUTTON_COLOR = "button_color";

}
