/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.filestore;


/**
 * {@link Purpose} - The purpose for obtaining a file storage.
 *
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 * @since v7.8.4
 */
public enum Purpose {

    /**
     * The special purpose signaling that file storage is used to perform administrative operations.
     */
    ADMINISTRATIVE("administrative"),
    /**
     * Denotes the general purpose for context-associated files (Drive exclusive);<br>
     * e.g. PIM attachments, vCards, signatures/snippets, resource cache, etc.
     */
    GENERAL("general"),
    /**
     * The special purpose for Drive (aka InfoStore)
     */
    DRIVE("drive"),
    ;

    private final String identifier;

    private Purpose(String identifier) {
        this.identifier = identifier;
    }

    /**
     * Gets the identifier
     *
     * @return The identifier
     */
    public String getIdentifier() {
        return identifier;
    }

}
