/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.chronos.itip;

import com.openexchange.i18n.LocalizableStrings;

/**
 * {@link HRRStrings}
 *
 * @author <a href="mailto:martin.herfurth@open-xchange.com">Martin Herfurth</a>
 */
public class HRRStrings implements LocalizableStrings {

    public static final String NO = "No recurrence";

    public static final String DAILY = "Every %1$s day";

    public static final String WEEKLY_EACH_1 = "Every week on %1$s";
    
    public static final String WEEKLY_EACH_2 = "Every week";

    public static final String WEEKLY_1 = "Every %1$s weeks on %2$s";
    
    public static final String WEEKLY_2 = "Every %1$s weeks";

    public static final String MONTHLY_1 = "On %1$s. day every %2$s. month";

    public static final String MONTHLY_2 = "On %1$s %2$s every %3$s. month";

    public static final String YEARLY_1 = "On %1$s %2$s in %3$s";

    // E.g. "Every 2. February"
    public static final String YEARLY_2 = "Every %1$s. %2$s";

    public static final String WORK_DAY = "Work day";

    public static final String WEEKEND_DAY = "Weekend day";

    public static final String DAY = "Day";

    public static final String MONDAY = "Monday";

    public static final String TUESDAY = "Tuesday";

    public static final String WEDNESDAY = "Wednesday";

    public static final String THURSDAY = "Thursday";

    public static final String FRIDAY = "Friday";

    public static final String SATURDAY = "Saturday";

    public static final String SUNDAY = "Sunday";

    public static final String JANUARY = "January";

    public static final String FEBRUARY = "February";

    public static final String MARCH = "March";

    public static final String APRIL = "April";

    public static final String MAY = "May";

    public static final String JUNE = "June";

    public static final String JULY = "July";

    public static final String AUGUST = "August";

    public static final String SEPTEMBER = "September";

    public static final String OCTOBER = "October";

    public static final String NOVEMBER = "November";

    public static final String DECEMBER = "December";

    public static final String FIRST = "first";

    public static final String SECOND = "second";

    public static final String THIRD = "third";

    public static final String FOURTH = "fourth";

    public static final String LAST = "last";

    public static final String OCCURRENCES = "Occurs %1$s times";

    // E.g. "Until Wednesday, July 11, 2012"
    public static final String UNTIL = "Until %1$s";

    public static final String FOREVER = "No end";
}
