/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.utils;

import java.util.regex.Pattern;

public final class Replacer {
    private final Pattern from;
    private String to;
    private boolean repeatUntilUnchanged;
    private boolean ignoreCase;

    public Replacer(String from, String to, Modificator ... modificators) {
        this.processModificators(modificators);
        this.from = this.ignoreCase ? Pattern.compile(from, 2) : Pattern.compile(from);
        this.to = to;
    }

    private void processModificators(Modificator ... modificators) {
        block4: for (Modificator modificator : modificators) {
            switch (modificator) {
                case IGNORE_CASE: {
                    this.ignoreCase = true;
                    continue block4;
                }
                case REPEAT_UNTIL_UNCHANGED: {
                    this.repeatUntilUnchanged = true;
                    continue block4;
                }
            }
        }
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String process(String in) {
        String old;
        String retVal = in;
        do {
            old = retVal;
            retVal = this.from.matcher(retVal).replaceAll(this.to);
        } while (this.repeatUntilUnchanged && !old.equals(retVal));
        return retVal;
    }

    public String toString() {
        return "Replacer{from=" + this.from + ", to='" + this.to + '\'' + ", repeatUntilUnchanged=" + this.repeatUntilUnchanged + ", ignoreCase=" + this.ignoreCase + '}';
    }

    public static enum Modificator {
        REPEAT_UNTIL_UNCHANGED,
        IGNORE_CASE;

    }
}

