/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.source;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.javasimon.Manager;
import org.javasimon.Simon;
import org.javasimon.source.MonitorSource;

public abstract class CachedMonitorSource<L, M extends Simon, K>
implements MonitorSource<L, M> {
    private final MonitorSource<L, M> delegate;
    private static final MonitorInformation NULL_MONITOR_INFORMATION = new MonitorInformation(false, null);
    private final Map<K, MonitorInformation> monitorInformations = new ConcurrentHashMap<K, MonitorInformation>();

    public CachedMonitorSource(MonitorSource<L, M> delegate) {
        this.delegate = delegate;
    }

    protected abstract K getLocationKey(L var1);

    private MonitorInformation getMonitorInformation(L location) {
        K monitorKey = this.getLocationKey(location);
        MonitorInformation monitorInformation = this.monitorInformations.get(monitorKey);
        if (monitorInformation == null) {
            monitorInformation = this.delegate.isMonitored(location) ? new MonitorInformation(true, (Simon)this.delegate.getMonitor(location)) : NULL_MONITOR_INFORMATION;
            this.monitorInformations.put(monitorKey, monitorInformation);
        }
        return monitorInformation;
    }

    private void removeMonitorInformation(L location) {
        this.monitorInformations.remove(this.getLocationKey(location));
    }

    @Override
    public boolean isMonitored(L location) {
        return this.getMonitorInformation(location).isMonitored();
    }

    private M getMonitorOnce(L location) {
        return (M)this.getMonitorInformation(location).getMonitor(this.getManager());
    }

    @Override
    public M getMonitor(L location) {
        M monitor = this.getMonitorOnce(location);
        if (monitor == null) {
            this.removeMonitorInformation(location);
            monitor = this.getMonitorOnce(location);
        }
        return monitor;
    }

    @Override
    public Manager getManager() {
        return this.delegate.getManager();
    }

    private static class MonitorInformation {
        private final boolean monitored;
        private final String name;

        public MonitorInformation(boolean monitored, Simon simon) {
            this.monitored = monitored;
            this.name = simon == null ? null : simon.getName();
        }

        public boolean isMonitored() {
            return this.monitored;
        }

        public String getName() {
            return this.name;
        }

        public Simon getMonitor(Manager manager) {
            if (this.name == null) {
                return null;
            }
            return manager.getSimon(this.name);
        }
    }
}

