/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.clock;

import org.javasimon.clock.SimonClock;

public class SimonClockUtils {
    public static final long INIT_NANOS = Calibration.access$000();
    public static final long INIT_MILLIS = Calibration.access$100();
    public static final long MILLIS_GRANULARITY = Calibration.access$200();
    public static final long NANOS_GRANULARITY = Calibration.access$300();

    public static long millisForNano(long nanos) {
        return INIT_MILLIS + (nanos - INIT_NANOS) / SimonClock.NANOS_IN_MILLIS;
    }

    private static class Calibration {
        private static final int NANO_CHANGES = 100;
        private static long initNanos;
        private static long initMillis;
        private static long nanosGranularity;
        private static long millisGranularity;

        private Calibration() {
        }

        static /* synthetic */ long access$000() {
            return initNanos;
        }

        static /* synthetic */ long access$100() {
            return initMillis;
        }

        static /* synthetic */ long access$200() {
            return millisGranularity;
        }

        static /* synthetic */ long access$300() {
            return nanosGranularity;
        }

        static {
            long nextMillis;
            long oldNanos;
            initMillis = System.currentTimeMillis();
            while (true) {
                oldNanos = System.nanoTime();
                nextMillis = System.currentTimeMillis();
                if (nextMillis > initMillis) break;
                initNanos = oldNanos;
            }
            millisGranularity = nextMillis - initMillis;
            initMillis = nextMillis;
            long sumOfNanoDiffs = 0L;
            int nanoChanges = 0;
            int nanoMeasurements = 0;
            while (nanoChanges < 100) {
                long nextNanos = System.nanoTime();
                ++nanoMeasurements;
                if (nextNanos <= oldNanos) continue;
                ++nanoChanges;
                sumOfNanoDiffs += nextNanos - oldNanos;
                oldNanos = nextNanos;
            }
            nanosGranularity = sumOfNanoDiffs / (long)nanoChanges;
        }
    }
}

