/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByExpander;
import org.dmfs.rfc5545.recur.Freq;
import org.dmfs.rfc5545.recur.LongArray;
import org.dmfs.rfc5545.recur.RecurrenceRule;

public final class FreqIterator
extends ByExpander {
    private static final int MAX_EMPTY_SETS = 1000;
    private final Freq mFreq;
    private final int mInterval;
    private final LongArray mResultSet = new LongArray(1);
    private final CalendarMetrics mCalendarMetrics;
    private long mNextInstance;

    public FreqIterator(RecurrenceRule rule, CalendarMetrics calendarMetrics, long start) {
        super(null, calendarMetrics, start);
        this.mFreq = rule.getFreq();
        this.mInterval = rule.getInterval();
        this.mCalendarMetrics = calendarMetrics;
        int year = Instance.year((long)start);
        int month = Instance.month((long)start);
        int dayOfMonth = Instance.dayOfMonth((long)start);
        int dayOfYear = this.mCalendarMetrics.getDayOfYear(year, month, dayOfMonth);
        this.mNextInstance = Instance.setDayOfWeek((long)start, (int)this.mCalendarMetrics.getDayOfWeek(year, dayOfYear));
    }

    @Override
    public long next() {
        long result;
        CalendarMetrics calendarMetrics = this.mCalendarMetrics;
        int errorCountdown = 1000;
        do {
            if (--errorCountdown < 0) {
                throw new IllegalArgumentException("too many empty recurrence sets");
            }
            result = this.mNextInstance;
            this.mNextInstance = this.mFreq.next(calendarMetrics, result, this.mInterval);
        } while (this.mFilterCount > 0 && this.filter(result));
        return result;
    }

    @Override
    LongArray nextSet() {
        this.mResultSet.clear();
        this.mResultSet.add(this.next());
        return this.mResultSet;
    }

    @Override
    void expand(long instance, long start) {
    }

    @Override
    void fastForward(long untilInstance) {
        this.mNextInstance = this.mFreq.next(this.mCalendarMetrics, this.mNextInstance, this.mInterval, untilInstance);
    }
}

