/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByExpander;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.RuleIterator;
import org.dmfs.rfc5545.recur.StaticUtils;

final class ByWeekNoExpander
extends ByExpander {
    private final int[] mByWeekNo;
    private final ByExpander.Scope mScope;
    private final boolean mAllowOverlappingWeeks;

    public ByWeekNoExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarTools, long start) {
        super(previous, calendarTools, start);
        this.mByWeekNo = StaticUtils.ListToSortedArray(rule.getByPart(RecurrenceRule.Part.BYWEEKNO));
        this.mScope = rule.hasPart(RecurrenceRule.Part.BYMONTH) ? ByExpander.Scope.MONTHLY : ByExpander.Scope.YEARLY;
        this.mAllowOverlappingWeeks = this.mScope == ByExpander.Scope.MONTHLY && (rule.hasPart(RecurrenceRule.Part.BYDAY) || rule.hasPart(RecurrenceRule.Part.BYMONTHDAY) || rule.hasPart(RecurrenceRule.Part.BYYEARDAY));
    }

    @Override
    void expand(long instance, long notBefore) {
        int year = Instance.year((long)instance);
        int month = Instance.month((long)instance);
        int hour = Instance.hour((long)instance);
        int minute = Instance.minute((long)instance);
        int second = Instance.second((long)instance);
        int dayOfWeek = Instance.dayOfWeek((long)instance);
        int yearWeeks = this.mCalendarMetrics.getWeeksPerYear(year);
        int[] nArray = this.mByWeekNo;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int newMonth;
            int monthAndDay;
            int yearDay;
            int weekOfYear;
            int actualWeek = weekOfYear = nArray[i];
            if (weekOfYear < 0) {
                actualWeek = yearWeeks + weekOfYear + 1;
            }
            if (actualWeek <= 0 || actualWeek > yearWeeks) continue;
            if (this.mScope == ByExpander.Scope.MONTHLY && this.mAllowOverlappingWeeks) {
                int monthAndDay3;
                int newMonth3;
                yearDay = this.mCalendarMetrics.getYearDayOfIsoYear(year, actualWeek, dayOfWeek);
                monthAndDay = this.mCalendarMetrics.getMonthAndDayOfYearDay(year, yearDay);
                newMonth = CalendarMetrics.packedMonth((int)monthAndDay);
                if (newMonth == month) {
                    this.addInstance(Instance.make((int)year, (int)newMonth, (int)CalendarMetrics.dayOfMonth((int)monthAndDay), (int)hour, (int)minute, (int)second));
                    continue;
                }
                int firstDayOfWeek = this.mCalendarMetrics.weekStartInt;
                int yearDay2 = this.mCalendarMetrics.getYearDayOfIsoYear(year, actualWeek, firstDayOfWeek);
                if (yearDay2 < 1 || yearDay2 > this.mCalendarMetrics.getDaysPerYear(year)) continue;
                int monthAndDay2 = this.mCalendarMetrics.getMonthAndDayOfYearDay(year, yearDay2);
                int newMonth2 = CalendarMetrics.packedMonth((int)monthAndDay2);
                if (newMonth2 == month) {
                    int offset = (dayOfWeek - firstDayOfWeek + 7) % 7;
                    this.addInstance(Instance.make((int)year, (int)month, (int)(CalendarMetrics.dayOfMonth((int)monthAndDay2) + offset), (int)hour, (int)minute, (int)second));
                    continue;
                }
                int yearDay3 = this.mCalendarMetrics.getYearDayOfIsoYear(year, actualWeek, (firstDayOfWeek + 6) % 7);
                if (yearDay3 < 1 || yearDay3 > this.mCalendarMetrics.getDaysPerYear(year) || (newMonth3 = CalendarMetrics.packedMonth((int)(monthAndDay3 = this.mCalendarMetrics.getMonthAndDayOfYearDay(year, yearDay3)))) != month) continue;
                int offset = (dayOfWeek - firstDayOfWeek - 6) % 7;
                this.addInstance(Instance.make((int)year, (int)month, (int)(CalendarMetrics.dayOfMonth((int)monthAndDay3) + offset), (int)hour, (int)minute, (int)second));
                continue;
            }
            if (this.mScope == ByExpander.Scope.MONTHLY) {
                yearDay = this.mCalendarMetrics.getYearDayOfIsoYear(year, actualWeek, dayOfWeek);
                if (yearDay < 1 || yearDay > this.mCalendarMetrics.getDaysPerYear(year) || (newMonth = CalendarMetrics.packedMonth((int)(monthAndDay = this.mCalendarMetrics.getMonthAndDayOfYearDay(year, yearDay)))) != month) continue;
                this.addInstance(Instance.setMonthAndDayOfMonth((long)instance, (int)newMonth, (int)CalendarMetrics.dayOfMonth((int)monthAndDay)));
                continue;
            }
            yearDay = this.mCalendarMetrics.getYearDayOfIsoYear(year, actualWeek, dayOfWeek);
            if (yearDay < 1) {
                yearDay += this.mCalendarMetrics.getDaysPerYear(--year);
            } else if (yearDay > this.mCalendarMetrics.getDaysPerYear(year)) {
                yearDay -= this.mCalendarMetrics.getDaysPerYear(year);
                ++year;
            }
            monthAndDay = this.mCalendarMetrics.getMonthAndDayOfYearDay(year, yearDay);
            this.addInstance(Instance.setMonthAndDayOfMonth((long)instance, (int)CalendarMetrics.packedMonth((int)monthAndDay), (int)CalendarMetrics.dayOfMonth((int)monthAndDay)));
        }
    }
}

