/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.PrimitiveIterator;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.apache.uima.List_of_ints;
import org.apache.uima.UimaSerializable;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FeatureStructureImplC;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.IntListIterator;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.IntegerArray;
import org.apache.uima.jcas.cas.TOP;

public class IntegerArrayList
extends TOP
implements Iterable<Integer>,
UimaSerializable,
CommonArrayFS<Integer>,
RandomAccess,
Cloneable {
    public static final String _TypeName = "org.apache.uima.jcas.cas.IntegerArrayList";
    public static final int typeIndexID;
    public static final int type;
    private final IntVector intArrayList;
    private List_of_ints intArrayAsList = List_of_ints.EMPTY_LIST();
    public static final String _FeatName_intArray = "intArray";
    private static final CallSite _FC_intArray;
    private static final MethodHandle _FH_intArray;

    @Override
    public int getTypeIndexID() {
        return typeIndexID;
    }

    protected IntegerArrayList() {
        this.intArrayList = null;
    }

    public IntegerArrayList(TypeImpl type, CASImpl casImpl) {
        super(type, casImpl);
        this.intArrayList = new IntVector();
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
    }

    public IntegerArrayList(JCas jcas) {
        super(jcas);
        this.intArrayList = new IntVector();
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
    }

    public IntegerArrayList(JCas jcas, int length) {
        super(jcas);
        this._casView.validateArraySize(length);
        this.intArrayList = new IntVector(length);
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
    }

    private IntegerArray getIntArray() {
        return (IntegerArray)this._getFeatureValueNc(IntegerArrayList.wrapGetIntCatchException(_FH_intArray));
    }

    private void setIntArray(IntegerArray v) {
        this._setFeatureValueNcWj(IntegerArrayList.wrapGetIntCatchException(_FH_intArray), v);
    }

    private void maybeStartUsingIntegerArrayList() {
        if (this.intArrayAsList != null) {
            this.intArrayList.removeAllElements();
            this.intArrayList.copyFromArray(this.intArrayAsList.toArrayMinCopy(), 0, 0, this.size());
            this.intArrayAsList = null;
            this.setIntArray(null);
        }
    }

    @Override
    public void _init_from_cas_data() {
    }

    @Override
    public void _save_to_cas_data() {
        if (null != this.intArrayAsList) {
            return;
        }
        IntegerArray ia = this.getIntArray();
        int size = this.intArrayList.size();
        if (ia == null || ia.size() != size) {
            ia = new IntegerArray(this._casView.getJCasImpl(), size);
            this.setIntArray(ia);
        }
        ia.copyFromArray(this.intArrayList.getArray(), 0, 0, this.size());
        this.intArrayAsList = List_of_ints.newInstance(this.getIntArray()._getTheArray());
    }

    public int get(int i) {
        return null == this.intArrayAsList ? this.intArrayList.get(i) : this.intArrayAsList.get(i);
    }

    public void set(int i, int v) {
        if (null == this.intArrayAsList) {
            this.intArrayList.set(i, v);
        } else {
            this.intArrayAsList.set(i, v);
        }
    }

    @Override
    public int size() {
        return null == this.intArrayAsList ? this.intArrayList.size() : this.intArrayAsList.size();
    }

    public void copyFromArray(int[] src, int srcPos, int destPos, int length) {
        int srcEnd = srcPos + length;
        int destEnd = destPos + length;
        if (srcPos < 0 || srcEnd > src.length || destEnd > this.size()) {
            throw new ArrayIndexOutOfBoundsException(String.format("IntegerArrayList.copyFromArray, srcPos: %,d destPos: %,d length: %,d", srcPos, destPos, length));
        }
        if (null == this.intArrayAsList) {
            this.intArrayList.copyFromArray(src, srcPos, destPos, length);
        } else {
            this.intArrayAsList.copyFromArray(src, srcPos, destPos, length);
        }
    }

    public void copyToArray(int srcPos, int[] dest, int destPos, int length) {
        int srcEnd = srcPos + length;
        int destEnd = destPos + length;
        if (srcPos < 0 || srcEnd > this.size() || destEnd > dest.length) {
            throw new ArrayIndexOutOfBoundsException(String.format("IntegerArrayList.copyToArray, srcPos: %,d destPos: %,d length: %,d", srcPos, destPos, length));
        }
        if (null == this.intArrayAsList) {
            this.intArrayList.copyToArray(srcPos, dest, destPos, length);
        } else {
            this.intArrayAsList.copyToArray(srcPos, dest, destPos, length);
        }
    }

    public int[] toArray() {
        int[] r = new int[this.size()];
        this.copyToArray(0, r, 0, this.size());
        return r;
    }

    @Override
    public void copyFromArray(String[] src, int srcPos, int destPos, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyToArray(int srcPos, String[] dest, int destPos, int length) {
        this._casView.checkArrayBounds(this.size(), srcPos, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destPos] = Integer.toBinaryString(this.get(srcPos + i));
        }
    }

    @Override
    public void copyValuesFrom(CommonArrayFS<Integer> v) {
        Spliterator.OfInt si;
        this.clear();
        if (v instanceof IntegerArrayList) {
            si = ((IntegerArrayList)v).spliterator();
        } else if (v instanceof IntegerArray) {
            si = ((IntegerArray)v).spliterator();
        } else {
            throw new ClassCastException("argument must be of class IntegerArray or IntegerArrayList");
        }
        si.forEachRemaining(i -> this.add(i));
    }

    public static IntegerArrayList create(JCas jcas, int[] a) {
        IntegerArrayList ial = new IntegerArrayList(jcas, a.length);
        ial.copyFromArray(a, 0, 0, a.length);
        return ial;
    }

    @Override
    public FeatureStructureImplC _superClone() {
        return this.clone();
    }

    public boolean contains(int i) {
        return this.indexOf(i) != -1;
    }

    public int indexOf(int i) {
        if (null == this.intArrayAsList) {
            return this.intArrayList.indexOf(i);
        }
        return this.intArrayAsList.indexOf(i);
    }

    public int lastIndexOf(int i) {
        if (null == this.intArrayAsList) {
            return this.intArrayList.lastIndexOf(i);
        }
        return this.intArrayAsList.lastIndexOf(i);
    }

    public int[] toArray(int[] a) {
        return null == this.intArrayAsList ? this.intArrayList.toArray() : this.intArrayAsList.toArray();
    }

    @Override
    public String toString() {
        return String.format("IntegerArrayList[size: %,d]", this.size());
    }

    public boolean add(int e) {
        this.maybeStartUsingIntegerArrayList();
        this.intArrayList.add(e);
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof IntegerArrayList) {
            IntegerArrayList other = (IntegerArrayList)o;
            if (this.size() == other.size()) {
                for (int i = this.size() - 1; i >= 0; --i) {
                    if (this.get(i) == other.get(i)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void add(int index, int element) {
        this.maybeStartUsingIntegerArrayList();
        this.intArrayList.add(index, element);
    }

    public int removeAt(int index) {
        this.maybeStartUsingIntegerArrayList();
        return this.intArrayList.remove(index);
    }

    public boolean remove(int o) {
        this.maybeStartUsingIntegerArrayList();
        int pos = this.intArrayList.indexOf(o);
        if (pos >= 0) {
            this.intArrayList.remove(pos);
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hc = 1;
        int prime = 31;
        for (int i = this.size() - 1; i >= 0; ++i) {
            hc = hc * 31 + i;
            hc = hc * 31 + this.get(i);
        }
        return hc;
    }

    public void clear() {
        this.maybeStartUsingIntegerArrayList();
        this.intArrayList.removeAllElements();
    }

    public PrimitiveIterator.OfInt iterator() {
        return null == this.intArrayAsList ? this.intArrayList.iterator() : this.intArrayAsList.iterator();
    }

    public IntListIterator intListIterator() {
        return null == this.intArrayAsList ? this.intArrayList.intListIterator() : this.intArrayAsList.intListIterator();
    }

    public void sort() {
        if (null == this.intArrayAsList) {
            this.intArrayList.sort();
        } else {
            this.intArrayAsList.sort();
        }
    }

    public Spliterator.OfInt spliterator() {
        return null == this.intArrayAsList ? Arrays.spliterator(this.intArrayList.toIntArray()) : Arrays.spliterator(this.getIntArray()._getTheArray());
    }

    public IntStream stream() {
        return StreamSupport.intStream(this.spliterator(), false);
    }

    public void forEach(IntConsumer action) {
        PrimitiveIterator.OfInt ii = this.iterator();
        while (ii.hasNext()) {
            action.accept(ii.nextInt());
        }
    }

    static {
        type = typeIndexID = JCasRegistry.register(IntegerArrayList.class);
        _FC_intArray = TypeSystemImpl.createCallSite(IntegerArrayList.class, _FeatName_intArray);
        _FH_intArray = _FC_intArray.dynamicInvoker();
    }
}

