/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.RandomAccess;
import java.util.Set;
import java.util.Spliterator;
import org.apache.uima.UimaSerializableFSs;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FeatureStructureImplC;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.SelectViaCopyToArray;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.util.impl.Constants;

public class FSHashSet<T extends TOP>
extends TOP
implements UimaSerializableFSs,
SelectViaCopyToArray,
Set<T>,
RandomAccess,
Cloneable {
    public static final String _TypeName = "org.apache.uima.jcas.cas.FSHashSet";
    public static final int typeIndexID;
    public static final int type;
    private boolean isPendingInit = false;
    private boolean isSaveNeeded = false;
    private final HashSet<T> fsHashSet;
    public static final String _FeatName_fsArray = "fsArray";
    private static final CallSite _FC_fsArray;
    private static final MethodHandle _FH_fsArray;

    @Override
    public int getTypeIndexID() {
        return typeIndexID;
    }

    protected FSHashSet() {
        this.fsHashSet = null;
    }

    public FSHashSet(TypeImpl type, CASImpl casImpl) {
        this(new HashSet(), type, casImpl);
    }

    public FSHashSet(HashSet<T> set, TypeImpl type, CASImpl casImpl) {
        super(type, casImpl);
        this.fsHashSet = set;
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
    }

    public FSHashSet(JCas jcas) {
        this(new HashSet(), jcas);
    }

    public FSHashSet(HashSet<T> set, JCas jcas) {
        super(jcas);
        this.fsHashSet = set;
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
    }

    public FSHashSet(JCas jcas, int length) {
        this(new HashSet(length), jcas, length);
    }

    public FSHashSet(HashSet<T> set, JCas jcas, int length) {
        super(jcas);
        this._casView.validateArraySize(length);
        this.fsHashSet = set;
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
    }

    private FSArray<T> getFsArray() {
        return (FSArray)this._getFeatureValueNc(FSHashSet.wrapGetIntCatchException(_FH_fsArray));
    }

    private void setFsArray(FSArray<T> v) {
        this._setFeatureValueNcWj(FSHashSet.wrapGetIntCatchException(_FH_fsArray), v);
    }

    @Override
    public void _init_from_cas_data() {
        this.isPendingInit = true;
    }

    private void maybeLazyInit() {
        if (this.isPendingInit) {
            this.lazyInit();
        }
    }

    private void lazyInit() {
        this.isPendingInit = false;
        this.fsHashSet.clear();
        FSArray<T> a = this.getFsArray();
        for (TOP fs : a) {
            this.fsHashSet.add(fs);
        }
    }

    @Override
    public void _save_to_cas_data() {
        if (this.isSaveNeeded) {
            this.isSaveNeeded = false;
            FSArray<T> fsa = this.getFsArray();
            if (fsa == null || fsa.size() != this.fsHashSet.size()) {
                fsa = new FSArray(this._casView.getJCasImpl(), this.fsHashSet.size());
                this.setFsArray(fsa);
            }
            int i = 0;
            for (TOP fs : this.fsHashSet) {
                Object currentValue = fsa.get(i);
                if (currentValue != fs) {
                    fsa.set_without_PEAR_conversion(i, fs);
                }
                ++i;
            }
        }
    }

    public T[] _toArrayForSelect() {
        return this.toArray();
    }

    @Override
    public FeatureStructureImplC _superClone() {
        return this.clone();
    }

    private TOP[] gta() {
        FSArray<T> fsa = this.getFsArray();
        if (null == fsa) {
            return Constants.EMPTY_TOP_ARRAY;
        }
        return fsa._getTheArray();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof FSHashSet)) {
            return false;
        }
        FSHashSet other = (FSHashSet)o;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        this.maybeLazyInit();
        other.maybeLazyInit();
        return this.fsHashSet.equals(other.fsHashSet);
    }

    @Override
    public int hashCode() {
        this.maybeLazyInit();
        return this.fsHashSet.hashCode();
    }

    @Override
    public T[] toArray() {
        if (this.isSaveNeeded) {
            TOP[] r = new TOP[this.size()];
            this.fsHashSet.toArray(r);
            return r;
        }
        return Arrays.copyOf(this.gta(), this.gta().length);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.maybeLazyInit();
        boolean r = this.fsHashSet.removeAll(c);
        if (r) {
            this.isSaveNeeded = true;
        }
        return r;
    }

    @Override
    public <N> N[] toArray(N[] a) {
        if (this.isSaveNeeded) {
            Object[] aa = this.fsHashSet.toArray(a);
            this._casView.swapInPearVersion(aa);
            return aa;
        }
        int sz = this.size();
        if (a.length < sz) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), sz);
        }
        TOP[] d = this.gta();
        System.arraycopy(d, 0, a, 0, d.length);
        this._casView.swapInPearVersion(a);
        return a;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.size() == 0) {
            return Collections.emptyIterator();
        }
        return new Iterator<T>(){
            private final Iterator<T> baseIt;
            {
                this.baseIt = FSHashSet.this.isSaveNeeded ? FSHashSet.this.fsHashSet.iterator() : FSHashSet.this.gtaIterator();
            }

            @Override
            public boolean hasNext() {
                return this.baseIt.hasNext();
            }

            @Override
            public T next() {
                return FSHashSet.this._maybeGetPearFs((TOP)this.baseIt.next());
            }
        };
    }

    private Iterator<T> gtaIterator() {
        return this.getFsArray().iterator();
    }

    @Override
    public int size() {
        return this.isSaveNeeded ? this.fsHashSet.size() : this.gta().length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        this.maybeLazyInit();
        return this.fsHashSet.contains(o instanceof TOP ? this._maybeGetBaseForPearFs((TOP)o) : o);
    }

    @Override
    public boolean add(T e) {
        this.maybeLazyInit();
        boolean r = this.fsHashSet.add(this._maybeGetBaseForPearFs(e));
        if (r) {
            this.isSaveNeeded = true;
        }
        return r;
    }

    @Override
    public boolean remove(Object o) {
        this.maybeLazyInit();
        boolean r = this.fsHashSet.remove(o instanceof TOP ? this._maybeGetBaseForPearFs((TOP)o) : o);
        if (r) {
            this.isSaveNeeded = true;
        }
        return r;
    }

    @Override
    public void clear() {
        if (this.size() == 0) {
            return;
        }
        this.maybeLazyInit();
        this.isSaveNeeded = true;
        this.fsHashSet.clear();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.maybeLazyInit();
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (c.size() == 0) {
            return false;
        }
        ArrayList<TOP> a = new ArrayList<TOP>(c.size());
        for (TOP item : c) {
            a.add(this._maybeGetBaseForPearFs(item));
        }
        this.maybeLazyInit();
        boolean r = this.fsHashSet.addAll(a);
        if (r) {
            this.isSaveNeeded = true;
        }
        return r;
    }

    @Override
    public Spliterator<T> spliterator() {
        Spliterator<Object> baseSi = this.isSaveNeeded ? this.fsHashSet.spliterator() : Arrays.asList(this.gta()).spliterator();
        return this._casView.makePearAware(baseSi);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c.size() == 0) {
            boolean wasNotEmpty = !this.isEmpty();
            this.clear();
            return wasNotEmpty;
        }
        Collection<?> cc = this._casView.collectNonPearVersions(c);
        this.maybeLazyInit();
        boolean r = this.fsHashSet.retainAll(cc);
        if (r) {
            this.isSaveNeeded = true;
        }
        return r;
    }

    @Override
    public String toString() {
        int maxLen = 10;
        return "FSHashSet [isPendingInit=" + this.isPendingInit + ", isSaveNeeded=" + this.isSaveNeeded + ", fsHashSet=" + (this.fsHashSet != null ? this.toString(this.fsHashSet, 10) : null) + "]";
    }

    private String toString(Collection<?> collection, int maxLen) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<?> iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
        }
        builder.append("]");
        return builder.toString();
    }

    static {
        type = typeIndexID = JCasRegistry.register(FSHashSet.class);
        _FC_fsArray = TypeSystemImpl.createCallSite(FSHashSet.class, _FeatName_fsArray);
        _FH_fsArray = _FC_fsArray.dynamicInvoker();
    }
}

