/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.CopyOnWriteIndexPart;
import org.apache.uima.internal.util.ObjHashSet;
import org.apache.uima.jcas.cas.TOP;

public class CopyOnWriteObjHashSet<T>
implements CopyOnWriteIndexPart {
    private ObjHashSet<T> ohs;
    private ObjHashSet<T> original;
    private final int original_size;

    public CopyOnWriteObjHashSet(ObjHashSet<T> original) {
        this.ohs = original;
        this.original = original;
        this.original_size = original.size();
    }

    @Override
    public void makeReadOnlyCopy() {
        this.ohs = new ObjHashSet<T>(this.ohs, true);
    }

    public int find(T obj) {
        return this.ohs.find(obj);
    }

    public T get(int index) {
        return this.ohs.get(index);
    }

    public int moveToNextFilled(int pos) {
        return this.ohs.moveToNextFilled(pos);
    }

    public int moveToPreviousFilled(int pos) {
        return this.ohs.moveToPreviousFilled(pos);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            protected int curPosition;
            {
                this.curPosition = CopyOnWriteObjHashSet.this.moveToNextFilled(0);
            }

            @Override
            public final boolean hasNext() {
                return this.curPosition < CopyOnWriteObjHashSet.this.getCapacity();
            }

            @Override
            public final T next() {
                if (this.curPosition >= CopyOnWriteObjHashSet.this.getCapacity()) {
                    throw new NoSuchElementException();
                }
                try {
                    Object r = CopyOnWriteObjHashSet.this.get(this.curPosition);
                    this.curPosition = CopyOnWriteObjHashSet.this.moveToNextFilled(this.curPosition + 1);
                    return r;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private int moveToPrevious(int position) {
                if (position >= CopyOnWriteObjHashSet.this.getCapacity()) {
                    return -1;
                }
                return CopyOnWriteObjHashSet.this.moveToPreviousFilled(position - 1);
            }
        };
    }

    public int moveTo(FeatureStructure fs) {
        return this.ohs.moveTo(fs);
    }

    public String toString() {
        return this.ohs.toString();
    }

    public int getCapacity() {
        return this.ohs.getCapacity();
    }

    @Override
    public final int size() {
        return this.original_size;
    }

    @Override
    public boolean isOriginal() {
        return this.ohs == this.original;
    }

    @Override
    public int copyToArray(TOP[] target, int startingIndexInTarget) {
        Iterator<T> it = this.iterator();
        int i = startingIndexInTarget;
        while (it.hasNext()) {
            target[i++] = (TOP)it.next();
        }
        return i;
    }
}

