/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.Comparator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.CopyOnWriteIndexPart;
import org.apache.uima.cas.impl.FsIndex_set_sorted;
import org.apache.uima.cas.impl.FsIterator_singletype;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.internal.util.CopyOnWriteOrderedFsSet_array;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.jcas.cas.TOP;

class FsIterator_set_sorted2<T extends FeatureStructure>
extends FsIterator_singletype<T> {
    protected CopyOnWriteOrderedFsSet_array ofsa;
    private int pos;
    protected final FsIndex_set_sorted<T> ll_index;
    protected final Comparator<TOP> comparatorMaybeNoTypeWithoutID;

    public FsIterator_set_sorted2(FsIndex_set_sorted<T> ll_index, CopyOnWriteIndexPart cow_wrapper, Comparator<TOP> comparatorMaybeNoTypeWithoutID) {
        super((TypeImpl)ll_index.getType());
        this.comparatorMaybeNoTypeWithoutID = comparatorMaybeNoTypeWithoutID;
        this.ll_index = ll_index;
        this.ofsa = (CopyOnWriteOrderedFsSet_array)cow_wrapper;
        this.pos = this.ofsa.a_firstUsedslot;
    }

    @Override
    public boolean maybeReinitIterator() {
        if (!this.ofsa.isOriginal()) {
            this.ofsa = (CopyOnWriteOrderedFsSet_array)this.ll_index.getNonNullCow();
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.pos >= this.ofsa.a_firstUsedslot && this.pos < this.ofsa.a_nextFreeslot;
    }

    @Override
    public T getNvc() {
        return (T)this.ofsa.a[this.pos];
    }

    @Override
    public void moveToNextNvc() {
        ++this.pos;
    }

    @Override
    public void moveToPreviousNvc() {
        --this.pos;
    }

    @Override
    public void moveToFirstNoReinit() {
        this.pos = this.ofsa.a_firstUsedslot;
    }

    @Override
    public void moveToLastNoReinit() {
        this.pos = this.ofsa.a_nextFreeslot - 1;
    }

    @Override
    public void moveToNoReinit(FeatureStructure fs) {
        this.pos = this.ofsa.getOfsa().find((TOP)fs, this.comparatorMaybeNoTypeWithoutID);
        if (this.pos < 0) {
            this.pos = -this.pos - 1;
            return;
        }
        int savedPos = this.pos;
        this.moveToPreviousNvc();
        if (this.isValid()) {
            if (0 == this.comparatorMaybeNoTypeWithoutID.compare((TOP)this.get(), (TOP)fs)) {
                this.moveToLeftMost(fs);
            } else {
                this.pos = savedPos;
            }
        } else {
            this.pos = savedPos;
        }
    }

    @Override
    public FsIterator_singletype<T> copy() {
        FsIterator_set_sorted2<T> r = new FsIterator_set_sorted2<T>(this.ll_index, this.ofsa, this.comparatorMaybeNoTypeWithoutID);
        r.pos = this.pos;
        return r;
    }

    @Override
    public int ll_indexSizeMaybeNotCurrent() {
        return this.ofsa.size();
    }

    @Override
    public LowLevelIndex<T> ll_getIndex() {
        return this.ll_index;
    }

    @Override
    public int ll_maxAnnotSpan() {
        FsIndex_set_sorted<T> ss_idx = this.ll_index;
        return ss_idx.isAnnotIdx ? ss_idx.ll_maxAnnotSpan() : Integer.MAX_VALUE;
    }

    @Override
    public boolean isIndexesHaveBeenUpdated() {
        return this.ofsa != this.ll_index.getCopyOnWriteIndexPart();
    }

    private void moveToLeftMost(FeatureStructure fs) {
        boolean comparedEqual = false;
        int origPos = this.pos;
        int span = 1;
        while (this.isValid()) {
            int upperValidPos = this.pos;
            this.pos = origPos - span;
            this.pos = Math.max(-1, this.pos);
            if (!this.isValid()) {
                this.moveToLeftMostUp(fs, upperValidPos);
                return;
            }
            boolean bl = comparedEqual = 0 == this.comparatorMaybeNoTypeWithoutID.compare((TOP)this.get(), (TOP)fs);
            if (!comparedEqual) {
                this.moveToLeftMostUp(fs, upperValidPos);
                return;
            }
            span <<= 1;
        }
    }

    private void moveToLeftMostUp(FeatureStructure fs, int upperValidPos) {
        if (this.pos < this.ofsa.a_firstUsedslot) {
            this.moveToFirst();
        } else {
            this.moveToNext();
        }
        if (!this.isValid()) {
            Misc.internalError();
        }
        if (this.pos == upperValidPos) {
            return;
        }
        this.pos = this.ofsa.getOfsa().binarySearchLeftMostEqual((TOP)fs, this.pos, upperValidPos, this.comparatorMaybeNoTypeWithoutID);
    }

    @Override
    public Comparator<TOP> getComparator() {
        return this.comparatorMaybeNoTypeWithoutID;
    }

    @Override
    public boolean isMoveToSupported() {
        return this.ll_getIndex().isSorted();
    }
}

