/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Comparator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.jcas.cas.TOP;

public abstract class FsIterator_multiple_indexes<T extends FeatureStructure>
implements LowLevelIterator<T> {
    protected final LowLevelIterator<T>[] allIterators;
    private LowLevelIterator<T>[] emptyIterators;
    protected LowLevelIterator<T>[] nonEmptyIterators;
    protected final Comparator<TOP> comparatorMaybeNoTypeWithoutId;
    protected final LowLevelIndex<T> main_idx;

    public FsIterator_multiple_indexes(LowLevelIndex<T> main_idx, LowLevelIterator<T>[] iterators, Comparator<TOP> comparatorMaybeNoTypeWithoutId) {
        this.allIterators = iterators;
        this.main_idx = main_idx;
        this.comparatorMaybeNoTypeWithoutId = comparatorMaybeNoTypeWithoutId;
        this.separate_into_empty_indexes_and_non_empty_iterators();
    }

    public FsIterator_multiple_indexes(FsIterator_multiple_indexes<T> v) {
        this.allIterators = (LowLevelIterator[])v.allIterators.clone();
        this.main_idx = v.main_idx;
        this.comparatorMaybeNoTypeWithoutId = v.comparatorMaybeNoTypeWithoutId;
        int i = 0;
        for (LowLevelIterator<T> it : this.allIterators) {
            this.allIterators[i++] = (LowLevelIterator)it.copy();
        }
        this.separate_into_empty_indexes_and_non_empty_iterators();
    }

    protected void separate_into_empty_indexes_and_non_empty_iterators() {
        ArrayList<LowLevelIterator<T>> emptyIteratorsAl = new ArrayList<LowLevelIterator<T>>();
        ArrayList<LowLevelIterator<T>> nonEmptyIteratorsAl = new ArrayList<LowLevelIterator<T>>();
        for (LowLevelIterator<T> it : this.allIterators) {
            LowLevelIndex<T> idx = it.ll_getIndex();
            if (idx == null || idx.size() == 0) {
                emptyIteratorsAl.add(it);
                continue;
            }
            nonEmptyIteratorsAl.add(it);
        }
        this.emptyIterators = emptyIteratorsAl.toArray(new LowLevelIterator[emptyIteratorsAl.size()]);
        this.nonEmptyIterators = nonEmptyIteratorsAl.toArray(new LowLevelIterator[nonEmptyIteratorsAl.size()]);
    }

    @Override
    public int ll_indexSizeMaybeNotCurrent() {
        int sz = 0;
        for (LowLevelIterator<T> it : this.nonEmptyIterators) {
            sz += it.ll_indexSizeMaybeNotCurrent();
        }
        return sz;
    }

    @Override
    public int ll_maxAnnotSpan() {
        int span = -1;
        for (LowLevelIterator<T> it : this.nonEmptyIterators) {
            int s = it.ll_maxAnnotSpan();
            if (s == Integer.MAX_VALUE) {
                return s;
            }
            if (s <= span) continue;
            span = s;
        }
        return span == -1 ? Integer.MAX_VALUE : span;
    }

    @Override
    public boolean isIndexesHaveBeenUpdated() {
        for (LowLevelIterator<T> it : this.nonEmptyIterators) {
            if (!it.isIndexesHaveBeenUpdated()) continue;
            return true;
        }
        return this.empty_became_nonEmpty();
    }

    @Override
    public boolean maybeReinitIterator() {
        boolean empty_became_nonEmpty = this.empty_became_nonEmpty();
        if (empty_became_nonEmpty) {
            this.separate_into_empty_indexes_and_non_empty_iterators();
        }
        boolean any = false;
        for (LowLevelIterator<T> it : this.nonEmptyIterators) {
            any |= it.maybeReinitIterator();
        }
        return any;
    }

    private boolean empty_became_nonEmpty() {
        for (LowLevelIterator<T> it : this.emptyIterators) {
            if (it.ll_getIndex().size() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public LowLevelIndex<T> ll_getIndex() {
        return this.main_idx != null ? this.main_idx : this.allIterators[0].ll_getIndex();
    }
}

