/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.Comparator;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.jcas.cas.TOP;

class FilteredIterator<T extends FeatureStructure>
implements LowLevelIterator<T> {
    private LowLevelIterator<T> it;
    private FSMatchConstraint cons;

    private FilteredIterator() {
    }

    FilteredIterator(FSIterator<T> it, FSMatchConstraint cons) {
        this();
        this.it = (LowLevelIterator)it;
        this.cons = cons;
        this.moveToFirst();
    }

    @Override
    public boolean isValid() {
        return this.it.isValid();
    }

    private void adjustForConstraintForward() {
        while (this.it.isValid() && !this.cons.match((FeatureStructure)this.it.get())) {
            this.it.moveToNext();
        }
    }

    private void adjustForConstraintBackward() {
        while (this.it.isValid() && !this.cons.match((FeatureStructure)this.it.get())) {
            this.it.moveToPrevious();
        }
    }

    @Override
    public void moveToFirstNoReinit() {
        this.it.moveToFirstNoReinit();
        this.adjustForConstraintForward();
    }

    @Override
    public void moveToLastNoReinit() {
        this.it.moveToLast();
        this.adjustForConstraintBackward();
    }

    @Override
    public void moveToNextNvc() {
        this.it.moveToNextNvc();
        this.adjustForConstraintForward();
    }

    @Override
    public void moveToPreviousNvc() {
        this.it.moveToPreviousNvc();
        this.adjustForConstraintBackward();
    }

    @Override
    public T getNvc() {
        return this.it.getNvc();
    }

    @Override
    public FSIterator<T> copy() {
        return new FilteredIterator(this.it.copy(), this.cons);
    }

    @Override
    public void moveToNoReinit(FeatureStructure fs) {
        this.it.moveToNoReinit(fs);
        this.adjustForConstraintForward();
    }

    @Override
    public int ll_indexSizeMaybeNotCurrent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LowLevelIndex<T> ll_getIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int ll_maxAnnotSpan() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isIndexesHaveBeenUpdated() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean maybeReinitIterator() {
        return this.it.maybeReinitIterator();
    }

    @Override
    public Comparator<TOP> getComparator() {
        return this.it.getComparator();
    }
}

