/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ID3v23PreferredFrameOrderComparator
implements Comparator<String> {
    private static ID3v23PreferredFrameOrderComparator comparator;
    private static List frameIdsInPreferredOrder;

    private ID3v23PreferredFrameOrderComparator() {
    }

    public static ID3v23PreferredFrameOrderComparator getInstanceof() {
        if (comparator == null) {
            comparator = new ID3v23PreferredFrameOrderComparator();
        }
        return comparator;
    }

    @Override
    public int compare(String frameId1, String frameId2) {
        int frameId2Index;
        int frameId1Index = frameIdsInPreferredOrder.indexOf(frameId1);
        if (frameId1Index == -1) {
            frameId1Index = Integer.MAX_VALUE;
        }
        if ((frameId2Index = frameIdsInPreferredOrder.indexOf(frameId2)) == -1) {
            frameId2Index = Integer.MAX_VALUE;
        }
        if (frameId1Index == frameId2Index) {
            return frameId1.compareTo(frameId2);
        }
        return frameId1Index - frameId2Index;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ID3v23PreferredFrameOrderComparator;
    }

    static {
        frameIdsInPreferredOrder = new ArrayList();
        frameIdsInPreferredOrder.add("UFID");
        frameIdsInPreferredOrder.add("TIT2");
        frameIdsInPreferredOrder.add("TPE1");
        frameIdsInPreferredOrder.add("TALB");
        frameIdsInPreferredOrder.add("TORY");
        frameIdsInPreferredOrder.add("TCON");
        frameIdsInPreferredOrder.add("TCOM");
        frameIdsInPreferredOrder.add("TPE3");
        frameIdsInPreferredOrder.add("TIT1");
        frameIdsInPreferredOrder.add("TRCK");
        frameIdsInPreferredOrder.add("TYER");
        frameIdsInPreferredOrder.add("TDAT");
        frameIdsInPreferredOrder.add("TIME");
        frameIdsInPreferredOrder.add("TBPM");
        frameIdsInPreferredOrder.add("TSRC");
        frameIdsInPreferredOrder.add("TORY");
        frameIdsInPreferredOrder.add("TPE2");
        frameIdsInPreferredOrder.add("TIT3");
        frameIdsInPreferredOrder.add("USLT");
        frameIdsInPreferredOrder.add("TXXX");
        frameIdsInPreferredOrder.add("WXXX");
        frameIdsInPreferredOrder.add("WOAR");
        frameIdsInPreferredOrder.add("WCOM");
        frameIdsInPreferredOrder.add("WCOP");
        frameIdsInPreferredOrder.add("WOAF");
        frameIdsInPreferredOrder.add("WORS");
        frameIdsInPreferredOrder.add("WPAY");
        frameIdsInPreferredOrder.add("WPUB");
        frameIdsInPreferredOrder.add("WCOM");
        frameIdsInPreferredOrder.add("TEXT");
        frameIdsInPreferredOrder.add("TMED");
        frameIdsInPreferredOrder.add("IPLS");
        frameIdsInPreferredOrder.add("TLAN");
        frameIdsInPreferredOrder.add("TSOT");
        frameIdsInPreferredOrder.add("TDLY");
        frameIdsInPreferredOrder.add("PCNT");
        frameIdsInPreferredOrder.add("POPM");
        frameIdsInPreferredOrder.add("TPUB");
        frameIdsInPreferredOrder.add("TSO2");
        frameIdsInPreferredOrder.add("TSOC");
        frameIdsInPreferredOrder.add("TCMP");
        frameIdsInPreferredOrder.add("TSOT");
        frameIdsInPreferredOrder.add("TSOP");
        frameIdsInPreferredOrder.add("TSOA");
        frameIdsInPreferredOrder.add("XSOT");
        frameIdsInPreferredOrder.add("XSOP");
        frameIdsInPreferredOrder.add("XSOA");
        frameIdsInPreferredOrder.add("TSO2");
        frameIdsInPreferredOrder.add("TSOC");
        frameIdsInPreferredOrder.add("COMM");
        frameIdsInPreferredOrder.add("TRDA");
        frameIdsInPreferredOrder.add("COMR");
        frameIdsInPreferredOrder.add("TCOP");
        frameIdsInPreferredOrder.add("TENC");
        frameIdsInPreferredOrder.add("ENCR");
        frameIdsInPreferredOrder.add("EQUA");
        frameIdsInPreferredOrder.add("ETCO");
        frameIdsInPreferredOrder.add("TOWN");
        frameIdsInPreferredOrder.add("TFLT");
        frameIdsInPreferredOrder.add("GRID");
        frameIdsInPreferredOrder.add("TSSE");
        frameIdsInPreferredOrder.add("TKEY");
        frameIdsInPreferredOrder.add("TLEN");
        frameIdsInPreferredOrder.add("LINK");
        frameIdsInPreferredOrder.add("TSIZ");
        frameIdsInPreferredOrder.add("MLLT");
        frameIdsInPreferredOrder.add("TOPE");
        frameIdsInPreferredOrder.add("TOFN");
        frameIdsInPreferredOrder.add("TOLY");
        frameIdsInPreferredOrder.add("TOAL");
        frameIdsInPreferredOrder.add("OWNE");
        frameIdsInPreferredOrder.add("POSS");
        frameIdsInPreferredOrder.add("TRSN");
        frameIdsInPreferredOrder.add("TRSO");
        frameIdsInPreferredOrder.add("RBUF");
        frameIdsInPreferredOrder.add("TPE4");
        frameIdsInPreferredOrder.add("RVRB");
        frameIdsInPreferredOrder.add("TPOS");
        frameIdsInPreferredOrder.add("SYLT");
        frameIdsInPreferredOrder.add("SYTC");
        frameIdsInPreferredOrder.add("USER");
        frameIdsInPreferredOrder.add("APIC");
        frameIdsInPreferredOrder.add("PRIV");
        frameIdsInPreferredOrder.add("MCDI");
        frameIdsInPreferredOrder.add("AENC");
        frameIdsInPreferredOrder.add("GEOB");
    }
}

