/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef.msg;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.freeutils.tnef.Attachment;
import net.freeutils.tnef.Attr;
import net.freeutils.tnef.MAPIPropName;
import net.freeutils.tnef.MAPIProps;
import net.freeutils.tnef.Message;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEF;
import net.freeutils.tnef.TNEFUtils;
import net.freeutils.tnef.msg.Properties;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Msg {
    public static void printDirectory(DirectoryEntry dir, String linePrefix) throws IOException {
        for (Entry entry : dir) {
            String name = entry.getName();
            if (entry instanceof DirectoryEntry) {
                System.out.println(linePrefix + name + "/");
                Msg.printDirectory((DirectoryEntry)entry, linePrefix + "  ");
                continue;
            }
            if (entry instanceof DocumentEntry) {
                System.out.println(linePrefix + name + "  " + Msg.toRawInputStream((DocumentEntry)entry));
                continue;
            }
            System.out.println(linePrefix + name + " (UNKNOWN entry type)");
        }
    }

    public static Message processMessage(InputStream in) throws IOException {
        POIFSFileSystem fs = new POIFSFileSystem(in);
        return Msg.processMessage((DirectoryEntry)fs.getRoot());
    }

    public static Message processMessage(DirectoryEntry dir) throws IOException {
        return Msg.processMessage(dir, null, true);
    }

    protected static Message processMessage(DirectoryEntry dir, Map<Integer, MAPIPropName> names, boolean isRoot) throws IOException {
        Message message = new Message();
        if (isRoot) {
            try {
                names = Properties.processNameIDs(dir);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        Properties properties = Properties.processProperties(dir, isRoot ? 32 : 24, names);
        MAPIProps mapiProps = new MAPIProps(properties.toArray());
        message.addAttribute(new Attr(1, 6, 36867, mapiProps));
        MAPIProps[] recipients = Msg.processRecipients(dir, properties.recipientCount, names);
        message.addAttribute(new Attr(1, 6, 36868, recipients));
        List<Attachment> attachments = Msg.processAttachments(dir, properties.attachmentCount, names);
        message.setAttachments(attachments);
        return message;
    }

    protected static MAPIProps[] processRecipients(DirectoryEntry dir, int recipientCount, Map<Integer, MAPIPropName> names) throws IOException {
        ArrayList<MAPIProps> recipients = new ArrayList<MAPIProps>(Math.min(recipientCount, 2048));
        for (int i = 0; i < recipientCount; ++i) {
            String entryName = "__recip_version1.0_#" + TNEFUtils.toHexString(i, 8);
            Entry entry = dir.getEntry(entryName);
            Properties properties = Properties.processProperties((DirectoryEntry)entry, 8, names);
            recipients.add(new MAPIProps(properties.toArray()));
        }
        return recipients.toArray(new MAPIProps[recipients.size()]);
    }

    protected static List<Attachment> processAttachments(DirectoryEntry dir, int attachmentCount, Map<Integer, MAPIPropName> names) throws IOException {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>(Math.min(attachmentCount, 2048));
        for (int i = 0; i < attachmentCount; ++i) {
            String entryName = "__attach_version1.0_#" + TNEFUtils.toHexString(i, 8);
            Entry entry = dir.getEntry(entryName);
            Attachment attachment = Msg.processAttachment((DirectoryEntry)entry, names);
            attachments.add(attachment);
        }
        return attachments;
    }

    protected static Attachment processAttachment(DirectoryEntry dir, Map<Integer, MAPIPropName> names) throws IOException {
        Properties properties = Properties.processProperties(dir, 8, names);
        Attachment att = new Attachment();
        MAPIProps props = new MAPIProps(properties.toArray());
        att.setMAPIProps(props);
        Integer type = (Integer)props.getPropValue(14085);
        if (type != null) {
            if (type == 5) {
                DirectoryEntry entry = (DirectoryEntry)dir.getEntry("__substg1.0_3701000D");
                att.setNestedMessage(Msg.processMessage(entry, names, false));
            } else if (type == 6) {
                DirectoryEntry entry = (DirectoryEntry)dir.getEntry("__substg1.0_3701000D");
                Msg.processEmbeddedObject(entry, att);
            }
        }
        return att;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void processEmbeddedObject(DirectoryEntry entry, Attachment att) throws IOException {
        RawInputStream data = null;
        if (entry.hasEntry("CONTENTS")) {
            data = Msg.toRawInputStream((DocumentEntry)entry.getEntry("CONTENTS"));
        } else if (entry.hasEntry("\u0001Ole10Native")) {
            RawInputStream in = Msg.toRawInputStream((DocumentEntry)entry.getEntry("\u0001Ole10Native"));
            try {
                long length = in.readU32();
                RawInputStream potential = new RawInputStream(in, 0L, length);
                try {
                    int flags = in.readU16();
                    if (flags == 2) {
                        potential.close();
                        potential = new RawInputStream(in, 0L, length - 2L);
                        String label = Msg.readString(in, 65536);
                        if (label.length() > 0 && label.charAt(0) >= ' ') {
                            potential.close();
                            String filename = Msg.readString(in, 1024);
                            int flags2 = in.readU16();
                            int unknown = in.readU16();
                            length = in.readU32();
                            String command = in.readString((int)length);
                            length = in.readU32();
                            potential = new RawInputStream(in, 0L, length);
                            att.setFilename(filename);
                        }
                    }
                    data = potential;
                }
                finally {
                    if (data != potential) {
                        potential.close();
                    }
                }
            }
            finally {
                in.close();
            }
        }
        att.setRawData(data);
    }

    protected static String readString(RawInputStream in, int maxLength) throws IOException {
        int b;
        byte[] buf = new byte[Math.min(maxLength, in.available())];
        int len = 0;
        do {
            if ((b = in.read()) < 0) {
                throw new EOFException("unexpected end of stream");
            }
            buf[len++] = (byte)b;
        } while (b > 0);
        return TNEFUtils.createString(buf, 0, len);
    }

    protected static RawInputStream toRawInputStream(DocumentEntry entry) throws IOException {
        DocumentInputStream in = new DocumentInputStream(entry);
        ByteArrayOutputStream out = new ByteArrayOutputStream(in.available());
        TNEFUtils.transfer((InputStream)in, out, -1L, true, false);
        return new RawInputStream(out.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length < 1 || args.length > 2) {
            String usage = "Usage: java net.freeutils.tnef.msg.Msg <msgfile> [outputdir]\n\nExample: java net.freeutils.tnef.msg.Msg c:\\temp\\saved.msg c:\\temp\\attachments\n";
            System.out.println(usage);
            System.exit(1);
        }
        String filename = args[0];
        String outputdir = args.length < 2 ? "." : args[1];
        Message message = null;
        FileInputStream in = new FileInputStream(filename);
        try {
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)in);
            DirectoryNode root = fs.getRoot();
            message = Msg.processMessage((DirectoryEntry)root);
            TNEF.extractContent(message, outputdir);
        }
        catch (Throwable throwable) {
            TNEFUtils.closeAll((Closeable[])new Closeable[]{in, message});
            throw throwable;
        }
        TNEFUtils.closeAll((Closeable[])new Closeable[]{in, message});
    }
}

