/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef;

import java.io.IOException;
import net.freeutils.tnef.Address;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFUtils;

public class TRPAddress
extends Address {
    public static final int trpidNull = 0;
    public static final int trpidUnresolved = 1;
    public static final int trpidResolvedNSID = 2;
    public static final int trpidResolvedAddress = 3;
    public static final int trpidOneOff = 4;
    public static final int trpidGroupNSID = 5;
    public static final int trpidOffline = 6;
    public static final int trpidIgnore = 7;
    public static final int trpidClassEntry = 8;
    public static final int trpidResolvedGroupAddress = 9;
    int id;

    public TRPAddress(RawInputStream data) throws IOException {
        int trpid = data.readU16();
        int cbgrtrp = data.readU16();
        int cch = data.readU16();
        int cbRgb = data.readU16();
        this.id = trpid;
        this.displayName = data.readString(cch);
        this.address = data.readString(cbRgb);
        int separator = this.address.indexOf(58);
        this.type = this.address.substring(0, separator);
        this.address = this.address.substring(separator + 1);
    }

    public TRPAddress(int id, String displayName, String type, String address) {
        this.id = id;
        this.displayName = displayName;
        this.type = type;
        this.address = address;
    }

    public int getID() {
        return this.id;
    }

    public String toString() {
        return TNEFUtils.getConstName(this.getClass(), "trpid", this.id) + ": " + super.toString();
    }
}

