/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef;

import net.freeutils.tnef.TNEFUtils;

public class GUID {
    String guid;

    public GUID(String guid) {
        this.guid = GUID.canonize(guid);
    }

    public GUID(byte[] guid) {
        StringBuilder s = new StringBuilder(32);
        for (byte b : GUID.reverse(guid)) {
            TNEFUtils.appendHexString(s, b & 0xFF, 2);
        }
        this.guid = GUID.canonize(s.toString());
    }

    public static String canonize(String guid) {
        int len = guid.length();
        if (len != 32 && len != 36) {
            throw new IllegalArgumentException("invalid GUID: " + guid + " (string length must be 32 without dashes, or 36 with dashes)");
        }
        char[] chars = new char[36];
        int src = 0;
        int dst = 0;
        while (src < len) {
            char c = guid.charAt(src);
            if (dst == 8 || dst == 13 || dst == 18 || dst == 23) {
                chars[dst++] = 45;
                if (len == 36) {
                    if (c != '-') {
                        throw new IllegalArgumentException("invalid GUID: " + guid + " ('-' expected at position " + src + ")");
                    }
                    c = guid.charAt(++src);
                }
            }
            if (c >= 'A' && c <= 'F') {
                c = (char)(c + 32);
            } else if (c < '0' || c > 'f' || c > '9' && c < 'a') {
                throw new IllegalArgumentException("invalid GUID: " + guid + " (invalid hex character at position " + src + ": '" + c + "')");
            }
            chars[dst] = c;
            ++src;
            ++dst;
        }
        return new String(chars);
    }

    public static byte[] reverse(byte[] guid) {
        if (guid.length != 16) {
            throw new IllegalArgumentException("invalid GUID (must be exactly 16 bytes long)");
        }
        byte[] reversed = new byte[16];
        reversed[0] = guid[3];
        reversed[1] = guid[2];
        reversed[2] = guid[1];
        reversed[3] = guid[0];
        reversed[4] = guid[5];
        reversed[5] = guid[4];
        reversed[6] = guid[7];
        reversed[7] = guid[6];
        System.arraycopy(guid, 8, reversed, 8, 8);
        return reversed;
    }

    public byte[] toByteArray() {
        byte[] b = new byte[16];
        int src = 0;
        for (int dst = 0; dst < 16; ++dst) {
            if (src == 8 || src == 13 || src == 18 || src == 23) {
                ++src;
            }
            b[dst] = (byte)(Integer.parseInt(this.guid.substring(src, src + 2), 16) & 0xFF);
            src += 2;
        }
        return GUID.reverse(b);
    }

    public String toString() {
        return this.guid;
    }

    public boolean equals(Object o) {
        return o instanceof GUID && this.guid.equals(((GUID)o).guid);
    }

    public int hashCode() {
        return this.guid.hashCode();
    }
}

