/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef;

import java.io.Closeable;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import net.freeutils.tnef.Address;
import net.freeutils.tnef.MAPIProp;
import net.freeutils.tnef.MAPIProps;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.RendData;
import net.freeutils.tnef.TNEFUtils;
import net.freeutils.tnef.TRPAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attr
implements Closeable {
    public static final int atpTriples = 0;
    public static final int atpString = 1;
    public static final int atpText = 2;
    public static final int atpDate = 3;
    public static final int atpShort = 4;
    public static final int atpLong = 5;
    public static final int atpByte = 6;
    public static final int atpWord = 7;
    public static final int atpDword = 8;
    public static final int atpMax = 9;
    public static final byte LVL_MESSAGE = 1;
    public static final byte LVL_ATTACHMENT = 2;
    public static final int attNull = 0;
    public static final int attFrom = 32768;
    public static final int attSubject = 32772;
    public static final int attDateSent = 32773;
    public static final int attDateRecd = 32774;
    public static final int attMessageStatus = 32775;
    public static final int attMessageClass = 32776;
    public static final int attMessageID = 32777;
    public static final int attParentID = 32778;
    public static final int attConversationID = 32779;
    public static final int attBody = 32780;
    public static final int attPriority = 32781;
    public static final int attAttachData = 32783;
    public static final int attAttachTitle = 32784;
    public static final int attAttachMetaFile = 32785;
    public static final int attAttachCreateDate = 32786;
    public static final int attAttachModifyDate = 32787;
    public static final int attDateModified = 32800;
    public static final int attAttachTransportFilename = 36865;
    public static final int attAttachRenddata = 36866;
    public static final int attMAPIProps = 36867;
    public static final int attRecipTable = 36868;
    public static final int attAttachment = 36869;
    public static final int attTnefVersion = 36870;
    public static final int attOemCodepage = 36871;
    public static final int attOriginalMessageClass = 6;
    public static final int attOwner = 0;
    public static final int attSentFor = 1;
    public static final int attDelegate = 2;
    public static final int attDateStart = 6;
    public static final int attDateEnd = 7;
    public static final int attAidOwner = 8;
    public static final int attRequestRes = 9;
    byte level;
    int type;
    int id;
    int length;
    RawInputStream rawData;
    Object data;

    public Attr(byte level, int type, int id, Object data) {
        this.level = level;
        this.type = type;
        this.id = id;
        this.data = data;
        this.length = -1;
    }

    public Attr(byte level, int type, int id, RawInputStream rawData) {
        this.level = level;
        this.type = type;
        this.id = id;
        this.rawData = rawData;
        this.length = rawData != null ? (int)rawData.getLength() : 0;
    }

    public byte getLevel() {
        return this.level;
    }

    public int getType() {
        return this.type;
    }

    public int getID() {
        return this.id;
    }

    public int getLength() {
        return this.length;
    }

    public RawInputStream getRawData() {
        return this.rawData;
    }

    @Override
    public void close() throws IOException {
        if (this.rawData != null) {
            this.rawData.close();
        }
        if (this.data instanceof Closeable) {
            ((Closeable)this.data).close();
        } else if (this.data instanceof MAPIProps[]) {
            TNEFUtils.closeAll((Closeable[])((MAPIProps[])this.data));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Attr:").append(" level=").append(this.level).append(" type=").append(TNEFUtils.getConstName(this.getClass(), "atp", this.type)).append(" id=").append(TNEFUtils.getConstName(this.getClass(), "att", this.id)).append(" length=").append(this.length).append(" value=");
        try {
            Object o = this.getValue();
            try {
                if (o instanceof MAPIProps[]) {
                    MAPIProps[] multiProps = (MAPIProps[])o;
                    for (int i = 0; i < multiProps.length; ++i) {
                        for (MAPIProp prop : multiProps[i].getProps()) {
                            s.append("\n  #").append(i).append(": ").append(prop);
                        }
                        multiProps[i].close();
                    }
                } else if (o instanceof MAPIProps) {
                    for (MAPIProp prop : ((MAPIProps)o).getProps()) {
                        s.append("\n  ").append(prop);
                    }
                } else {
                    s.append(o);
                }
            }
            finally {
                if (o instanceof Closeable) {
                    ((Closeable)o).close();
                }
            }
        }
        catch (IOException ioe) {
            s.append("ERROR: ").append(ioe);
        }
        return s.toString();
    }

    public Object getValue() throws IOException {
        if (this.rawData != null) {
            this.read(this.rawData);
        }
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void read(RawInputStream in) throws IOException {
        block21: {
            ris = new RawInputStream(in);
            o /* !! */  = null;
            try {
                switch (this.id) {
                    case 36866: {
                        o /* !! */  = new RendData(ris);
                        break;
                    }
                    case 32768: {
                        o /* !! */  = new TRPAddress(ris);
                        break;
                    }
                    case 0: 
                    case 1: {
                        o /* !! */  = new Address(ris);
                        break;
                    }
                    case 36868: {
                        count = (int)ris.readU32();
                        if (count * 4 > ris.available()) {
                            throw new IOException("count is too large: " + count);
                        }
                        recipients = new MAPIProps[count];
                        for (i = 0; i < count; ++i) {
                            recipients[i] = new MAPIProps(ris);
                        }
                        o /* !! */  = recipients;
                        break;
                    }
                    case 36867: {
                        o /* !! */  = new MAPIProps(ris);
                    }
                }
                if (o /* !! */  != null) break block21;
                switch (this.type) {
                    case 6: {
                        o /* !! */  = new RawInputStream(ris);
                        ** break;
lbl31:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        o /* !! */  = (short)ris.readU16();
                        ** break;
lbl35:
                        // 1 sources

                        break;
                    }
                    case 8: {
                        o /* !! */  = ris.readU32();
                        ** break;
lbl39:
                        // 1 sources

                        break;
                    }
                    case 5: {
                        o /* !! */  = ris.readU32();
                        ** break;
lbl43:
                        // 1 sources

                        break;
                    }
                    case 1: 
                    case 2: 
                    case 7: {
                        o /* !! */  = ris.readString(this.length);
                        ** break;
lbl47:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        if (ris.getLength() < 14L) ** break;
                        cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                        cal.set(ris.readU16(), ris.readU16() - 1, ris.readU16(), ris.readU16(), ris.readU16(), ris.readU16());
                        cal.set(14, 0);
                        o /* !! */  = cal.getTime();
                        ** break;
lbl55:
                        // 1 sources

                        break;
                    }
                    case 0: {
                        o /* !! */  = new TRPAddress(ris);
                        break;
                    }
                    ** default:
lbl60:
                    // 1 sources

                    break;
                }
            }
            finally {
                ris.close();
            }
        }
        this.data = o /* !! */ ;
    }

    public static Attr findAttr(List<Attr> attributes, int id) {
        if (attributes != null) {
            for (Attr attr : attributes) {
                if (attr.getID() != id) continue;
                return attr;
            }
        }
        return null;
    }
}

