/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util.regex;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.ctakes.core.util.Pair;
import org.apache.ctakes.core.util.regex.ThreadString;
import org.apache.log4j.Logger;

public final class RegexSpanFinder
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger((String)"RegexSpanFinder");
    private static final int DEFAULT_TIMEOUT_MILLIS = 1000;
    private static final int MIN_TIMEOUT_MILLIS = 100;
    private static final int MAX_TIMEOUT_MILLIS = 10000;
    private final ExecutorService _executor;
    private final Pattern _pattern;
    private final int _timeoutMillis;

    public RegexSpanFinder(String regex) throws IllegalArgumentException {
        this(Pattern.compile(regex));
    }

    public RegexSpanFinder(String regex, int timeoutMillis) throws IllegalArgumentException {
        this(Pattern.compile(regex), timeoutMillis);
    }

    public RegexSpanFinder(Pattern pattern) throws IllegalArgumentException {
        this(pattern, 1000);
    }

    public RegexSpanFinder(Pattern pattern, int timeoutMillis) throws IllegalArgumentException {
        if (pattern == null) {
            throw new PatternSyntaxException("Pattern cannot be null", "", -1);
        }
        if (timeoutMillis < 100 || timeoutMillis > 10000) {
            throw new IllegalArgumentException("Timeout must be between 100 and 10000");
        }
        this._pattern = pattern;
        this._timeoutMillis = timeoutMillis;
        this._executor = Executors.newSingleThreadExecutor();
    }

    public List<Pair<Integer>> findSpans(String text) {
        if (text == null || text.isEmpty()) {
            return Collections.emptyList();
        }
        ThreadString threadText = new ThreadString(text);
        RegexCallable callable = new RegexCallable(threadText, this._pattern);
        Future<List<Pair<Integer>>> future = this._executor.submit(callable);
        try {
            return future.get(this._timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException multE) {
            LOGGER.debug((Object)("Timeout for " + this._pattern));
            if (!future.cancel(true)) {
                LOGGER.error((Object)("Timed out but could not be cancelled while detecting " + this._pattern));
            }
            if (future.isCancelled()) {
                LOGGER.error((Object)("Cancelled while detecting " + this._pattern));
            } else if (!future.isDone()) {
                LOGGER.error((Object)("Not cancelled but didn't complete while detecting " + this._pattern));
            }
            return Collections.emptyList();
        }
    }

    @Override
    public void close() {
        this._executor.shutdownNow();
    }

    private static final class RegexCallable
    implements Callable<List<Pair<Integer>>> {
        private final CharSequence __text;
        private final Pattern __pattern;

        private RegexCallable(CharSequence text, Pattern pattern) {
            this.__text = text;
            this.__pattern = pattern;
        }

        @Override
        public List<Pair<Integer>> call() {
            ArrayList<Pair<Integer>> listBounds = new ArrayList<Pair<Integer>>();
            Matcher matcher = this.__pattern.matcher(this.__text);
            while (matcher.find() && !Thread.currentThread().isInterrupted()) {
                Pair<Integer> bounds = new Pair<Integer>(matcher.start(), matcher.end());
                if (bounds.getValue1() < 0 || bounds.getValue2() <= bounds.getValue1() || bounds.getValue2() > this.__text.length()) continue;
                listBounds.add(bounds);
            }
            return listBounds;
        }
    }
}

