/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ctakes.core.knowtator.KnowtatorAnnotation;
import org.apache.ctakes.core.knowtator.KnowtatorXMLParser;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.SHARPKnowtatorXMLDefaults;
import org.apache.ctakes.typesystem.type.refsem.Attribute;
import org.apache.ctakes.typesystem.type.refsem.BodyLaterality;
import org.apache.ctakes.typesystem.type.refsem.BodySide;
import org.apache.ctakes.typesystem.type.refsem.Course;
import org.apache.ctakes.typesystem.type.refsem.Date;
import org.apache.ctakes.typesystem.type.refsem.Event;
import org.apache.ctakes.typesystem.type.refsem.EventProperties;
import org.apache.ctakes.typesystem.type.refsem.LabDeltaFlag;
import org.apache.ctakes.typesystem.type.refsem.LabReferenceRange;
import org.apache.ctakes.typesystem.type.refsem.LabValue;
import org.apache.ctakes.typesystem.type.refsem.MedicationDosage;
import org.apache.ctakes.typesystem.type.refsem.MedicationDuration;
import org.apache.ctakes.typesystem.type.refsem.MedicationForm;
import org.apache.ctakes.typesystem.type.refsem.MedicationFrequency;
import org.apache.ctakes.typesystem.type.refsem.MedicationRoute;
import org.apache.ctakes.typesystem.type.refsem.MedicationStatusChange;
import org.apache.ctakes.typesystem.type.refsem.MedicationStrength;
import org.apache.ctakes.typesystem.type.refsem.OntologyConcept;
import org.apache.ctakes.typesystem.type.refsem.ProcedureDevice;
import org.apache.ctakes.typesystem.type.refsem.ProcedureMethod;
import org.apache.ctakes.typesystem.type.refsem.Severity;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.relation.AffectsTextRelation;
import org.apache.ctakes.typesystem.type.relation.AspectualTextRelation;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.CausesBringsAboutTextRelation;
import org.apache.ctakes.typesystem.type.relation.ComplicatesDisruptsTextRelation;
import org.apache.ctakes.typesystem.type.relation.DegreeOfTextRelation;
import org.apache.ctakes.typesystem.type.relation.IndicatesTextRelation;
import org.apache.ctakes.typesystem.type.relation.LocationOfTextRelation;
import org.apache.ctakes.typesystem.type.relation.ManagesTreatsTextRelation;
import org.apache.ctakes.typesystem.type.relation.ManifestationOfTextRelation;
import org.apache.ctakes.typesystem.type.relation.PreventsTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.relation.ResultOfTextRelation;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.structured.DocumentID;
import org.apache.ctakes.typesystem.type.textsem.AnatomicalSiteMention;
import org.apache.ctakes.typesystem.type.textsem.BodyLateralityModifier;
import org.apache.ctakes.typesystem.type.textsem.BodySideModifier;
import org.apache.ctakes.typesystem.type.textsem.ConditionalModifier;
import org.apache.ctakes.typesystem.type.textsem.CourseModifier;
import org.apache.ctakes.typesystem.type.textsem.DiseaseDisorderMention;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.GenericModifier;
import org.apache.ctakes.typesystem.type.textsem.HistoryOfModifier;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.LabDeltaFlagModifier;
import org.apache.ctakes.typesystem.type.textsem.LabEstimatedModifier;
import org.apache.ctakes.typesystem.type.textsem.LabInterpretationModifier;
import org.apache.ctakes.typesystem.type.textsem.LabMention;
import org.apache.ctakes.typesystem.type.textsem.LabReferenceRangeModifier;
import org.apache.ctakes.typesystem.type.textsem.LabValueModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationAllergyModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationDosageModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationDurationModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationFormModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationFrequencyModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationMention;
import org.apache.ctakes.typesystem.type.textsem.MedicationRouteModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationStatusChangeModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationStrengthModifier;
import org.apache.ctakes.typesystem.type.textsem.Modifier;
import org.apache.ctakes.typesystem.type.textsem.PolarityModifier;
import org.apache.ctakes.typesystem.type.textsem.ProcedureDeviceModifier;
import org.apache.ctakes.typesystem.type.textsem.ProcedureMention;
import org.apache.ctakes.typesystem.type.textsem.ProcedureMethodModifier;
import org.apache.ctakes.typesystem.type.textsem.SeverityModifier;
import org.apache.ctakes.typesystem.type.textsem.SignSymptomMention;
import org.apache.ctakes.typesystem.type.textsem.SubjectModifier;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textsem.UncertaintyModifier;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.CasIOUtil;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.util.UriUtils;
import org.jdom2.JDOMException;

@PipeBitInfo(name="Knowtator XML Reader (SHARP)", description="Reads annotations from SHARP schema Knowtator XML files in a directory.", role=PipeBitInfo.Role.SPECIAL, products={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION, PipeBitInfo.TypeProduct.EVENT, PipeBitInfo.TypeProduct.TIMEX, PipeBitInfo.TypeProduct.LOCATION_RELATION, PipeBitInfo.TypeProduct.DEGREE_RELATION, PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
public class SHARPKnowtatorXMLReader
extends JCasAnnotator_ImplBase {
    static Logger LOGGER = Logger.getLogger(SHARPKnowtatorXMLReader.class);
    public static final String PARAM_TEXT_DIRECTORY = "TextDirectory";
    @ConfigurationParameter(name="TextDirectory", mandatory=false, description="directory containing the text files (if DocumentIDs are just filenames); defaults to assuming that DocumentIDs are full file paths")
    private File textDirectory = null;
    public static final String PARAM_SET_DEFAULTS = "SetDefaults";
    @ConfigurationParameter(name="SetDefaults", description="whether or not to set default attribute values if no annotation is present")
    private boolean setDefaults;
    private static final Map<String, String> SUBJECT_KNOWTATOR_TO_UIMA_MAP = Maps.newHashMap();

    protected URI getTextURI(JCas jCas) {
        String textPath = ((DocumentID)JCasUtil.selectSingle((JCas)jCas, DocumentID.class)).getDocumentID();
        if (this.textDirectory != null) {
            textPath = this.textDirectory + File.separator + textPath;
        }
        File tmpFile = new File(textPath);
        URI answer = tmpFile.toURI();
        return answer;
    }

    protected URI getKnowtatorURI(JCas jCas) {
        File textURI = new File(this.getTextURI(jCas));
        String filename = textURI.getName().replace(".txt", "");
        File xmlPath = new File(textURI.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile(), "by-document/" + filename + "/" + filename + ".umls.knowtator.xml");
        return UriUtils.create((String)("file:" + xmlPath.getAbsolutePath()));
    }

    protected String[] getAnnotatorNames() {
        return new String[]{"consensus set annotator team"};
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Collection<KnowtatorAnnotation> annotations;
        String text = jCas.getDocumentText();
        URI textURI = this.getTextURI(jCas);
        LOGGER.info((Object)("processing " + textURI));
        URI knowtatorURI = this.getKnowtatorURI(jCas);
        if (!new File(knowtatorURI).exists()) {
            LOGGER.fatal((Object)("no such Knowtator XML file " + knowtatorURI));
            return;
        }
        KnowtatorXMLParser parser = new KnowtatorXMLParser(this.getAnnotatorNames());
        try {
            annotations = parser.parse(knowtatorURI);
        }
        catch (JDOMException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        HashSet<String> entityRelationTypes = new HashSet<String>();
        entityRelationTypes.add("affects");
        entityRelationTypes.add("causes/brings_about");
        entityRelationTypes.add("complicates/disrupts");
        entityRelationTypes.add("contraindicates");
        entityRelationTypes.add("degree_of");
        entityRelationTypes.add("diagnoses");
        entityRelationTypes.add("indicates");
        entityRelationTypes.add("is_indicated_for");
        entityRelationTypes.add("location_of");
        entityRelationTypes.add("manages/treats");
        entityRelationTypes.add("manifestation_of");
        entityRelationTypes.add("prevents");
        entityRelationTypes.add("result_of");
        HashSet<String> eventRelationTypes = new HashSet<String>();
        eventRelationTypes.add("TLINK");
        eventRelationTypes.add("ALINK");
        HashSet nonAnnotationTypes = Sets.newHashSet((Object[])new String[]{"Strength", "Frequency", "Value"});
        nonAnnotationTypes.addAll(entityRelationTypes);
        nonAnnotationTypes.addAll(eventRelationTypes);
        HashMap<String, TOP> idAnnotationMap = new HashMap<String, TOP>();
        ArrayList<DelayedRelation> delayedRelations = new ArrayList<DelayedRelation>();
        ArrayList<DelayedFeature> delayedFeatures = new ArrayList<DelayedFeature>();
        for (KnowtatorAnnotation annotation : annotations) {
            KnowtatorAnnotation number;
            KnowtatorAnnotation unit;
            LabReferenceRange attribute;
            BodySide attribute2;
            SubjectModifier modifier;
            ConditionalModifier modifier2;
            Object value;
            TimeMention timeMention;
            KnowtatorAnnotation alleviatingFactor;
            KnowtatorAnnotation bodyLaterality;
            AnatomicalSiteMention mention;
            HashMap<String, String> stringSlots = new HashMap<String, String>(annotation.stringSlots);
            HashMap<String, Boolean> booleanSlots = new HashMap<String, Boolean>(annotation.booleanSlots);
            HashMap<String, KnowtatorAnnotation> annotationSlots = new HashMap<String, KnowtatorAnnotation>(annotation.annotationSlots);
            KnowtatorAnnotation.Span coveringSpan = annotation.getCoveringSpan();
            if (nonAnnotationTypes.contains(annotation.type)) {
                if (coveringSpan.begin != Integer.MAX_VALUE || coveringSpan.end != Integer.MIN_VALUE) {
                    LOGGER.warn((Object)String.format("expected no span but found %s for '%s' with id '%s' in %s'", annotation.spans, annotation.type, annotation.id, knowtatorURI));
                }
            } else if (coveringSpan.begin == Integer.MAX_VALUE || coveringSpan.end == Integer.MIN_VALUE) {
                LOGGER.warn((Object)String.format("expected span but found none for '%s' with id '%s' in %s'", annotation.type, annotation.id, knowtatorURI));
            }
            if ("Anatomical_site".equals(annotation.type)) {
                mention = new AnatomicalSiteMention(jCas, coveringSpan.begin, coveringSpan.end);
                SHARPKnowtatorXMLReader.addIdentifiedAnnotationFeatures(annotation, (IdentifiedAnnotation)mention, jCas, 6, stringSlots, booleanSlots, annotationSlots, idAnnotationMap, delayedFeatures);
                bodyLaterality = (KnowtatorAnnotation)annotationSlots.remove("body_laterality");
                delayedFeatures.add(new DelayedFeature((Annotation)mention, "bodyLaterality", bodyLaterality));
                KnowtatorAnnotation bodySide = (KnowtatorAnnotation)annotationSlots.remove("body_side");
                delayedFeatures.add(new DelayedFeature((Annotation)mention, "bodySide", bodySide));
            } else if ("Clinical_attribute".equals(annotation.type)) {
                mention = new EventMention(jCas, coveringSpan.begin, coveringSpan.end);
                SHARPKnowtatorXMLReader.addIdentifiedAnnotationFeatures(annotation, (IdentifiedAnnotation)mention, jCas, 7, stringSlots, booleanSlots, annotationSlots, idAnnotationMap, delayedFeatures);
            } else if ("Devices".equals(annotation.type)) {
                mention = new EntityMention(jCas, coveringSpan.begin, coveringSpan.end);
                SHARPKnowtatorXMLReader.addIdentifiedAnnotationFeatures(annotation, (IdentifiedAnnotation)mention, jCas, 8, stringSlots, booleanSlots, annotationSlots, idAnnotationMap, delayedFeatures);
            } else if ("Disease_Disorder".equals(annotation.type)) {
                mention = new DiseaseDisorderMention(jCas, coveringSpan.begin, coveringSpan.end);
                SHARPKnowtatorXMLReader.addIdentifiedAnnotationFeatures(annotation, (IdentifiedAnnotation)mention, jCas, 2, stringSlots, booleanSlots, annotationSlots, idAnnotationMap, delayedFeatures);
                alleviatingFactor = (KnowtatorAnnotation)annotationSlots.remove("alleviating_factor");
                delayedFeatures.add(DelayedRelationFeature.forArg2((Annotation)mention, "alleviatingFactor", alleviatingFactor, ManagesTreatsTextRelation.class, EventMention.class));
                KnowtatorAnnotation signOrSymptom = (KnowtatorAnnotation)annotationSlots.remove("associated_sign_or_symptom");
                delayedFeatures.add(DelayedRelationFeature.forArg1((Annotation)mention, "associatedSignSymptom", signOrSymptom, ManifestationOfTextRelation.class, EventMention.class));
                KnowtatorAnnotation bodyLaterality2 = (KnowtatorAnnotation)annotationSlots.remove("body_laterality");
                delayedFeatures.add(new DelayedFeature((Annotation)mention, "bodyLaterality", bodyLaterality2));
                KnowtatorAnnotation bodyLocation = (KnowtatorAnnotation)annotationSlots.remove("body_location");
                delayedFeatures.add(DelayedRelationFeature.forArg1((Annotation)mention, "bodyLocation", bodyLocation, LocationOfTextRelation.class, AnatomicalSiteMention.class));
                KnowtatorAnnotation bodySide = (KnowtatorAnnotation)annotationSlots.remove("body_side");
                delayedFeatures.add(new DelayedFeature((Annotation)mention, "bodySide", bodySide));
                KnowtatorAnnotation course = (KnowtatorAnnotation)annotationSlots.remove("course");
                delayedFeatures.add(DelayedRelationFeature.forArg1((Annotation)mention, "course", course, DegreeOfTextRelation.class, CourseModifier.class));
                KnowtatorAnnotation exacerbatingFactor = (KnowtatorAnnotation)annotationSlots.remove("exacerbating_factor");
                delayedFeatures.add(DelayedRelationFeature.forArg2((Annotation)mention, "exacerbatingFactor", exacerbatingFactor, ComplicatesDisruptsTextRelation.class, EventMention.class));
                KnowtatorAnnotation severity = (KnowtatorAnnotation)annotationSlots.remove("severity");
                delayedFeatures.add(DelayedRelationFeature.forArg1((Annotation)mention, "severity", severity, DegreeOfTextRelation.class, SeverityModifier.class));
            } else if ("Lab".equals(annotation.type)) {
                mention = new LabMention(jCas, coveringSpan.begin, coveringSpan.end);
                SHARPKnowtatorXMLReader.addIdentifiedAnnotationFeatures(annotation, (IdentifiedAnnotation)mention, jCas, 9, stringSlots, booleanSlots, annotationSlots, idAnnotationMap, delayedFeatures);
                KnowtatorAnnotation ordinal = (KnowtatorAnnotation)annotationSlots.remove("ordinal_interpretation");
                delayedFeatures.add(DelayedRelationFeature.forArg1((Annotation)mention, "ordinalInterpretation", ordinal, DegreeOfTextRelation.class, LabInterpretationModifier.class));
                KnowtatorAnnotation referenceRange = (KnowtatorAnnotation)annotationSlots.remove("reference_range_narrative");
                delayedFeatures.add(new DelayedFeature((Annotation)mention, "referenceRangeNarrative", referenceRange));
                KnowtatorAnnotation labValue = (KnowtatorAnnotation)annotationSlots.remove("lab_value");
                delayedFeatures.add(DelayedRelationFeature.forArg1((Annotation)mention, "labValue", labValue, ResultOfTextRelation.class, LabValueModifier.class));
                KnowtatorAnnotation deltaFlag = (KnowtatorAnnotation)annotationSlots.remove("delta_flag");
                delayedFeatures.add(new DelayedFeature((Annotation)mention, "deltaFlag", deltaFlag));
            } else if ("Medications/Drugs".equals(annotation.type)) {
                mention = new MedicationMention(jCas, coveringSpan.begin, coveringSpan.end);
                SHARPKnowtatorXMLReader.addIdentifiedAnnotationFeatures(annotation, (IdentifiedAnnotation)mention, jCas, 1, stringSlots, booleanSlots, annotationSlots, idAnnotationMap, delayedFeatures);
                KnowtatorAnnotation allergy = (KnowtatorAnnotation)annotationSlots.remove("allergy_indicator");
                delayedFeatures.add(new DelayedFeature((Annotation)mention, "medicationAllergy", allergy));
                KnowtatorAnnotation changeStatus = (KnowtatorAnnotation)annotationSlots.remove("change_status_model");
                delayedFeatures.add(new DelayedFeature((Annotation)mention, "medicationStatusChange", changeStatus));
                KnowtatorAnnotation dosage = (KnowtatorAnnotation)annotationSlots.remove("dosage_model");
                delayedFeatures.add(new DelayedFeature((Annotation)mention, "medicationDosage", dosage));
                KnowtatorAnnotation duration = (KnowtatorAnnotation)annotationSlots.remove("duration_model");
                delayedFeatures.add(new DelayedFeature((Annotation)mention, "medicationDuration", duration));
                KnowtatorAnnotation form = (KnowtatorAnnotation)annotationSlots.remove("form_model");
                delayedFeatures.add(new DelayedFeature((Annotation)mention, "medicationForm", form));
                KnowtatorAnnotation frequency = (KnowtatorAnnotation)annotationSlots.remove("frequency_model");
                delayedFeatures.add(new DelayedFeature((Annotation)mention, "medicationFrequency", frequency));
                KnowtatorAnnotation route = (KnowtatorAnnotation)annotationSlots.remove("route_model");
                delayedFeatures.add(new DelayedFeature((Annotation)mention, "medicationRoute", route));
                KnowtatorAnnotation startDate = (KnowtatorAnnotation)annotationSlots.remove("start_date");
                delayedFeatures.add(new DelayedFeature((Annotation)mention, "startDate", startDate));
                KnowtatorAnnotation endDate = (KnowtatorAnnotation)annotationSlots.remove("end_date");
                delayedFeatures.add(new DelayedFeature((Annotation)mention, "endDate", endDate));
                KnowtatorAnnotation strength = (KnowtatorAnnotation)annotationSlots.remove("strength_model");
                delayedFeatures.add(new DelayedFeature((Annotation)mention, "medicationStrength", strength));
            } else if ("Phenomena".equals(annotation.type)) {
                mention = new EventMention(jCas, coveringSpan.begin, coveringSpan.end);
                SHARPKnowtatorXMLReader.addIdentifiedAnnotationFeatures(annotation, (IdentifiedAnnotation)mention, jCas, 10, stringSlots, booleanSlots, annotationSlots, idAnnotationMap, delayedFeatures);
            } else if ("Procedure".equals(annotation.type)) {
                mention = new ProcedureMention(jCas, coveringSpan.begin, coveringSpan.end);
                SHARPKnowtatorXMLReader.addIdentifiedAnnotationFeatures(annotation, (IdentifiedAnnotation)mention, jCas, 5, stringSlots, booleanSlots, annotationSlots, idAnnotationMap, delayedFeatures);
                bodyLaterality = (KnowtatorAnnotation)annotationSlots.remove("body_laterality");
                delayedFeatures.add(new DelayedFeature((Annotation)mention, "bodyLaterality", bodyLaterality));
                KnowtatorAnnotation bodyLocation = (KnowtatorAnnotation)annotationSlots.remove("body_location");
                delayedFeatures.add(DelayedRelationFeature.forArg1((Annotation)mention, "bodyLocation", bodyLocation, LocationOfTextRelation.class, AnatomicalSiteMention.class));
                KnowtatorAnnotation bodySide = (KnowtatorAnnotation)annotationSlots.remove("body_side");
                delayedFeatures.add(new DelayedFeature((Annotation)mention, "bodySide", bodySide));
                KnowtatorAnnotation device = (KnowtatorAnnotation)annotationSlots.remove("device");
                delayedFeatures.add(new DelayedFeature((Annotation)mention, "procedureDevice", device));
                KnowtatorAnnotation method = (KnowtatorAnnotation)annotationSlots.remove("method");
                delayedFeatures.add(new DelayedFeature((Annotation)mention, "method", method));
            } else if ("Sign_symptom".equals(annotation.type)) {
                mention = new SignSymptomMention(jCas, coveringSpan.begin, coveringSpan.end);
                SHARPKnowtatorXMLReader.addIdentifiedAnnotationFeatures(annotation, (IdentifiedAnnotation)mention, jCas, 3, stringSlots, booleanSlots, annotationSlots, idAnnotationMap, delayedFeatures);
                alleviatingFactor = (KnowtatorAnnotation)annotationSlots.remove("alleviating_factor");
                delayedFeatures.add(DelayedRelationFeature.forArg2((Annotation)mention, "alleviatingFactor", alleviatingFactor, ManagesTreatsTextRelation.class, ProcedureMention.class));
                KnowtatorAnnotation bodyLaterality3 = (KnowtatorAnnotation)annotationSlots.remove("body_laterality");
                delayedFeatures.add(new DelayedFeature((Annotation)mention, "bodyLaterality", bodyLaterality3));
                KnowtatorAnnotation bodyLocation = (KnowtatorAnnotation)annotationSlots.remove("body_location");
                delayedFeatures.add(DelayedRelationFeature.forArg1((Annotation)mention, "bodyLocation", bodyLocation, LocationOfTextRelation.class, AnatomicalSiteMention.class));
                KnowtatorAnnotation bodySide = (KnowtatorAnnotation)annotationSlots.remove("body_side");
                delayedFeatures.add(new DelayedFeature((Annotation)mention, "bodySide", bodySide));
                KnowtatorAnnotation course = (KnowtatorAnnotation)annotationSlots.remove("course");
                delayedFeatures.add(DelayedRelationFeature.forArg1((Annotation)mention, "course", course, DegreeOfTextRelation.class, CourseModifier.class));
                KnowtatorAnnotation exacerbatingFactor = (KnowtatorAnnotation)annotationSlots.remove("exacerbating_factor");
                delayedFeatures.add(DelayedRelationFeature.forArg2((Annotation)mention, "exacerbatingFactor", exacerbatingFactor, ComplicatesDisruptsTextRelation.class, EventMention.class));
                KnowtatorAnnotation severity = (KnowtatorAnnotation)annotationSlots.remove("severity");
                delayedFeatures.add(DelayedRelationFeature.forArg1((Annotation)mention, "severity", severity, DegreeOfTextRelation.class, SeverityModifier.class));
            } else if ("EVENT".equals(annotation.type)) {
                int polarity;
                String polarityStr;
                EventProperties eventProperties = new EventProperties(jCas);
                eventProperties.setCategory((String)stringSlots.remove("type"));
                if (eventProperties.getCategory() == null) {
                    eventProperties.setCategory("N/A");
                }
                eventProperties.setContextualModality((String)stringSlots.remove("contextualmoduality"));
                if (eventProperties.getContextualModality() == null) {
                    eventProperties.setContextualModality("ACTUAL");
                }
                eventProperties.setContextualAspect((String)stringSlots.remove("contextualaspect"));
                if (eventProperties.getContextualAspect() == null) {
                    eventProperties.setContextualAspect("N/A");
                }
                eventProperties.setDegree((String)stringSlots.remove("degree"));
                if (eventProperties.getDegree() == null) {
                    eventProperties.setDegree("N/A");
                }
                eventProperties.setDocTimeRel((String)stringSlots.remove("DocTimeRel"));
                if (eventProperties.getDocTimeRel() == null) {
                    LOGGER.warn((Object)String.format("assuming docTimeRel=OVERLAP for annotation with id \"%s\"", annotation.id));
                    eventProperties.setDocTimeRel("OVERLAP");
                }
                eventProperties.setPermanence((String)stringSlots.remove("permanence"));
                if (eventProperties.getPermanence() == null) {
                    eventProperties.setPermanence("UNDETERMINED");
                }
                if ((polarityStr = (String)stringSlots.remove("polarity")) == null || polarityStr.equals("POS")) {
                    polarity = 1;
                } else if (polarityStr.equals("NEG")) {
                    polarity = -1;
                } else {
                    throw new IllegalArgumentException("Invalid polarity: " + polarityStr);
                }
                eventProperties.setPolarity(polarity);
                Event event = new Event(jCas);
                event.setConfidence(1.0);
                event.setDiscoveryTechnique(2);
                EventMention eventMention = new EventMention(jCas, coveringSpan.begin, coveringSpan.end);
                eventMention.setConfidence(1.0f);
                eventMention.setDiscoveryTechnique(2);
                event.setProperties(eventProperties);
                event.setMentions(new FSArray(jCas, 1));
                event.setMentions(0, (IdentifiedAnnotation)eventMention);
                eventMention.setEvent(event);
                eventProperties.addToIndexes();
                event.addToIndexes();
                eventMention.addToIndexes();
                idAnnotationMap.put(annotation.id, (TOP)eventMention);
            } else if ("DOCTIME".equals(annotation.type)) {
                timeMention = new TimeMention(jCas, coveringSpan.begin, coveringSpan.end);
                timeMention.setTimeClass(annotation.type);
                timeMention.addToIndexes();
                idAnnotationMap.put(annotation.id, (TOP)timeMention);
            } else if ("SECTIONTIME".equals(annotation.type)) {
                timeMention = new TimeMention(jCas, coveringSpan.begin, coveringSpan.end);
                timeMention.setTimeClass(annotation.type);
                timeMention.addToIndexes();
                idAnnotationMap.put(annotation.id, (TOP)timeMention);
            } else if ("TIMEX3".equals(annotation.type)) {
                String timexClass = (String)stringSlots.remove("class");
                TimeMention timeMention2 = new TimeMention(jCas, coveringSpan.begin, coveringSpan.end);
                timeMention2.setTimeClass(timexClass);
                timeMention2.addToIndexes();
                idAnnotationMap.put(annotation.id, (TOP)timeMention2);
            } else if ("conditional_class".equals(annotation.type)) {
                value = (Boolean)booleanSlots.remove("conditional_normalization");
                modifier2 = new ConditionalModifier(jCas, coveringSpan.begin, coveringSpan.end);
                modifier2.setConditional(value == null ? false : (Boolean)value);
                modifier2.addToIndexes();
                idAnnotationMap.put(annotation.id, (TOP)modifier2);
            } else if ("generic_class".equals(annotation.type)) {
                value = (Boolean)booleanSlots.remove("generic_normalization");
                modifier2 = new GenericModifier(jCas, coveringSpan.begin, coveringSpan.end);
                modifier2.setGeneric(value == null ? false : (Boolean)value);
                modifier2.addToIndexes();
                idAnnotationMap.put(annotation.id, (TOP)modifier2);
            } else if ("negation_indicator_class".equals(annotation.type)) {
                value = (String)stringSlots.remove("negation_indicator_normalization");
                modifier2 = new PolarityModifier(jCas, coveringSpan.begin, coveringSpan.end);
                if (value == null) {
                    LOGGER.warn((Object)String.format("assuming NE_POLARITY_NEGATION_PRESENT for %s with id \"%s\"", SHARPKnowtatorXMLReader.format((Annotation)modifier2), annotation.id));
                    modifier2.setPolarity(-1);
                } else if (((String)value).equals("negation_absent")) {
                    modifier2.setPolarity(1);
                } else if (((String)value).equals("negation_present")) {
                    modifier2.setPolarity(-1);
                } else {
                    throw new UnsupportedOperationException("Invalid negation: " + (String)value);
                }
                modifier2.addToIndexes();
                idAnnotationMap.put(annotation.id, (TOP)modifier2);
            } else if ("uncertainty_indicator_class".equals(annotation.type)) {
                value = (String)stringSlots.remove("uncertainty_indicator_normalization");
                modifier2 = new UncertaintyModifier(jCas, coveringSpan.begin, coveringSpan.end);
                if (value == null) {
                    LOGGER.warn((Object)String.format("assuming NE_UNCERTAINTY_PRESENT for %s with id \"%s\"", SHARPKnowtatorXMLReader.format((Annotation)modifier2), annotation.id));
                    modifier2.setUncertainty(1);
                } else if (((String)value).equals("indicator_absent")) {
                    modifier2.setUncertainty(0);
                } else if (((String)value).equals("indicator_present")) {
                    modifier2.setUncertainty(1);
                } else {
                    throw new UnsupportedOperationException("Invalid uncertainty: " + (String)value);
                }
                modifier2.addToIndexes();
                idAnnotationMap.put(annotation.id, (TOP)modifier2);
            } else if ("Person".equals(annotation.type)) {
                String subject;
                value = (String)stringSlots.remove("subject_normalization_CU");
                String uimaValue = SUBJECT_KNOWTATOR_TO_UIMA_MAP.get(value);
                String code = (String)stringSlots.remove("associatedCode");
                String uimaCode = SUBJECT_KNOWTATOR_TO_UIMA_MAP.get(code);
                if (value != null && uimaValue == null) {
                    LOGGER.error((Object)String.format("unrecognized subject value \"%s\" for annotation with id \"%s\"", value, annotation.id));
                }
                if (code != null && uimaCode == null) {
                    LOGGER.error((Object)String.format("unrecognized subject code \"%s\" for annotation with id \"%s\"", code, annotation.id));
                }
                if (uimaValue != null && uimaCode != null && !uimaValue.equals(uimaCode)) {
                    LOGGER.error((Object)String.format("subject value \"%s\" and code \"%s\" are inconsistent for annotation with id \"%s\"", value, code, annotation.id));
                }
                String string = subject = uimaValue != null ? uimaValue : uimaCode;
                if (subject == null && this.setDefaults) {
                    subject = SHARPKnowtatorXMLDefaults.getSubject();
                }
                modifier = new SubjectModifier(jCas, coveringSpan.begin, coveringSpan.end);
                modifier.setSubject(subject);
                modifier.addToIndexes();
                idAnnotationMap.put(annotation.id, (TOP)modifier);
            } else if ("historyOf_indicator_class".equals(annotation.type)) {
                value = (String)stringSlots.remove("historyOf_normalization");
                modifier2 = new HistoryOfModifier(jCas, coveringSpan.begin, coveringSpan.end);
                if (null == value) {
                    if (this.setDefaults) {
                        modifier2.setHistoryOf(SHARPKnowtatorXMLDefaults.getHistoryOf());
                    }
                } else if ("historyOf_present".equals(value)) {
                    modifier2.setHistoryOf(1);
                } else if ("historyOf_absent".equals(value)) {
                    modifier2.setHistoryOf(0);
                } else {
                    LOGGER.error((Object)String.format("unrecognized history-of value \"%s\" on annotation with id \"%s\"", value, annotation.id));
                }
                modifier2.addToIndexes();
                idAnnotationMap.put(annotation.id, (TOP)modifier2);
            } else if ("distal_or_proximal".equals(annotation.type)) {
                value = (String)stringSlots.remove("distal_or_proximal_normalization");
                modifier2 = new BodyLateralityModifier(jCas, coveringSpan.begin, coveringSpan.end);
                BodyLaterality attribute3 = new BodyLaterality(jCas);
                if (value == null) {
                    LOGGER.warn((Object)String.format("assuming \"%s\" for %s with id \"%s\"", "unmarked", SHARPKnowtatorXMLReader.format((Annotation)modifier2), annotation.id));
                    value = "unmarked";
                } else if (!(((String)value).equals("distal") || ((String)value).equals("proximal") || ((String)value).equals("unmarked"))) {
                    throw new UnsupportedOperationException("Invalid BodyLaterality: " + (String)value);
                }
                attribute3.setValue((String)value);
                attribute3.addToIndexes();
                modifier2.setNormalizedForm((Attribute)attribute3);
                modifier2.addToIndexes();
                idAnnotationMap.put(annotation.id, (TOP)modifier2);
            } else if ("superior_or_inferior".equals(annotation.type)) {
                value = (String)stringSlots.remove("superior_or_inferior_normalization");
                modifier2 = new BodyLateralityModifier(jCas, coveringSpan.begin, coveringSpan.end);
                BodyLaterality attribute4 = new BodyLaterality(jCas);
                if (value == null) {
                    LOGGER.warn((Object)String.format("assuming \"%s\" for %s with id \"%s\"", "unmarked", SHARPKnowtatorXMLReader.format((Annotation)modifier2), annotation.id));
                    value = "unmarked";
                } else if (!(((String)value).equals("distal") || ((String)value).equals("superior") || ((String)value).equals("inferior"))) {
                    throw new UnsupportedOperationException("Invalid BodyLaterality: " + (String)value);
                }
                attribute4.setValue((String)value);
                attribute4.addToIndexes();
                modifier2.setNormalizedForm((Attribute)attribute4);
                modifier2.addToIndexes();
                idAnnotationMap.put(annotation.id, (TOP)modifier2);
            } else if ("medial_or_lateral".equals(annotation.type)) {
                value = (String)stringSlots.remove("medial_or_lateral_normalization");
                modifier2 = new BodyLateralityModifier(jCas, coveringSpan.begin, coveringSpan.end);
                BodyLaterality attribute5 = new BodyLaterality(jCas);
                if (value == null) {
                    LOGGER.warn((Object)String.format("assuming \"%s\" for %s with id \"%s\"", "unmarked", SHARPKnowtatorXMLReader.format((Annotation)modifier2), annotation.id));
                    value = "unmarked";
                } else if (!(((String)value).equals("distal") || ((String)value).equals("medial") || ((String)value).equals("lateral"))) {
                    throw new UnsupportedOperationException("Invalid BodyLaterality: " + (String)value);
                }
                attribute5.setValue((String)value);
                attribute5.addToIndexes();
                modifier2.setNormalizedForm((Attribute)attribute5);
                modifier2.addToIndexes();
                idAnnotationMap.put(annotation.id, (TOP)modifier2);
            } else if ("dorsal_or_ventral".equals(annotation.type)) {
                value = (String)stringSlots.remove("dorsal_or_ventral_normalization");
                modifier2 = new BodyLateralityModifier(jCas, coveringSpan.begin, coveringSpan.end);
                BodyLaterality attribute6 = new BodyLaterality(jCas);
                if (value == null) {
                    LOGGER.warn((Object)String.format("assuming \"%s\" for %s with id \"%s\"", "unmarked", SHARPKnowtatorXMLReader.format((Annotation)modifier2), annotation.id));
                    value = "unmarked";
                } else if (!(((String)value).equals("distal") || ((String)value).equals("dorsal") || ((String)value).equals("ventral"))) {
                    throw new UnsupportedOperationException("Invalid BodyLaterality: " + (String)value);
                }
                attribute6.setValue((String)value);
                attribute6.addToIndexes();
                modifier2.setNormalizedForm((Attribute)attribute6);
                modifier2.addToIndexes();
                idAnnotationMap.put(annotation.id, (TOP)modifier2);
            } else if ("body_side_class".equals(annotation.type)) {
                attribute2 = new BodySide(jCas);
                attribute2.setValue((String)stringSlots.remove("body_side_normalization"));
                attribute2.addToIndexes();
                modifier2 = new BodySideModifier(jCas, coveringSpan.begin, coveringSpan.end);
                modifier2.setNormalizedForm((Attribute)attribute2);
                modifier2.addToIndexes();
                idAnnotationMap.put(annotation.id, (TOP)modifier2);
            } else if ("course_class".equals(annotation.type)) {
                attribute2 = new Course(jCas);
                attribute2.setValue((String)stringSlots.remove("course_normalization"));
                attribute2.addToIndexes();
                modifier2 = new CourseModifier(jCas, coveringSpan.begin, coveringSpan.end);
                modifier2.setTypeID(1);
                modifier2.setNormalizedForm((Attribute)attribute2);
                modifier2.addToIndexes();
                idAnnotationMap.put(annotation.id, (TOP)modifier2);
            } else if ("estimated_flag_indicator".equals(annotation.type)) {
                boolean value2 = (Boolean)booleanSlots.remove("estimated_normalization");
                modifier2 = new LabEstimatedModifier(jCas, coveringSpan.begin, coveringSpan.end);
                modifier2.setIndicated(value2);
                modifier2.addToIndexes();
                idAnnotationMap.put(annotation.id, (TOP)modifier2);
            } else if ("lab_interpretation_indicator".equals(annotation.type)) {
                value = (String)stringSlots.remove("lab_interpretation_normalization");
                modifier2 = new LabInterpretationModifier(jCas, coveringSpan.begin, coveringSpan.end);
                modifier2.setTypeID(3);
                modifier2.setValue((String)value);
                modifier2.addToIndexes();
                idAnnotationMap.put(annotation.id, (TOP)modifier2);
            } else if ("reference_range".equals(annotation.type)) {
                LabReferenceRangeModifier modifier3 = new LabReferenceRangeModifier(jCas, coveringSpan.begin, coveringSpan.end);
                attribute = new LabReferenceRange(jCas);
                attribute.setValue(modifier3.getCoveredText());
                attribute.addToIndexes();
                modifier3.setNormalizedForm((Attribute)attribute);
                modifier3.addToIndexes();
                idAnnotationMap.put(annotation.id, (TOP)modifier3);
            } else if ("delta_flag_indicator".equals(annotation.type)) {
                value = (String)stringSlots.remove("delta_flag_normalization");
                modifier2 = new LabDeltaFlagModifier(jCas, coveringSpan.begin, coveringSpan.end);
                LabDeltaFlag attribute7 = new LabDeltaFlag(jCas);
                attribute7.setValue((String)value);
                attribute7.addToIndexes();
                modifier2.setNormalizedForm((Attribute)attribute7);
                modifier2.addToIndexes();
                idAnnotationMap.put(annotation.id, (TOP)modifier2);
            } else if ("Value".equals(annotation.type)) {
                unit = (KnowtatorAnnotation)annotationSlots.remove("value_unit");
                number = (KnowtatorAnnotation)annotationSlots.remove("value_number");
                LabValue attribute8 = new LabValue(jCas);
                if (unit != null) {
                    KnowtatorAnnotation.Span unitSpan = unit.getCoveringSpan();
                    String unitString = text.substring(unitSpan.begin, unitSpan.end);
                    attribute8.setUnit(unitString);
                }
                if (number != null) {
                    KnowtatorAnnotation.Span numberSpan = number.getCoveringSpan();
                    String numberString = text.substring(numberSpan.begin, numberSpan.end);
                    attribute8.setNumber(numberString);
                }
                attribute8.addToIndexes();
                LabValueModifier modifier4 = new LabValueModifier(jCas, coveringSpan.begin, coveringSpan.end);
                modifier4.setNormalizedForm((Attribute)attribute8);
                modifier4.addToIndexes();
                idAnnotationMap.put(annotation.id, (TOP)modifier4);
            } else if (!"Value number".equals(annotation.type) && !"Value unit".equals(annotation.type)) {
                if ("allergy_indicator_class".equals(annotation.type)) {
                    value = (String)stringSlots.remove("allergy_indicator_normalization");
                    modifier2 = new MedicationAllergyModifier(jCas, coveringSpan.begin, coveringSpan.end);
                    if (null == value) {
                        modifier2.setIndicated(false);
                    } else if ("indicator_present".equals(value)) {
                        modifier2.setIndicated(true);
                    } else if ("indicator_absent".equals(value)) {
                        modifier2.setIndicated(false);
                    } else {
                        LOGGER.error((Object)String.format("unrecognized allergy-indicator value \"%s\" on annotation with id \"%s\"", value, annotation.id));
                    }
                    modifier2.addToIndexes();
                    idAnnotationMap.put(annotation.id, (TOP)modifier2);
                } else if ("Dosage".equals(annotation.type)) {
                    value = (String)stringSlots.remove("dosage_values");
                    attribute = new MedicationDosage(jCas);
                    attribute.setValue((String)value);
                    attribute.addToIndexes();
                    MedicationDosageModifier modifier5 = new MedicationDosageModifier(jCas, coveringSpan.begin, coveringSpan.end);
                    modifier5.setNormalizedForm((Attribute)attribute);
                    modifier5.addToIndexes();
                    idAnnotationMap.put(annotation.id, (TOP)modifier5);
                } else if ("Duration".equals(annotation.type)) {
                    value = (String)stringSlots.remove("duration_values");
                    attribute = new MedicationDuration(jCas);
                    attribute.setValue((String)value);
                    attribute.addToIndexes();
                    MedicationDurationModifier modifier6 = new MedicationDurationModifier(jCas, coveringSpan.begin, coveringSpan.end);
                    modifier6.setNormalizedForm((Attribute)attribute);
                    modifier6.addToIndexes();
                    idAnnotationMap.put(annotation.id, (TOP)modifier6);
                } else if ("Form".equals(annotation.type)) {
                    value = (String)stringSlots.remove("form_values");
                    attribute = new MedicationForm(jCas);
                    attribute.setValue((String)value);
                    attribute.addToIndexes();
                    MedicationFormModifier modifier7 = new MedicationFormModifier(jCas, coveringSpan.begin, coveringSpan.end);
                    modifier7.setNormalizedForm((Attribute)attribute);
                    modifier7.addToIndexes();
                    idAnnotationMap.put(annotation.id, (TOP)modifier7);
                } else if ("Frequency".equals(annotation.type)) {
                    unit = (KnowtatorAnnotation)annotationSlots.remove("frequency_unit");
                    number = (KnowtatorAnnotation)annotationSlots.remove("frequency_number");
                    MedicationFrequency attribute9 = new MedicationFrequency(jCas);
                    if (unit != null) {
                        String unitString = unit.stringSlots.get("frequency_unit_values");
                        attribute9.setUnit(unitString);
                    }
                    if (number != null) {
                        String numberString = number.stringSlots.get("frequency_number_normalization");
                        attribute9.setNumber(numberString);
                    }
                    attribute9.addToIndexes();
                    MedicationFrequencyModifier modifier8 = new MedicationFrequencyModifier(jCas, coveringSpan.begin, coveringSpan.end);
                    modifier8.setNormalizedForm((Attribute)attribute9);
                    modifier8.addToIndexes();
                    idAnnotationMap.put(annotation.id, (TOP)modifier8);
                } else if ("Frequency number".equals(annotation.type)) {
                    stringSlots.remove("frequency_number_normalization");
                } else if ("Frequency unit".equals(annotation.type)) {
                    stringSlots.remove("frequency_unit_values");
                } else if ("Route".equals(annotation.type)) {
                    value = (String)stringSlots.remove("route_values");
                    attribute = new MedicationRoute(jCas);
                    attribute.setValue((String)value);
                    attribute.addToIndexes();
                    MedicationRouteModifier modifier9 = new MedicationRouteModifier(jCas, coveringSpan.begin, coveringSpan.end);
                    modifier9.setNormalizedForm((Attribute)attribute);
                    modifier9.addToIndexes();
                    idAnnotationMap.put(annotation.id, (TOP)modifier9);
                } else if ("Status change".equals(annotation.type)) {
                    value = (String)stringSlots.remove("change_status_value");
                    attribute = new MedicationStatusChange(jCas);
                    attribute.setValue((String)value);
                    attribute.addToIndexes();
                    MedicationStatusChangeModifier modifier10 = new MedicationStatusChangeModifier(jCas, coveringSpan.begin, coveringSpan.end);
                    modifier10.setNormalizedForm((Attribute)attribute);
                    modifier10.addToIndexes();
                    idAnnotationMap.put(annotation.id, (TOP)modifier10);
                } else if ("Strength".equals(annotation.type)) {
                    unit = (KnowtatorAnnotation)annotationSlots.remove("strength_unit");
                    number = (KnowtatorAnnotation)annotationSlots.remove("strength_number");
                    MedicationStrength attribute10 = new MedicationStrength(jCas);
                    int spanStart = text.length() - 1;
                    int spanEnd = 0;
                    if (unit != null) {
                        KnowtatorAnnotation.Span unitSpan = unit.getCoveringSpan();
                        String unitString = text.substring(unitSpan.begin, unitSpan.end);
                        attribute10.setUnit(unitString);
                        if (unitSpan.begin < spanStart) {
                            spanStart = unitSpan.begin;
                        }
                        if (unitSpan.end > spanEnd) {
                            spanEnd = unitSpan.end;
                        }
                    }
                    if (number != null) {
                        KnowtatorAnnotation.Span numberSpan = number.getCoveringSpan();
                        String numberString = text.substring(numberSpan.begin, numberSpan.end);
                        attribute10.setNumber(numberString);
                        if (numberSpan.begin < spanStart) {
                            spanStart = numberSpan.begin;
                        }
                        if (numberSpan.end > spanEnd) {
                            spanEnd = numberSpan.end;
                        }
                    }
                    attribute10.addToIndexes();
                    modifier = new MedicationStrengthModifier(jCas, spanStart, spanEnd);
                    modifier.setNormalizedForm((Attribute)attribute10);
                    modifier.addToIndexes();
                    idAnnotationMap.put(annotation.id, (TOP)modifier);
                } else if (!"Strength number".equals(annotation.type) && !"Strength unit".equals(annotation.type)) {
                    DelayedRelation relation;
                    String code;
                    if ("device_class".equals(annotation.type)) {
                        code = (String)stringSlots.remove("associatedCode");
                        attribute = new ProcedureDevice(jCas);
                        attribute.setValue(code);
                        ProcedureDeviceModifier modifier11 = new ProcedureDeviceModifier(jCas, coveringSpan.begin, coveringSpan.end);
                        modifier11.setNormalizedForm((Attribute)attribute);
                        modifier11.addToIndexes();
                        idAnnotationMap.put(annotation.id, (TOP)modifier11);
                    } else if ("method_class".equals(annotation.type)) {
                        code = (String)stringSlots.remove("associatedCode");
                        attribute = new ProcedureMethod(jCas);
                        attribute.setValue(code);
                        ProcedureMethodModifier modifier12 = new ProcedureMethodModifier(jCas, coveringSpan.begin, coveringSpan.end);
                        modifier12.setNormalizedForm((Attribute)attribute);
                        modifier12.addToIndexes();
                        idAnnotationMap.put(annotation.id, (TOP)modifier12);
                    } else if ("severity_class".equals(annotation.type)) {
                        attribute2 = new Severity(jCas);
                        attribute2.setValue((String)stringSlots.remove("severity_normalization"));
                        attribute2.addToIndexes();
                        modifier2 = new SeverityModifier(jCas, coveringSpan.begin, coveringSpan.end);
                        modifier2.setTypeID(2);
                        modifier2.setNormalizedForm((Attribute)attribute2);
                        modifier2.addToIndexes();
                        idAnnotationMap.put(annotation.id, (TOP)modifier2);
                    } else if ("Date".equals(annotation.type)) {
                        String month = (String)stringSlots.remove("month");
                        String day = (String)stringSlots.remove("day");
                        String year = (String)stringSlots.remove("year");
                        Date date = new Date(jCas);
                        date.setMonth(month);
                        date.setDay(day);
                        date.setYear(year);
                        date.addToIndexes();
                        TimeMention mention2 = new TimeMention(jCas, coveringSpan.begin, coveringSpan.end);
                        mention2.setDate(date);
                        mention2.addToIndexes();
                        idAnnotationMap.put(annotation.id, (TOP)mention2);
                    } else if (eventRelationTypes.contains(annotation.type)) {
                        relation = new DelayedRelation();
                        relation.sourceFile = knowtatorURI;
                        relation.annotation = annotation;
                        relation.source = (KnowtatorAnnotation)annotationSlots.remove("Event");
                        relation.target = (KnowtatorAnnotation)annotationSlots.remove("related_to");
                        relation.type = (String)stringSlots.remove("Relationtype");
                        delayedRelations.add(relation);
                    } else if (entityRelationTypes.contains(annotation.type)) {
                        relation = new DelayedRelation();
                        relation.sourceFile = knowtatorURI;
                        relation.annotation = annotation;
                        relation.source = (KnowtatorAnnotation)annotationSlots.remove("Argument_CU");
                        relation.target = (KnowtatorAnnotation)annotationSlots.remove("Related_to_CU");
                        relation.conditional = (KnowtatorAnnotation)annotationSlots.remove("conditional_CU");
                        relation.negation = (KnowtatorAnnotation)annotationSlots.remove("negation_indicator_CU");
                        relation.uncertainty = (KnowtatorAnnotation)annotationSlots.remove("uncertainty_indicator_CU");
                        delayedRelations.add(relation);
                    } else {
                        LOGGER.error((Object)String.format("unrecognized type '%s' for annotation with id \"%s\"", annotation.type, annotation.id));
                    }
                }
            }
            HashMap slotGroups = new HashMap();
            slotGroups.put("stringSlots", stringSlots.keySet());
            slotGroups.put("booleanSlots", booleanSlots.keySet());
            slotGroups.put("annotationSlots", annotationSlots.keySet());
            for (Map.Entry entry : slotGroups.entrySet()) {
                Set remainingSlots = (Set)entry.getValue();
                if (remainingSlots.isEmpty()) continue;
                throw new UnsupportedOperationException(String.format("%s has unprocessed %s %s in %s", annotation.type, entry.getKey(), remainingSlots, knowtatorURI));
            }
        }
        for (DelayedRelation delayedRelation : delayedRelations) {
            delayedRelation.addToIndexes(jCas, idAnnotationMap);
        }
        for (DelayedFeature delayedFeature : delayedFeatures) {
            try {
                delayedFeature.setValueFrom(idAnnotationMap);
            }
            catch (CASRuntimeException e) {
                LOGGER.error((Object)String.format("Unable to set delayed feature value with message %s", e.getMessage()));
            }
        }
    }

    static String format(Annotation ann) {
        String result = ann.getEnd() == Integer.MIN_VALUE || ann.getBegin() == Integer.MAX_VALUE ? "<no-spanned-text>" : String.format("\"%s\"[%d,%d]", ann.getCoveredText(), ann.getBegin(), ann.getEnd());
        return String.format("%s(%s)", ann.getClass().getSimpleName(), result);
    }

    private static void addIdentifiedAnnotationFeatures(KnowtatorAnnotation annotation, final IdentifiedAnnotation mention, JCas jCas, int typeID, Map<String, String> stringSlots, Map<String, Boolean> booleanSlots, Map<String, KnowtatorAnnotation> annotationSlots, Map<String, TOP> idAnnotationMap, List<DelayedFeature> delayedFeatures) {
        OntologyConcept ontologyConcept;
        String code;
        mention.setTypeID(typeID);
        mention.setConfidence(1.0f);
        mention.setDiscoveryTechnique(2);
        Boolean negation = booleanSlots.remove("Negation");
        mention.setPolarity(negation == null ? 1 : (negation == true ? -1 : 1));
        KnowtatorAnnotation conditional = annotationSlots.remove("conditional_CU");
        delayedFeatures.add(new DelayedFeatureFromFeature((Annotation)mention, "conditional", conditional));
        KnowtatorAnnotation generic = annotationSlots.remove("generic_CU");
        delayedFeatures.add(new DelayedFeatureFromFeature((Annotation)mention, "generic", generic));
        KnowtatorAnnotation historyOf = annotationSlots.remove("historyOf_CU");
        delayedFeatures.add(new DelayedFeatureFromFeature((Annotation)mention, "historyOf", historyOf));
        KnowtatorAnnotation negationIndicator = annotationSlots.remove("negation_indicator_CU");
        delayedFeatures.add(new DelayedFeatureFromFeature((Annotation)mention, "polarity", negationIndicator));
        KnowtatorAnnotation subject = annotationSlots.remove("subject_CU");
        delayedFeatures.add(new DelayedFeatureFromFeature((Annotation)mention, "subject", subject){

            @Override
            public void setValueFrom(Map<String, ? extends TOP> annotationMap) {
                super.setValueFrom(annotationMap);
                if (mention.getSubject() == null) {
                    mention.setSubject("patient");
                }
            }
        });
        KnowtatorAnnotation uncertainty = annotationSlots.remove("uncertainty_indicator_CU");
        delayedFeatures.add(new DelayedFeatureFromFeature((Annotation)mention, "uncertainty", uncertainty));
        String status = stringSlots.remove("Status");
        if (status != null) {
            if ("HistoryOf".equals(status)) {
                mention.setHistoryOf(1);
            } else if ("FamilyHistoryOf".equals(status)) {
                mention.setHistoryOf(1);
                mention.setSubject("family_member");
            } else if ("Possible".equals(status)) {
                mention.setUncertainty(-1);
            } else {
                throw new UnsupportedOperationException("Unknown status: " + status);
            }
        }
        if ((code = stringSlots.remove("AssociateCode")) == null) {
            code = stringSlots.remove("associatedCode");
        }
        if (mention.getTypeID() == 1) {
            ontologyConcept = new OntologyConcept(jCas);
            ontologyConcept.setCode(code);
        } else {
            UmlsConcept umlsConcept = new UmlsConcept(jCas);
            umlsConcept.setCui(code);
            ontologyConcept = umlsConcept;
        }
        ontologyConcept.addToIndexes();
        mention.setOntologyConceptArr(new FSArray(jCas, 1));
        mention.setOntologyConceptArr(0, ontologyConcept);
        mention.addToIndexes();
        idAnnotationMap.put(annotation.id, (TOP)mention);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            throw new IllegalArgumentException(String.format("usage: java %s path/to/Knowtator/text [path/to/Knowtator/text ...]", SHARPKnowtatorXMLReader.class.getName()));
        }
        AnalysisEngine engine = AnalysisEngineFactory.createEngine(SHARPKnowtatorXMLReader.class, (Object[])new Object[0]);
        for (String knowtatorTextDirectoryPath : args) {
            File knowtatorTextDirectory = new File(knowtatorTextDirectoryPath);
            for (File textFile : knowtatorTextDirectory.listFiles()) {
                JCas jCas = engine.newJCas();
                jCas.setDocumentText(Files.toString((File)textFile, (Charset)Charsets.US_ASCII));
                DocumentID documentID = new DocumentID(jCas);
                documentID.setDocumentID(textFile.toURI().toString());
                documentID.addToIndexes();
                engine.process(jCas);
                documentID.setDocumentID(textFile.getName());
                CasIOUtil.writeXmi((JCas)jCas, (File)new File("/tmp", textFile.toURI().toString()));
            }
        }
    }

    static {
        SUBJECT_KNOWTATOR_TO_UIMA_MAP.put("C0030705", "patient");
        SUBJECT_KNOWTATOR_TO_UIMA_MAP.put("patient", "patient");
        SUBJECT_KNOWTATOR_TO_UIMA_MAP.put("family_member", "family_member");
        SUBJECT_KNOWTATOR_TO_UIMA_MAP.put("donor_family_member", "donor_family_member");
        SUBJECT_KNOWTATOR_TO_UIMA_MAP.put("donor_other", "donor_other");
        SUBJECT_KNOWTATOR_TO_UIMA_MAP.put("other", "other");
    }

    private static class DelayedRelationFeature
    extends DelayedFeature {
        private Class<? extends BinaryTextRelation> relationClass;
        private Annotation arg1;
        private Annotation arg2;
        private Class<? extends Annotation> arg1Class;
        private Class<? extends Annotation> arg2Class;

        public DelayedRelationFeature(Annotation annotation, String featureName, KnowtatorAnnotation featureValue, Class<? extends BinaryTextRelation> relationClass, Annotation arg1, Class<? extends Annotation> arg1Class, Annotation arg2, Class<? extends Annotation> arg2Class) {
            super(annotation, featureName, featureValue);
            this.relationClass = relationClass;
            this.arg1 = arg1;
            this.arg1Class = arg1Class;
            this.arg2 = arg2;
            this.arg2Class = arg2Class;
        }

        public static DelayedRelationFeature forArg1(Annotation arg1, String featureName, KnowtatorAnnotation featureValue, Class<? extends BinaryTextRelation> relationClass, Class<? extends Annotation> arg2Class) {
            return new DelayedRelationFeature(arg1, featureName, featureValue, relationClass, arg1, arg1.getClass(), null, arg2Class);
        }

        public static DelayedRelationFeature forArg2(Annotation arg2, String featureName, KnowtatorAnnotation featureValue, Class<? extends BinaryTextRelation> relationClass, Class<? extends Annotation> arg1Class) {
            return new DelayedRelationFeature(arg2, featureName, featureValue, relationClass, null, arg1Class, arg2, arg2.getClass());
        }

        @Override
        protected void setValue(TOP value) {
            BinaryTextRelation relation = (BinaryTextRelation)value;
            String message = null;
            if (!this.relationClass.isInstance(relation)) {
                message = "wrong relation type";
            } else if (this.arg1 != null && relation.getArg1().getArgument() != this.arg1) {
                message = "wrong relation arg1";
            } else if (this.arg2 != null && relation.getArg2().getArgument() != this.arg2) {
                message = "wrong relation arg2";
            } else if (!this.arg1Class.isInstance(relation.getArg1().getArgument())) {
                message = "wrong relation arg1 type";
            } else if (!this.arg2Class.isInstance(relation.getArg2().getArgument())) {
                message = "wrong relation arg2 type";
            }
            if (message != null) {
                LOGGER.warn((Object)String.format("%s: expected %s feature of %s to be %s(%s, %s) but found %s[%s](%s, %s) with id \"%s\"", message, this.featureName, SHARPKnowtatorXMLReader.format(this.annotation), this.relationClass.getSimpleName(), this.arg1 == null ? String.format("%s(...)", this.arg1Class.getSimpleName()) : SHARPKnowtatorXMLReader.format(this.arg1), this.arg2 == null ? String.format("%s(...)", this.arg2Class.getSimpleName()) : SHARPKnowtatorXMLReader.format(this.arg2), relation.getClass().getSimpleName(), relation.getCategory(), SHARPKnowtatorXMLReader.format(relation.getArg1().getArgument()), SHARPKnowtatorXMLReader.format(relation.getArg2().getArgument()), this.featureValue.id));
            } else {
                super.setValue(value);
            }
        }
    }

    private static class DelayedFeatureFromFeature
    extends DelayedFeature {
        public DelayedFeatureFromFeature(Annotation annotation, String featureName, KnowtatorAnnotation featureValue) {
            super(annotation, featureName, featureValue);
        }

        @Override
        protected void setValue(TOP value) {
            String featureValueToCopy = value.getFeatureValueAsString(this.getFeature(value));
            this.annotation.setFeatureValueFromString(this.feature, featureValueToCopy);
        }
    }

    private static class DelayedFeature {
        protected Annotation annotation;
        protected String featureName;
        protected Feature feature;
        protected KnowtatorAnnotation featureValue;

        public DelayedFeature(Annotation annotation, String featureName, KnowtatorAnnotation featureValue) {
            this.annotation = annotation;
            this.featureName = featureName;
            this.feature = this.getFeature((TOP)this.annotation);
            this.featureValue = featureValue;
        }

        public void setValueFrom(Map<String, ? extends TOP> idAnnotationMap) {
            if (this.featureValue != null) {
                TOP valueAnnotation = idAnnotationMap.get(this.featureValue.id);
                if (valueAnnotation == null) {
                    LOGGER.warn((Object)String.format("unable to set feature; found no annotation for %s", this.featureValue.id));
                } else {
                    this.setValue(valueAnnotation);
                }
            }
        }

        protected void setValue(TOP value) {
            this.annotation.setFeatureValue(this.feature, (FeatureStructure)value);
        }

        protected Feature getFeature(TOP top) {
            Feature result = top.getType().getFeatureByBaseName(this.featureName);
            if (result == null) {
                throw new IllegalArgumentException(String.format("no feature %s on %s", this.featureName, top.getClass()));
            }
            return result;
        }
    }

    private static class DelayedRelation {
        public URI sourceFile;
        public KnowtatorAnnotation annotation;
        public KnowtatorAnnotation source;
        public KnowtatorAnnotation target;
        public String type;
        public KnowtatorAnnotation conditional;
        public KnowtatorAnnotation negation;
        public KnowtatorAnnotation uncertainty;

        public void addToIndexes(JCas jCas, Map<String, TOP> idAnnotationMap) {
            Annotation uncertaintyAnnotation;
            Annotation negationAnnotation;
            Annotation conditionalAnnotation;
            Annotation targetMention;
            Annotation sourceMention;
            if (this.source == null) {
                LOGGER.error((Object)String.format("no source for '%s' with id '%s' and annotationSlots %s in %s", this.annotation.type, this.annotation.id, this.annotation.annotationSlots.keySet(), this.sourceFile));
                return;
            }
            if (this.target == null) {
                LOGGER.error((Object)String.format("no target for '%s' with id '%s' and annotationSlots %s in %s", this.annotation.type, this.annotation.id, this.annotation.annotationSlots.keySet(), this.sourceFile));
                return;
            }
            try {
                sourceMention = (Annotation)idAnnotationMap.get(this.source.id);
            }
            catch (ClassCastException e) {
                LOGGER.error((Object)String.format("invalid source %s: %s", this.source.id, e.getMessage()));
                return;
            }
            try {
                targetMention = (Annotation)idAnnotationMap.get(this.target.id);
            }
            catch (ClassCastException e) {
                LOGGER.error((Object)String.format("invalid target %s: %s", this.target.id, e.getMessage()));
                return;
            }
            if (sourceMention == null) {
                LOGGER.error((Object)String.format("no Annotation for source id '%s' in %s", this.source.id, this.sourceFile));
                return;
            }
            if (targetMention == null) {
                LOGGER.error((Object)String.format("no Annotation for target id '%s' in %s", this.target.id, this.sourceFile));
                return;
            }
            if (this.conditional != null && (conditionalAnnotation = (Annotation)idAnnotationMap.get(this.conditional.id)) == null) {
                throw new UnsupportedOperationException(String.format("no annotation with id '%s' in %s", this.conditional.id, this.sourceFile));
            }
            if (this.negation != null && (negationAnnotation = (Annotation)idAnnotationMap.get(this.negation.id)) == null) {
                throw new UnsupportedOperationException(String.format("no annotation with id '%s' in %s", this.negation.id, this.sourceFile));
            }
            if (this.uncertainty != null && (uncertaintyAnnotation = (Annotation)idAnnotationMap.get(this.uncertainty.id)) == null) {
                throw new UnsupportedOperationException(String.format("no annotation with id '%s' in %s", this.uncertainty.id, this.sourceFile));
            }
            AffectsTextRelation relation = null;
            if ("affects".equals(this.annotation.type)) {
                this.assertTypes(sourceMention, EventMention.class, targetMention, IdentifiedAnnotation.class);
                relation = new AffectsTextRelation(jCas);
            } else if ("complicates/disrupts".equals(this.annotation.type)) {
                this.assertTypes(sourceMention, EventMention.class, targetMention, EventMention.class);
                relation = new ComplicatesDisruptsTextRelation(jCas);
            } else if ("causes/brings_about".equals(this.annotation.type)) {
                this.assertTypes(sourceMention, EventMention.class, targetMention, EventMention.class);
                relation = new CausesBringsAboutTextRelation(jCas);
            } else if ("indicates".equals(this.annotation.type)) {
                this.assertTypes(sourceMention, EventMention.class, targetMention, EventMention.class);
                relation = new IndicatesTextRelation(jCas);
            } else if ("degree_of".equals(this.annotation.type)) {
                this.assertTypes(sourceMention, EventMention.class, targetMention, Modifier.class);
                relation = new DegreeOfTextRelation(jCas);
            } else if ("location_of".equals(this.annotation.type)) {
                if (!(targetMention instanceof AnatomicalSiteMention) && sourceMention instanceof AnatomicalSiteMention) {
                    Annotation temp = sourceMention;
                    sourceMention = targetMention;
                    targetMention = temp;
                }
                this.assertTypes(sourceMention, IdentifiedAnnotation.class, targetMention, AnatomicalSiteMention.class);
                relation = new LocationOfTextRelation(jCas);
            } else if ("manages/treats".equals(this.annotation.type)) {
                this.assertTypes(sourceMention, EventMention.class, targetMention, EventMention.class);
                relation = new ManagesTreatsTextRelation(jCas);
            } else if ("manifestation_of".equals(this.annotation.type)) {
                this.assertTypes(sourceMention, EventMention.class, targetMention, EventMention.class);
                relation = new ManifestationOfTextRelation(jCas);
                relation.setCategory("manifestation_of");
            } else if ("prevents".equals(this.annotation.type)) {
                this.assertTypes(sourceMention, EventMention.class, targetMention, EventMention.class);
                relation = new PreventsTextRelation(jCas);
            } else if ("result_of".equals(this.annotation.type)) {
                this.assertTypes(sourceMention, EventMention.class, targetMention, IdentifiedAnnotation.class);
                relation = new ResultOfTextRelation(jCas);
            } else if ("TLINK".equals(this.annotation.type)) {
                relation = new TemporalTextRelation(jCas);
                relation.setCategory(this.type);
            } else if ("ALINK".equals(this.annotation.type)) {
                relation = new AspectualTextRelation(jCas);
                relation.setCategory(this.type);
            } else {
                relation = new BinaryTextRelation(jCas);
            }
            if (relation.getCategory() == null) {
                relation.setCategory(this.annotation.type);
            }
            RelationArgument sourceRA = new RelationArgument(jCas);
            sourceRA.setArgument(sourceMention);
            sourceRA.addToIndexes();
            RelationArgument targetRA = new RelationArgument(jCas);
            targetRA.setArgument(targetMention);
            targetRA.addToIndexes();
            relation.setArg1(sourceRA);
            relation.setArg2(targetRA);
            relation.addToIndexes();
            idAnnotationMap.put(this.annotation.id, (TOP)relation);
        }

        private void assertTypes(Annotation sourceMention, Class<? extends Annotation> expectedSourceClass, Annotation targetMention, Class<? extends Annotation> expectedTargetClass) {
            if (!expectedSourceClass.isInstance(sourceMention) || !expectedTargetClass.isInstance(targetMention)) {
                LOGGER.warn((Object)String.format("wrong relation argument types: expected %s(%s(...), %s(...)) but found %s(%s, %s) for ids %s(%s, %s) in %s", this.annotation.type, expectedSourceClass.getSimpleName(), expectedTargetClass.getSimpleName(), this.annotation.type, SHARPKnowtatorXMLReader.format(sourceMention), SHARPKnowtatorXMLReader.format(targetMention), this.annotation.id, this.source.id, this.target.id, this.sourceFile));
            }
        }
    }
}

