/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketState;
import io.github.bucket4j.MathType;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class BucketState64BitsInteger
implements BucketState,
ComparableByContent<BucketState64BitsInteger> {
    private static final int BANDWIDTH_SIZE = 3;
    final long[] stateData;
    public static SerializationHandle<BucketState64BitsInteger> SERIALIZATION_HANDLE = new SerializationHandle<BucketState64BitsInteger>(){

        @Override
        public <S> BucketState64BitsInteger deserialize(DeserializationAdapter<S> adapter, S input, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            long[] data = adapter.readLongArray(input);
            return new BucketState64BitsInteger(data);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, BucketState64BitsInteger state, Version backwardCompatibilityVersion) throws IOException {
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
            adapter.writeLongArray(output, state.stateData);
        }

        @Override
        public int getTypeId() {
            return 3;
        }

        @Override
        public Class<BucketState64BitsInteger> getSerializedType() {
            return BucketState64BitsInteger.class;
        }
    };

    BucketState64BitsInteger(long[] stateData) {
        this.stateData = stateData;
    }

    public BucketState64BitsInteger(BucketConfiguration configuration, long currentTimeNanos) {
        Bandwidth[] bandwidths = configuration.getBandwidths();
        this.stateData = new long[bandwidths.length * 3];
        for (int i = 0; i < bandwidths.length; ++i) {
            this.setCurrentSize(i, this.calculateInitialTokens(bandwidths[i], currentTimeNanos));
            this.setLastRefillTimeNanos(i, this.calculateLastRefillTimeNanos(bandwidths[i], currentTimeNanos));
        }
    }

    @Override
    public BucketState copy() {
        return new BucketState64BitsInteger((long[])this.stateData.clone());
    }

    @Override
    public BucketState replaceConfiguration(BucketConfiguration previousConfiguration, BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy, long currentTimeNanos) {
        if (tokensInheritanceStrategy == TokensInheritanceStrategy.RESET) {
            return new BucketState64BitsInteger(newConfiguration, currentTimeNanos);
        }
        boolean nullIdComparisonCanBeApplied = this.countOfBandwidthsWithNullIdentifiers(previousConfiguration) < 2 && this.countOfBandwidthsWithNullIdentifiers(newConfiguration) < 2;
        Bandwidth[] previousBandwidths = previousConfiguration.getBandwidths();
        Bandwidth[] newBandwidths = newConfiguration.getBandwidths();
        BucketState64BitsInteger newState = new BucketState64BitsInteger(new long[newBandwidths.length * 3]);
        block5: for (int newBandwidthIndex = 0; newBandwidthIndex < newBandwidths.length; ++newBandwidthIndex) {
            Bandwidth newBandwidth = newBandwidths[newBandwidthIndex];
            Bandwidth previousBandwidth = null;
            int previousBandwidthIndex = -1;
            if (newBandwidth.getId() != null || nullIdComparisonCanBeApplied) {
                for (int j = 0; j < previousBandwidths.length; ++j) {
                    if (!Objects.equals(newBandwidth.getId(), previousBandwidths[j].getId())) continue;
                    previousBandwidth = previousBandwidths[j];
                    previousBandwidthIndex = j;
                    break;
                }
            }
            if (previousBandwidth == null) {
                newState.setCurrentSize(newBandwidthIndex, this.calculateInitialTokens(newBandwidth, currentTimeNanos));
                newState.setLastRefillTimeNanos(newBandwidthIndex, this.calculateLastRefillTimeNanos(newBandwidth, currentTimeNanos));
                continue;
            }
            switch (tokensInheritanceStrategy) {
                case AS_IS: {
                    this.replaceBandwidthAsIs(newState, newBandwidthIndex, newBandwidth, previousBandwidthIndex, previousBandwidth, currentTimeNanos);
                    continue block5;
                }
                case PROPORTIONALLY: {
                    this.replaceBandwidthProportional(newState, newBandwidthIndex, newBandwidth, previousBandwidthIndex, previousBandwidth, currentTimeNanos);
                    continue block5;
                }
                case ADDITIVE: {
                    this.replaceBandwidthAdditive(newState, newBandwidthIndex, newBandwidth, previousBandwidthIndex, previousBandwidth, currentTimeNanos);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Should never reach there");
                }
            }
        }
        return newState;
    }

    private void replaceBandwidthAsIs(BucketState64BitsInteger newState, int newBandwidthIndex, Bandwidth newBandwidth, int previousBandwidthIndex, Bandwidth previousBandwidth, long currentTimeNanos) {
        long lastRefillTimeNanos = this.getLastRefillTimeNanos(previousBandwidthIndex);
        newState.setLastRefillTimeNanos(newBandwidthIndex, lastRefillTimeNanos);
        long currentSize = this.getCurrentSize(previousBandwidthIndex);
        if (currentSize >= newBandwidth.capacity) {
            newState.setCurrentSize(newBandwidthIndex, newBandwidth.capacity);
            return;
        }
        if (newBandwidth.isGready() && previousBandwidth.isGready()) {
            long newSize = Math.min(newBandwidth.capacity, currentSize);
            newState.setCurrentSize(newBandwidthIndex, newSize);
            long roundingError = this.getRoundingError(previousBandwidthIndex);
            double roundingScale = (double)newBandwidth.refillPeriodNanos / (double)previousBandwidth.refillPeriodNanos;
            long newRoundingError = (long)roundingScale * roundingError;
            if (newRoundingError >= newBandwidth.refillPeriodNanos) {
                newRoundingError = newBandwidth.refillPeriodNanos - 1L;
            }
            newState.setRoundingError(newBandwidthIndex, newRoundingError);
            return;
        }
        long newSize = Math.min(newBandwidth.capacity, currentSize);
        newState.setCurrentSize(newBandwidthIndex, newSize);
    }

    private void replaceBandwidthProportional(BucketState64BitsInteger newState, int newBandwidthIndex, Bandwidth newBandwidth, int previousBandwidthIndex, Bandwidth previousBandwidth, long currentTimeNanos) {
        double scale;
        newState.setLastRefillTimeNanos(newBandwidthIndex, this.getLastRefillTimeNanos(previousBandwidthIndex));
        long currentSize = this.getCurrentSize(previousBandwidthIndex);
        if (currentSize >= previousBandwidth.capacity) {
            newState.setCurrentSize(newBandwidthIndex, newBandwidth.capacity);
            return;
        }
        long roundingError = this.getRoundingError(previousBandwidthIndex);
        double realRoundedError = (double)roundingError / (double)previousBandwidth.refillPeriodNanos;
        double realNewSize = ((double)currentSize + realRoundedError) * (scale = (double)newBandwidth.capacity / (double)previousBandwidth.capacity);
        long newSize = (long)realNewSize;
        if (newSize >= newBandwidth.capacity) {
            newState.setCurrentSize(newBandwidthIndex, newBandwidth.capacity);
            return;
        }
        if (newSize == Long.MIN_VALUE) {
            newState.setCurrentSize(newBandwidthIndex, Long.MIN_VALUE);
            return;
        }
        double restOfDivision = realNewSize - (double)newSize;
        if (restOfDivision > 1.0 || restOfDivision < -1.0) {
            restOfDivision = realNewSize % 1.0;
        }
        if (restOfDivision == 0.0) {
            newState.setCurrentSize(newBandwidthIndex, newSize);
            return;
        }
        if (realNewSize < 0.0) {
            --newSize;
            restOfDivision += 1.0;
        }
        newState.setCurrentSize(newBandwidthIndex, newSize);
        if (newBandwidth.isGready()) {
            long newRoundingError = (long)(restOfDivision * (double)newBandwidth.refillPeriodNanos);
            newState.setRoundingError(newBandwidthIndex, newRoundingError);
        }
    }

    private void replaceBandwidthAdditive(BucketState64BitsInteger newState, int newBandwidthIndex, Bandwidth newBandwidth, int previousBandwidthIndex, Bandwidth previousBandwidth, long currentTimeNanos) {
        if (newBandwidth.capacity <= previousBandwidth.capacity) {
            this.replaceBandwidthAsIs(newState, newBandwidthIndex, newBandwidth, previousBandwidthIndex, previousBandwidth, currentTimeNanos);
            return;
        }
        long lastRefillTimeNanos = this.getLastRefillTimeNanos(previousBandwidthIndex);
        newState.setLastRefillTimeNanos(newBandwidthIndex, lastRefillTimeNanos);
        long currentSize = this.getCurrentSize(previousBandwidthIndex);
        if (currentSize >= previousBandwidth.capacity) {
            newState.setCurrentSize(newBandwidthIndex, newBandwidth.capacity);
            return;
        }
        long newSize = currentSize + (newBandwidth.capacity - previousBandwidth.capacity);
        newState.setCurrentSize(newBandwidthIndex, newSize);
        if (newSize < newBandwidth.capacity && newBandwidth.isGready() && previousBandwidth.isGready()) {
            double roundingScale = (double)newBandwidth.refillPeriodNanos / (double)previousBandwidth.refillPeriodNanos;
            long roundingError = this.getRoundingError(previousBandwidthIndex);
            long newRoundingError = (long)roundingScale * roundingError;
            if (newRoundingError >= newBandwidth.refillPeriodNanos) {
                newRoundingError = newBandwidth.refillPeriodNanos - 1L;
            }
            newState.setRoundingError(newBandwidthIndex, newRoundingError);
        }
    }

    private int countOfBandwidthsWithNullIdentifiers(BucketConfiguration configuration) {
        Bandwidth[] bandwidths = configuration.getBandwidths();
        int count = 0;
        for (int i = 0; i < bandwidths.length; ++i) {
            if (bandwidths[i].getId() != null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void copyStateFrom(BucketState sourceState) {
        BucketState64BitsInteger sourceState64BitsInteger = (BucketState64BitsInteger)sourceState;
        System.arraycopy(sourceState64BitsInteger.stateData, 0, this.stateData, 0, this.stateData.length);
    }

    @Override
    public long getAvailableTokens(Bandwidth[] bandwidths) {
        long availableTokens = this.getCurrentSize(0);
        for (int i = 1; i < bandwidths.length; ++i) {
            availableTokens = Math.min(availableTokens, this.getCurrentSize(i));
        }
        return availableTokens;
    }

    @Override
    public void consume(Bandwidth[] bandwidths, long toConsume) {
        for (int i = 0; i < bandwidths.length; ++i) {
            this.consume(i, toConsume);
        }
    }

    @Override
    public long calculateDelayNanosAfterWillBePossibleToConsume(Bandwidth[] bandwidths, long tokensToConsume, long currentTimeNanos) {
        long delayAfterWillBePossibleToConsume = this.calculateDelayNanosAfterWillBePossibleToConsume(0, bandwidths[0], tokensToConsume, currentTimeNanos);
        for (int i = 1; i < bandwidths.length; ++i) {
            Bandwidth bandwidth = bandwidths[i];
            long delay = this.calculateDelayNanosAfterWillBePossibleToConsume(i, bandwidth, tokensToConsume, currentTimeNanos);
            if (delay <= (delayAfterWillBePossibleToConsume = Math.max(delayAfterWillBePossibleToConsume, delay))) continue;
            delayAfterWillBePossibleToConsume = delay;
        }
        return delayAfterWillBePossibleToConsume;
    }

    @Override
    public void refillAllBandwidth(Bandwidth[] limits, long currentTimeNanos) {
        for (int i = 0; i < limits.length; ++i) {
            this.refill(i, limits[i], currentTimeNanos);
        }
    }

    @Override
    public void addTokens(Bandwidth[] limits, long tokensToAdd) {
        for (int i = 0; i < limits.length; ++i) {
            this.addTokens(i, limits[i], tokensToAdd);
        }
    }

    @Override
    public void forceAddTokens(Bandwidth[] limits, long tokensToAdd) {
        for (int i = 0; i < limits.length; ++i) {
            this.forceAddTokens(i, limits[i], tokensToAdd);
        }
    }

    private long calculateLastRefillTimeNanos(Bandwidth bandwidth, long currentTimeNanos) {
        if (!bandwidth.isIntervallyAligned()) {
            return currentTimeNanos;
        }
        return bandwidth.timeOfFirstRefillMillis * 1000000L - bandwidth.refillPeriodNanos;
    }

    private long calculateInitialTokens(Bandwidth bandwidth, long currentTimeNanos) {
        if (!bandwidth.useAdaptiveInitialTokens) {
            return bandwidth.initialTokens;
        }
        long timeOfFirstRefillNanos = bandwidth.timeOfFirstRefillMillis * 1000000L;
        if (currentTimeNanos >= timeOfFirstRefillNanos) {
            return bandwidth.initialTokens;
        }
        long guaranteedBase = Math.max(0L, bandwidth.capacity - bandwidth.refillTokens);
        long nanosBeforeFirstRefill = timeOfFirstRefillNanos - currentTimeNanos;
        if (BucketState64BitsInteger.multiplyExactOrReturnMaxValue(nanosBeforeFirstRefill, bandwidth.refillTokens) != Long.MAX_VALUE) {
            return Math.min(bandwidth.capacity, guaranteedBase + nanosBeforeFirstRefill * bandwidth.refillTokens / bandwidth.refillPeriodNanos);
        }
        return Math.min(bandwidth.capacity, guaranteedBase + (long)((double)nanosBeforeFirstRefill * (double)bandwidth.refillTokens / (double)bandwidth.refillPeriodNanos));
    }

    @Override
    public long calculateFullRefillingTime(Bandwidth[] bandwidths, long currentTimeNanos) {
        long maxTimeToFullRefillNanos = this.calculateFullRefillingTime(0, bandwidths[0], currentTimeNanos);
        for (int i = 1; i < bandwidths.length; ++i) {
            maxTimeToFullRefillNanos = Math.max(maxTimeToFullRefillNanos, this.calculateFullRefillingTime(i, bandwidths[i], currentTimeNanos));
        }
        return maxTimeToFullRefillNanos;
    }

    private long calculateFullRefillingTime(int bandwidthIndex, Bandwidth bandwidth, long currentTimeNanos) {
        long availableTokens = this.getCurrentSize(bandwidthIndex);
        if (availableTokens >= bandwidth.capacity) {
            return 0L;
        }
        long deficit = bandwidth.capacity - availableTokens;
        if (bandwidth.isRefillIntervally()) {
            return this.calculateDelayNanosAfterWillBePossibleToConsumeForIntervalBandwidth(bandwidthIndex, bandwidth, deficit, currentTimeNanos);
        }
        return this.calculateDelayNanosAfterWillBePossibleToConsumeForGreedyBandwidth(bandwidthIndex, bandwidth, deficit);
    }

    private void addTokens(int bandwidthIndex, Bandwidth bandwidth, long tokensToAdd) {
        long currentSize = this.getCurrentSize(bandwidthIndex);
        long newSize = currentSize + tokensToAdd;
        if (newSize >= bandwidth.getCapacity()) {
            this.resetBandwidth(bandwidthIndex, bandwidth.getCapacity());
        } else if (newSize < currentSize) {
            this.resetBandwidth(bandwidthIndex, bandwidth.getCapacity());
        } else {
            this.setCurrentSize(bandwidthIndex, newSize);
        }
    }

    private void forceAddTokens(int bandwidthIndex, Bandwidth bandwidth, long tokensToAdd) {
        long currentSize = this.getCurrentSize(bandwidthIndex);
        long newSize = currentSize + tokensToAdd;
        if (newSize < currentSize) {
            this.setCurrentSize(bandwidthIndex, Long.MAX_VALUE);
            this.setRoundingError(bandwidthIndex, 0L);
        } else {
            this.setCurrentSize(bandwidthIndex, newSize);
        }
    }

    private void refill(int bandwidthIndex, Bandwidth bandwidth, long currentTimeNanos) {
        long previousRefillNanos = this.getLastRefillTimeNanos(bandwidthIndex);
        if (currentTimeNanos <= previousRefillNanos) {
            return;
        }
        if (bandwidth.isRefillIntervally()) {
            long incompleteIntervalCorrection = (currentTimeNanos - previousRefillNanos) % bandwidth.getRefillPeriodNanos();
            currentTimeNanos -= incompleteIntervalCorrection;
        }
        if (currentTimeNanos <= previousRefillNanos) {
            return;
        }
        this.setLastRefillTimeNanos(bandwidthIndex, currentTimeNanos);
        long capacity = bandwidth.getCapacity();
        long refillPeriodNanos = bandwidth.getRefillPeriodNanos();
        long refillTokens = bandwidth.getRefillTokens();
        long currentSize = this.getCurrentSize(bandwidthIndex);
        if (currentSize >= capacity) {
            return;
        }
        long durationSinceLastRefillNanos = currentTimeNanos - previousRefillNanos;
        long newSize = currentSize;
        if (durationSinceLastRefillNanos > refillPeriodNanos) {
            long elapsedPeriods = durationSinceLastRefillNanos / refillPeriodNanos;
            long calculatedRefill = elapsedPeriods * refillTokens;
            if ((newSize += calculatedRefill) > capacity) {
                this.resetBandwidth(bandwidthIndex, capacity);
                return;
            }
            if (newSize < currentSize) {
                this.resetBandwidth(bandwidthIndex, capacity);
                return;
            }
            durationSinceLastRefillNanos %= refillPeriodNanos;
        }
        long roundingError = this.getRoundingError(bandwidthIndex);
        long dividedWithoutError = BucketState64BitsInteger.multiplyExactOrReturnMaxValue(refillTokens, durationSinceLastRefillNanos);
        long divided = dividedWithoutError + roundingError;
        if (divided < 0L || dividedWithoutError == Long.MAX_VALUE) {
            long calculatedRefill = (long)((double)durationSinceLastRefillNanos / (double)refillPeriodNanos * (double)refillTokens);
            newSize += calculatedRefill;
            roundingError = 0L;
        } else {
            long calculatedRefill = divided / refillPeriodNanos;
            if (calculatedRefill == 0L) {
                roundingError = divided;
            } else {
                newSize += calculatedRefill;
                roundingError = divided % refillPeriodNanos;
            }
        }
        if (newSize >= capacity) {
            this.resetBandwidth(bandwidthIndex, capacity);
            return;
        }
        if (newSize < currentSize) {
            this.resetBandwidth(bandwidthIndex, capacity);
            return;
        }
        this.setCurrentSize(bandwidthIndex, newSize);
        this.setRoundingError(bandwidthIndex, roundingError);
    }

    private void resetBandwidth(int bandwidthIndex, long capacity) {
        this.setCurrentSize(bandwidthIndex, capacity);
        this.setRoundingError(bandwidthIndex, 0L);
    }

    private long calculateDelayNanosAfterWillBePossibleToConsume(int bandwidthIndex, Bandwidth bandwidth, long tokens, long currentTimeNanos) {
        long currentSize = this.getCurrentSize(bandwidthIndex);
        if (tokens <= currentSize) {
            return 0L;
        }
        long deficit = tokens - currentSize;
        if (deficit <= 0L) {
            return Long.MAX_VALUE;
        }
        if (bandwidth.isRefillIntervally()) {
            return this.calculateDelayNanosAfterWillBePossibleToConsumeForIntervalBandwidth(bandwidthIndex, bandwidth, deficit, currentTimeNanos);
        }
        return this.calculateDelayNanosAfterWillBePossibleToConsumeForGreedyBandwidth(bandwidthIndex, bandwidth, deficit);
    }

    private long calculateDelayNanosAfterWillBePossibleToConsumeForGreedyBandwidth(int bandwidthIndex, Bandwidth bandwidth, long deficit) {
        long refillPeriodNanos = bandwidth.getRefillPeriodNanos();
        long refillPeriodTokens = bandwidth.getRefillTokens();
        long divided = BucketState64BitsInteger.multiplyExactOrReturnMaxValue(refillPeriodNanos, deficit);
        if (divided == Long.MAX_VALUE) {
            return (long)((double)deficit / (double)refillPeriodTokens * (double)refillPeriodNanos);
        }
        long correctionForPartiallyRefilledToken = this.getRoundingError(bandwidthIndex);
        return (divided -= correctionForPartiallyRefilledToken) / refillPeriodTokens;
    }

    private long calculateDelayNanosAfterWillBePossibleToConsumeForIntervalBandwidth(int bandwidthIndex, Bandwidth bandwidth, long deficit, long currentTimeNanos) {
        long refillPeriodNanos = bandwidth.getRefillPeriodNanos();
        long refillTokens = bandwidth.getRefillTokens();
        long previousRefillNanos = this.getLastRefillTimeNanos(bandwidthIndex);
        long timeOfNextRefillNanos = previousRefillNanos + refillPeriodNanos;
        long waitForNextRefillNanos = timeOfNextRefillNanos - currentTimeNanos;
        if (deficit <= refillTokens) {
            return waitForNextRefillNanos;
        }
        if ((deficit -= refillTokens) < refillTokens) {
            return waitForNextRefillNanos + refillPeriodNanos;
        }
        long deficitPeriods = deficit / refillTokens + (long)(deficit % refillTokens == 0L ? 0 : 1);
        long deficitNanos = BucketState64BitsInteger.multiplyExactOrReturnMaxValue(deficitPeriods, refillPeriodNanos);
        if (deficitNanos == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        if ((deficitNanos += waitForNextRefillNanos) < 0L) {
            return Long.MAX_VALUE;
        }
        return deficitNanos;
    }

    private long getLastRefillTimeNanos(int bandwidth) {
        return this.stateData[bandwidth * 3];
    }

    private void setLastRefillTimeNanos(int bandwidth, long nanos) {
        this.stateData[bandwidth * 3] = nanos;
    }

    @Override
    public long getCurrentSize(int bandwidth) {
        return this.stateData[bandwidth * 3 + 1];
    }

    @Override
    public long getRoundingError(int bandwidth) {
        return this.stateData[bandwidth * 3 + 2];
    }

    @Override
    public MathType getMathType() {
        return MathType.INTEGER_64_BITS;
    }

    private void setCurrentSize(int bandwidth, long currentSize) {
        this.stateData[bandwidth * 3 + 1] = currentSize;
    }

    private void consume(int bandwidth, long tokens) {
        int n = bandwidth * 3 + 1;
        this.stateData[n] = this.stateData[n] - tokens;
    }

    private void setRoundingError(int bandwidth, long roundingError) {
        this.stateData[bandwidth * 3 + 2] = roundingError;
    }

    public String toString() {
        return "BucketState{bandwidthStates=" + Arrays.toString(this.stateData) + '}';
    }

    private static long multiplyExactOrReturnMaxValue(long x, long y) {
        long ay;
        long r = x * y;
        long ax = Math.abs(x);
        if ((ax | (ay = Math.abs(y))) >>> 31 != 0L && (y != 0L && r / y != x || x == Long.MIN_VALUE && y == -1L)) {
            return Long.MAX_VALUE;
        }
        return r;
    }

    @Override
    public boolean equalsByContent(BucketState64BitsInteger other) {
        return Arrays.equals(this.stateData, other.stateData);
    }
}

