/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactoryImpl;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.parameter.Encoding;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.util.DecoderFactory;
import net.fortuna.ical4j.util.EncoderFactory;
import net.fortuna.ical4j.util.ParameterValidator;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.util.Uris;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Attach
extends Property {
    private static final long serialVersionUID = 4439949507756383452L;
    private URI uri;
    private byte[] binary;
    static /* synthetic */ Class class$0;

    public Attach() {
        super("ATTACH", PropertyFactoryImpl.getInstance());
    }

    public Attach(ParameterList aList, String aValue) throws IOException, URISyntaxException {
        super("ATTACH", aList, PropertyFactoryImpl.getInstance());
        this.setValue(aValue);
    }

    public Attach(byte[] data) {
        super("ATTACH", PropertyFactoryImpl.getInstance());
        this.getParameters().add(Encoding.BASE64);
        this.getParameters().add(Value.BINARY);
        this.binary = data;
    }

    public Attach(ParameterList aList, byte[] data) {
        super("ATTACH", aList, PropertyFactoryImpl.getInstance());
        this.binary = data;
    }

    public Attach(URI aUri) {
        super("ATTACH", PropertyFactoryImpl.getInstance());
        this.uri = aUri;
    }

    public Attach(ParameterList aList, URI aUri) {
        super("ATTACH", aList, PropertyFactoryImpl.getInstance());
        this.uri = aUri;
    }

    public final void validate() throws ValidationException {
        ParameterValidator.getInstance().assertOneOrLess("FMTTYPE", this.getParameters());
        if (Value.BINARY.equals(this.getParameter("VALUE"))) {
            ParameterValidator.getInstance().assertOne("ENCODING", this.getParameters());
            if (!Encoding.BASE64.equals(this.getParameter("ENCODING"))) {
                throw new ValidationException("If the value type parameter is [BINARY], the inlineencoding parameter MUST be specified with the value [BASE64]");
            }
        }
    }

    public final byte[] getBinary() {
        return this.binary;
    }

    public final URI getUri() {
        return this.uri;
    }

    public final void setValue(String aValue) throws IOException, URISyntaxException {
        if (this.getParameter("ENCODING") != null) {
            try {
                BinaryDecoder decoder = DecoderFactory.getInstance().createBinaryDecoder((Encoding)this.getParameter("ENCODING"));
                this.binary = decoder.decode(aValue.getBytes());
            }
            catch (UnsupportedEncodingException uee) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("net.fortuna.ical4j.model.property.Attach");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log log = LogFactory.getLog((Class)clazz);
                log.error((Object)"Error encoding binary data", (Throwable)uee);
            }
            catch (DecoderException de) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("net.fortuna.ical4j.model.property.Attach");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log log = LogFactory.getLog((Class)clazz);
                log.error((Object)"Error decoding binary data", (Throwable)de);
            }
        } else {
            this.uri = Uris.create(aValue);
        }
    }

    public final String getValue() {
        if (this.getUri() != null) {
            return Uris.decode(Strings.valueOf(this.getUri()));
        }
        if (this.getBinary() != null) {
            try {
                BinaryEncoder encoder = EncoderFactory.getInstance().createBinaryEncoder((Encoding)this.getParameter("ENCODING"));
                return new String(encoder.encode(this.getBinary()));
            }
            catch (UnsupportedEncodingException uee) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("net.fortuna.ical4j.model.property.Attach");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log log = LogFactory.getLog((Class)clazz);
                log.error((Object)"Error encoding binary data", (Throwable)uee);
            }
            catch (EncoderException ee) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("net.fortuna.ical4j.model.property.Attach");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log log = LogFactory.getLog((Class)clazz);
                log.error((Object)"Error encoding binary data", (Throwable)ee);
            }
        }
        return null;
    }

    public final void setBinary(byte[] binary) {
        this.binary = binary;
        this.uri = null;
    }

    public final void setUri(URI uri) {
        this.uri = uri;
        this.binary = null;
    }
}

