/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns.util;

import com.eatthepath.uuid.FastUUID;
import com.turo.pushy.apns.ApnsPushNotification;
import com.turo.pushy.apns.DeliveryPriority;
import com.turo.pushy.apns.PushType;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class SimpleApnsPushNotification
implements ApnsPushNotification {
    private final String token;
    private final String payload;
    private final Date invalidationTime;
    private final DeliveryPriority priority;
    private final PushType pushType;
    private final String topic;
    private final String collapseId;
    private final UUID apnsId;
    public static final long DEFAULT_EXPIRATION_PERIOD_MILLIS = TimeUnit.DAYS.toMillis(1L);

    public SimpleApnsPushNotification(String token, String topic, String payload) {
        this(token, topic, payload, new Date(System.currentTimeMillis() + DEFAULT_EXPIRATION_PERIOD_MILLIS), DeliveryPriority.IMMEDIATE, null, null, null);
    }

    public SimpleApnsPushNotification(String token, String topic, String payload, Date invalidationTime) {
        this(token, topic, payload, invalidationTime, DeliveryPriority.IMMEDIATE, null, null, null);
    }

    public SimpleApnsPushNotification(String token, String topic, String payload, Date invalidationTime, DeliveryPriority priority) {
        this(token, topic, payload, invalidationTime, priority, null, null, null);
    }

    public SimpleApnsPushNotification(String token, String topic, String payload, Date invalidationTime, DeliveryPriority priority, PushType pushType) {
        this(token, topic, payload, invalidationTime, priority, pushType, null, null);
    }

    public SimpleApnsPushNotification(String token, String topic, String payload, Date invalidationTime, DeliveryPriority priority, String collapseId) {
        this(token, topic, payload, invalidationTime, priority, null, collapseId, null);
    }

    public SimpleApnsPushNotification(String token, String topic, String payload, Date invalidationTime, DeliveryPriority priority, PushType pushType, String collapseId) {
        this(token, topic, payload, invalidationTime, priority, pushType, collapseId, null);
    }

    public SimpleApnsPushNotification(String token, String topic, String payload, Date invalidationTime, DeliveryPriority priority, String collapseId, UUID apnsId) {
        this(token, topic, payload, invalidationTime, priority, null, collapseId, apnsId);
    }

    public SimpleApnsPushNotification(String token, String topic, String payload, Date invalidationTime, DeliveryPriority priority, PushType pushType, String collapseId, UUID apnsId) {
        this.token = Objects.requireNonNull(token, "Destination device token must not be null.");
        this.topic = Objects.requireNonNull(topic, "Destination topic must not be null.");
        this.payload = Objects.requireNonNull(payload, "Payload must not be null.");
        this.invalidationTime = invalidationTime;
        this.priority = priority;
        this.pushType = pushType;
        this.collapseId = collapseId;
        this.apnsId = apnsId;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getPayload() {
        return this.payload;
    }

    @Override
    public Date getExpiration() {
        return this.invalidationTime;
    }

    @Override
    public DeliveryPriority getPriority() {
        return this.priority;
    }

    @Override
    public PushType getPushType() {
        return this.pushType;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public String getCollapseId() {
        return this.collapseId;
    }

    @Override
    public UUID getApnsId() {
        return this.apnsId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.invalidationTime == null ? 0 : this.invalidationTime.hashCode());
        result = 31 * result + (this.payload == null ? 0 : this.payload.hashCode());
        result = 31 * result + (this.priority == null ? 0 : this.priority.hashCode());
        result = 31 * result + (this.pushType == null ? 0 : this.pushType.hashCode());
        result = 31 * result + (this.token == null ? 0 : this.token.hashCode());
        result = 31 * result + (this.topic == null ? 0 : this.topic.hashCode());
        result = 31 * result + (this.collapseId == null ? 0 : this.collapseId.hashCode());
        result = 31 * result + (this.apnsId == null ? 0 : this.apnsId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleApnsPushNotification)) {
            return false;
        }
        SimpleApnsPushNotification other = (SimpleApnsPushNotification)obj;
        if (this.invalidationTime == null ? other.invalidationTime != null : !this.invalidationTime.equals(other.invalidationTime)) {
            return false;
        }
        if (this.payload == null ? other.payload != null : !this.payload.equals(other.payload)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.pushType != other.pushType) {
            return false;
        }
        if (this.token == null ? other.token != null : !this.token.equals(other.token)) {
            return false;
        }
        if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
            return false;
        }
        if (Objects.equals(this.collapseId, null) ? !Objects.equals(other.collapseId, null) : !this.collapseId.equals(other.collapseId)) {
            return false;
        }
        return !(Objects.equals(this.apnsId, null) ? !Objects.equals(other.apnsId, null) : !this.apnsId.equals(other.apnsId));
    }

    public String toString() {
        return "SimpleApnsPushNotification{token='" + this.token + '\'' + ", payload='" + this.payload + '\'' + ", invalidationTime=" + this.invalidationTime + ", priority=" + (Object)((Object)this.priority) + ", pushType=" + (Object)((Object)this.pushType) + ", topic='" + this.topic + '\'' + ", collapseId='" + this.collapseId + '\'' + ", apnsId=" + (this.apnsId != null ? FastUUID.toString((UUID)this.apnsId) : null) + '}';
    }
}

