/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns.auth;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.ECKey;
import java.security.spec.ECParameterSpec;
import java.util.Objects;

abstract class ApnsKey
implements ECKey {
    private final String teamId;
    private final String keyId;
    private final ECKey key;
    public static final String APNS_SIGNATURE_ALGORITHM = "SHA256withECDSA";

    public ApnsKey(String keyId, String teamId, ECKey key) {
        Objects.requireNonNull(keyId, "Key identifier must not be null.");
        Objects.requireNonNull(teamId, "Team identifier must not be null.");
        Objects.requireNonNull(key, "Key must not be null.");
        this.keyId = keyId;
        this.teamId = teamId;
        this.key = key;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getTeamId() {
        return this.teamId;
    }

    protected ECKey getKey() {
        return this.key;
    }

    @Override
    public ECParameterSpec getParams() {
        return this.key.getParams();
    }

    protected static byte[] decodeBase64EncodedString(String base64EncodedString) {
        ByteBuf base64EncodedByteBuf = Unpooled.wrappedBuffer((byte[])base64EncodedString.getBytes(StandardCharsets.US_ASCII));
        ByteBuf decodedByteBuf = Base64.decode((ByteBuf)base64EncodedByteBuf);
        byte[] decodedBytes = new byte[decodedByteBuf.readableBytes()];
        decodedByteBuf.readBytes(decodedBytes);
        base64EncodedByteBuf.release();
        decodedByteBuf.release();
        return decodedBytes;
    }
}

