/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.scale;

import org.jcodec.common.model.Size;
import org.jcodec.scale.BaseResampler;

public class LanczosResampler
extends BaseResampler {
    private int nTaps = 6;
    private int precision = 256;
    private short[][] tapsXs;
    private short[][] tapsYs;
    private double scaleFactorX;
    private double scaleFactorY;

    public LanczosResampler(Size from, Size to) {
        super(from, to);
        this.scaleFactorX = (double)to.getWidth() / (double)from.getWidth();
        this.scaleFactorY = (double)to.getHeight() / (double)from.getHeight();
        this.tapsXs = new short[this.precision][this.nTaps];
        this.tapsYs = new short[this.precision][this.nTaps];
        LanczosResampler.buildTaps(this.nTaps, this.precision, this.scaleFactorX, this.tapsXs);
        LanczosResampler.buildTaps(this.nTaps, this.precision, this.scaleFactorY, this.tapsYs);
    }

    private static double sinc(double x) {
        return x == 0.0 ? 1.0 : Math.sin(x) / x;
    }

    private static void buildTaps(int nTaps, int precision, double scaleFactor, short[][] tapsOut) {
        double[] taps = new double[nTaps];
        for (int i = 0; i < precision; ++i) {
            double o = (double)i / (double)precision;
            int j = -nTaps / 2 + 1;
            int t = 0;
            while (j < nTaps / 2 + 1) {
                double x = -o + (double)j;
                double sinc_val = scaleFactor * LanczosResampler.sinc(scaleFactor * x * Math.PI);
                double wnd_val = Math.sin(x * Math.PI / (double)(nTaps - 1) + 1.5707963267948966);
                taps[t] = sinc_val * wnd_val;
                ++j;
                ++t;
            }
            LanczosResampler.normalizeAndGenerateFixedPrecision(taps, 7, tapsOut[i]);
        }
    }

    @Override
    protected short[] getTapsX(int dstX) {
        int oi = (int)((double)(dstX * this.precision) / this.scaleFactorX);
        int sub_pel = oi % this.precision;
        return this.tapsXs[sub_pel];
    }

    @Override
    protected short[] getTapsY(int dstY) {
        int oy = (int)((double)(dstY * this.precision) / this.scaleFactorY);
        int sub_pel = oy % this.precision;
        return this.tapsYs[sub_pel];
    }

    @Override
    protected int nTaps() {
        return this.nTaps;
    }
}

