/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged.clocks;

import java.util.concurrent.atomic.AtomicLong;
import org.fishwife.jrugged.clocks.HardwareClock;
import org.fishwife.jrugged.interval.DiscreteInterval;

class DefaultHardwareClock
implements HardwareClock {
    private static long DEFAULT_PERIOD_MILLIS = 100000L;
    private long periodMillis = DEFAULT_PERIOD_MILLIS;
    private static int DEFAULT_NUM_SAMPLES = 100;
    private static long MIN_CLOCK_TIME = 31536000000000000L;
    private AtomicLong lastSampleTime = new AtomicLong(0L);
    private int sampleIndex = 0;
    private long maxGranularity;
    private long[] samples;
    private Long offset;
    private Env env;

    public DefaultHardwareClock() {
        this(new DefaultEnv(), DEFAULT_NUM_SAMPLES, DEFAULT_PERIOD_MILLIS);
    }

    public DefaultHardwareClock(Env env) {
        this(env, DEFAULT_NUM_SAMPLES, DEFAULT_PERIOD_MILLIS);
    }

    public DefaultHardwareClock(Env env, int numSamples, long periodMillis) {
        this.env = env;
        this.samples = new long[numSamples];
        this.periodMillis = periodMillis;
    }

    long elapsedTime(long start, long end) {
        if (end > start) {
            return end - start;
        }
        return Long.MAX_VALUE - start + 1L + (end - Long.MIN_VALUE);
    }

    long sampleGranularity() {
        long end;
        long start = this.env.nanoTime();
        while ((end = this.env.nanoTime()) == start) {
        }
        return this.elapsedTime(start, end);
    }

    public long getGranularity() {
        long curr;
        long now = this.env.currentTimeMillis();
        if (now - (curr = this.lastSampleTime.get()) > this.periodMillis && this.lastSampleTime.compareAndSet(curr, now)) {
            this.samples[this.sampleIndex] = this.sampleGranularity();
            this.sampleIndex = (this.sampleIndex + 1) % this.samples.length;
            long max = 0L;
            for (long sample : this.samples) {
                if (sample <= max) continue;
                max = sample;
            }
            this.maxGranularity = max;
        }
        return this.maxGranularity;
    }

    public DiscreteInterval getNanoTime() {
        long granularity = this.getGranularity();
        long err = granularity / 2L;
        if (granularity % 2L == 1L) {
            ++err;
        }
        long now = this.env.nanoTime() + this.getOffset();
        return new DiscreteInterval(now - err, now + err);
    }

    private long getOffset() {
        if (this.offset != null) {
            return this.offset;
        }
        long now = this.env.nanoTime();
        this.offset = now < MIN_CLOCK_TIME ? MIN_CLOCK_TIME - now : now - MIN_CLOCK_TIME;
        return this.offset;
    }

    public static class DefaultEnv
    implements Env {
        public long nanoTime() {
            return System.nanoTime();
        }

        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }
    }

    public static interface Env {
        public long nanoTime();

        public long currentTimeMillis();
    }
}

