/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged;

import java.util.LinkedList;
import org.fishwife.jrugged.Clock;
import org.fishwife.jrugged.SystemClock;

public class WindowedEventCounter {
    private Clock clock = new SystemClock();
    private long windowMillis;
    private final LinkedList<Long> queue = new LinkedList();
    private int capacity;

    public WindowedEventCounter(int capacity, long windowMillis) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must be greater than 0");
        }
        if (windowMillis <= 0L) {
            throw new IllegalArgumentException("windowMillis must be greater than 0");
        }
        this.windowMillis = windowMillis;
        this.capacity = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark() {
        long currentTimeMillis = this.clock.currentTimeMillis();
        LinkedList<Long> linkedList = this.queue;
        synchronized (linkedList) {
            if (this.queue.size() == this.capacity) {
                this.queue.removeFirst();
            }
            this.queue.addLast(currentTimeMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int tally() {
        long currentTimeMillis = this.clock.currentTimeMillis();
        long removeTimesBeforeMillis = currentTimeMillis - this.windowMillis;
        LinkedList<Long> linkedList = this.queue;
        synchronized (linkedList) {
            while (!this.queue.isEmpty() && this.queue.peek() < removeTimesBeforeMillis) {
                this.queue.removeFirst();
            }
            return this.queue.size();
        }
    }

    public long getWindowMillis() {
        return this.windowMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCapacity(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must be greater than 0");
        }
        LinkedList<Long> linkedList = this.queue;
        synchronized (linkedList) {
            if (capacity < this.capacity) {
                while (this.queue.size() > capacity) {
                    this.queue.removeFirst();
                }
            }
        }
        this.capacity = capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowMillis(long windowMillis) {
        if (windowMillis <= 0L) {
            throw new IllegalArgumentException("windowMillis must be greater than 0");
        }
        LinkedList<Long> linkedList = this.queue;
        synchronized (linkedList) {
            this.windowMillis = windowMillis;
        }
    }

    protected void setClock(Clock clock) {
        this.clock = clock;
    }
}

