/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.eventservice.impl.operations;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.SpiDataSerializerHook;
import com.hazelcast.spi.impl.eventservice.impl.EventServiceImpl;
import com.hazelcast.spi.impl.eventservice.impl.EventServiceSegment;
import java.io.IOException;

public class DeregistrationOperation
extends Operation
implements AllowedDuringPassiveState,
IdentifiedDataSerializable {
    private String topic;
    private String id;

    public DeregistrationOperation() {
    }

    public DeregistrationOperation(String topic, String id) {
        this.topic = topic;
        this.id = id;
    }

    @Override
    public void run() throws Exception {
        EventServiceImpl eventService = (EventServiceImpl)this.getNodeEngine().getEventService();
        EventServiceSegment segment = eventService.getSegment(this.getServiceName(), false);
        if (segment != null) {
            segment.removeRegistration(this.topic, this.id);
        }
    }

    @Override
    public Object getResponse() {
        return true;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.topic);
        out.writeUTF(this.id);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.topic = in.readUTF();
        this.id = in.readUTF();
    }

    @Override
    public int getFactoryId() {
        return SpiDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 10;
    }
}

