/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.map.QueryResultSizeExceededException;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.map.impl.query.QueryResultRow;
import com.hazelcast.map.impl.query.Result;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.IterationType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class QueryResult
implements Result<QueryResult>,
IdentifiedDataSerializable,
Iterable<QueryResultRow> {
    private final Collection<QueryResultRow> rows = new LinkedList<QueryResultRow>();
    private Collection<Integer> partitionIds;
    private transient long resultLimit;
    private transient long resultSize;
    private IterationType iterationType;

    public QueryResult() {
        this.resultLimit = Long.MAX_VALUE;
    }

    public QueryResult(IterationType iterationType, long resultLimit) {
        this.resultLimit = resultLimit;
        this.iterationType = iterationType;
    }

    IterationType getIterationType() {
        return this.iterationType;
    }

    @Override
    public Iterator<QueryResultRow> iterator() {
        return this.rows.iterator();
    }

    public int size() {
        return this.rows.size();
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    long getResultLimit() {
        return this.resultLimit;
    }

    public void addRow(QueryResultRow row) {
        this.rows.add(row);
    }

    public void add(QueryableEntry entry, Projection projection, SerializationService serializationService) {
        if (++this.resultSize > this.resultLimit) {
            throw new QueryResultSizeExceededException();
        }
        Data key = null;
        Data value = null;
        switch (this.iterationType) {
            case KEY: {
                key = entry.getKeyData();
                break;
            }
            case VALUE: {
                value = this.getValueData(entry, projection, serializationService);
                break;
            }
            case ENTRY: {
                key = entry.getKeyData();
                value = entry.getValueData();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown iterationtype:" + (Object)((Object)this.iterationType));
            }
        }
        this.rows.add(new QueryResultRow(key, value));
    }

    private Data getValueData(QueryableEntry entry, Projection projection, SerializationService serializationService) {
        if (projection != null) {
            return serializationService.toData(projection.transform(entry));
        }
        return entry.getValueData();
    }

    @Override
    public Collection<Integer> getPartitionIds() {
        return this.partitionIds;
    }

    @Override
    public void combine(QueryResult result) {
        Collection<Integer> otherPartitionIds = result.getPartitionIds();
        if (otherPartitionIds == null) {
            return;
        }
        if (this.partitionIds == null) {
            this.partitionIds = new ArrayList<Integer>(otherPartitionIds.size());
        }
        this.partitionIds.addAll(otherPartitionIds);
        this.rows.addAll(result.getRows());
    }

    @Override
    public void onCombineFinished() {
    }

    @Override
    public void setPartitionIds(Collection<Integer> partitionIds) {
        this.partitionIds = new ArrayList<Integer>(partitionIds);
    }

    public Collection<QueryResultRow> getRows() {
        return this.rows;
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 10;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        int partitionSize = this.partitionIds == null ? 0 : this.partitionIds.size();
        out.writeInt(partitionSize);
        if (partitionSize > 0) {
            for (Integer partitionId : this.partitionIds) {
                out.writeInt(partitionId);
            }
        }
        out.writeByte(this.iterationType.getId());
        int resultSize = this.rows.size();
        out.writeInt(resultSize);
        if (resultSize > 0) {
            for (QueryResultRow row : this.rows) {
                row.writeData(out);
            }
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int partitionSize = in.readInt();
        if (partitionSize > 0) {
            this.partitionIds = new ArrayList<Integer>(partitionSize);
            for (int i = 0; i < partitionSize; ++i) {
                this.partitionIds.add(in.readInt());
            }
        }
        this.iterationType = IterationType.getById(in.readByte());
        int resultSize = in.readInt();
        if (resultSize > 0) {
            for (int i = 0; i < resultSize; ++i) {
                QueryResultRow row = new QueryResultRow();
                row.readData(in);
                this.rows.add(row);
            }
        }
    }
}

