/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.EvictionConfigReadOnly;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.internal.eviction.EvictionConfiguration;
import com.hazelcast.internal.eviction.EvictionPolicyComparator;
import com.hazelcast.internal.eviction.EvictionPolicyType;
import com.hazelcast.internal.eviction.EvictionStrategyType;
import com.hazelcast.internal.eviction.impl.EvictionConfigHelper;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.util.Preconditions;
import java.io.IOException;
import java.io.Serializable;

public class EvictionConfig
implements EvictionConfiguration,
DataSerializable,
Serializable {
    public static final int DEFAULT_MAX_ENTRY_COUNT = 10000;
    public static final MaxSizePolicy DEFAULT_MAX_SIZE_POLICY = MaxSizePolicy.ENTRY_COUNT;
    public static final EvictionPolicy DEFAULT_EVICTION_POLICY = EvictionPolicy.LRU;
    protected int size = 10000;
    protected MaxSizePolicy maxSizePolicy = DEFAULT_MAX_SIZE_POLICY;
    protected EvictionPolicy evictionPolicy = DEFAULT_EVICTION_POLICY;
    protected String comparatorClassName;
    protected EvictionPolicyComparator comparator;
    protected EvictionConfig readOnly;

    public EvictionConfig() {
    }

    public EvictionConfig(int size, MaxSizePolicy maxSizePolicy, EvictionPolicy evictionPolicy) {
        this.size = Preconditions.checkPositive(size, "Size must be positive number!");
        this.maxSizePolicy = Preconditions.checkNotNull(maxSizePolicy, "Max-Size policy cannot be null!");
        this.evictionPolicy = Preconditions.checkNotNull(evictionPolicy, "Eviction policy cannot be null!");
    }

    public EvictionConfig(int size, MaxSizePolicy maxSizePolicy, String comparatorClassName) {
        this.size = Preconditions.checkPositive(size, "Size must be positive number!");
        this.maxSizePolicy = Preconditions.checkNotNull(maxSizePolicy, "Max-Size policy cannot be null!");
        this.comparatorClassName = Preconditions.checkNotNull(comparatorClassName, "Comparator classname cannot be null!");
    }

    public EvictionConfig(int size, MaxSizePolicy maxSizePolicy, EvictionPolicyComparator comparator) {
        this.size = Preconditions.checkPositive(size, "Size must be positive number!");
        this.maxSizePolicy = Preconditions.checkNotNull(maxSizePolicy, "Max-Size policy cannot be null!");
        this.comparator = Preconditions.checkNotNull(comparator, "Comparator cannot be null!");
    }

    public EvictionConfig(EvictionConfig config) {
        this.size = Preconditions.checkPositive(config.size, "Size must be positive number!");
        this.maxSizePolicy = Preconditions.checkNotNull(config.maxSizePolicy, "Max-Size policy cannot be null!");
        if (config.evictionPolicy != null) {
            this.evictionPolicy = config.evictionPolicy;
        }
        if (config.comparatorClassName != null) {
            this.comparatorClassName = config.comparatorClassName;
        }
        if (config.comparator != null) {
            this.comparator = config.comparator;
        }
        EvictionConfigHelper.checkEvictionConfig(this.evictionPolicy, this.comparatorClassName, this.comparator);
    }

    public EvictionConfig getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new EvictionConfigReadOnly(this);
        }
        return this.readOnly;
    }

    public int getSize() {
        return this.size;
    }

    public EvictionConfig setSize(int size) {
        this.size = Preconditions.checkPositive(size, "Size must be positive number !");
        return this;
    }

    public MaxSizePolicy getMaximumSizePolicy() {
        return this.maxSizePolicy;
    }

    public EvictionConfig setMaximumSizePolicy(MaxSizePolicy maxSizePolicy) {
        this.maxSizePolicy = Preconditions.checkNotNull(maxSizePolicy, "Max-Size policy cannot be null !");
        return this;
    }

    public EvictionPolicy getEvictionPolicy() {
        return this.evictionPolicy;
    }

    public EvictionConfig setEvictionPolicy(EvictionPolicy evictionPolicy) {
        Preconditions.checkNotNull(evictionPolicy, "Eviction policy cannot be null !");
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    @Override
    public String getComparatorClassName() {
        return this.comparatorClassName;
    }

    public EvictionConfig setComparatorClassName(String comparatorClassName) {
        Preconditions.checkNotNull(comparatorClassName, "Eviction policy comparator class name cannot be null !");
        this.comparatorClassName = comparatorClassName;
        return this;
    }

    @Override
    public EvictionPolicyComparator getComparator() {
        return this.comparator;
    }

    public EvictionConfig setComparator(EvictionPolicyComparator comparator) {
        Preconditions.checkNotNull(comparator, "Eviction policy comparator cannot be null !");
        this.comparator = comparator;
        return this;
    }

    @Override
    public EvictionStrategyType getEvictionStrategyType() {
        return EvictionStrategyType.DEFAULT_EVICTION_STRATEGY;
    }

    @Override
    public EvictionPolicyType getEvictionPolicyType() {
        if (this.evictionPolicy == EvictionPolicy.LFU) {
            return EvictionPolicyType.LFU;
        }
        if (this.evictionPolicy == EvictionPolicy.LRU) {
            return EvictionPolicyType.LRU;
        }
        return null;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeUTF(this.maxSizePolicy.toString());
        out.writeUTF(this.evictionPolicy.toString());
        out.writeUTF(this.comparatorClassName);
        out.writeObject(this.comparator);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.size = in.readInt();
        this.maxSizePolicy = MaxSizePolicy.valueOf(in.readUTF());
        this.evictionPolicy = EvictionPolicy.valueOf(in.readUTF());
        this.comparatorClassName = in.readUTF();
        this.comparator = (EvictionPolicyComparator)in.readObject();
    }

    public String toString() {
        return "EvictionConfig{size=" + this.size + ", maxSizePolicy=" + (Object)((Object)this.maxSizePolicy) + ", evictionPolicy=" + (Object)((Object)this.evictionPolicy) + ", comparatorClassName=" + this.comparatorClassName + ", comparator=" + this.comparator + ", readOnly=" + this.readOnly + '}';
    }

    public static enum MaxSizePolicy {
        ENTRY_COUNT,
        USED_NATIVE_MEMORY_SIZE,
        USED_NATIVE_MEMORY_PERCENTAGE,
        FREE_NATIVE_MEMORY_SIZE,
        FREE_NATIVE_MEMORY_PERCENTAGE;

    }
}

