/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import COSE.CoseException;
import com.yubico.internal.util.CollectionUtil;
import com.yubico.internal.util.ExceptionUtil;
import com.yubico.webauthn.AssertionRequest;
import com.yubico.webauthn.AssertionResult;
import com.yubico.webauthn.CredentialRepository;
import com.yubico.webauthn.Crypto;
import com.yubico.webauthn.ExtensionsValidation;
import com.yubico.webauthn.OriginMatcher;
import com.yubico.webauthn.RegisteredCredential;
import com.yubico.webauthn.TokenBindingValidator;
import com.yubico.webauthn.WebAuthnCodecs;
import com.yubico.webauthn.data.AuthenticatorAssertionExtensionOutputs;
import com.yubico.webauthn.data.AuthenticatorAssertionResponse;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.COSEAlgorithmIdentifier;
import com.yubico.webauthn.data.ClientAssertionExtensionOutputs;
import com.yubico.webauthn.data.CollectedClientData;
import com.yubico.webauthn.data.PublicKeyCredential;
import com.yubico.webauthn.data.UserVerificationRequirement;
import com.yubico.webauthn.exception.InvalidSignatureCountException;
import com.yubico.webauthn.extension.appid.AppId;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FinishAssertionSteps {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FinishAssertionSteps.class);
    private static final String CLIENT_DATA_TYPE = "webauthn.get";
    private final AssertionRequest request;
    private final PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> response;
    private final Optional<ByteArray> callerTokenBindingId;
    private final Set<String> origins;
    private final String rpId;
    private final CredentialRepository credentialRepository;
    private final boolean allowOriginPort;
    private final boolean allowOriginSubdomain;
    private final boolean allowUnrequestedExtensions;
    private final boolean validateSignatureCounter;

    public Step0 begin() {
        return new Step0();
    }

    public AssertionResult run() throws InvalidSignatureCountException {
        return this.begin().run();
    }

    @Generated
    private static boolean $default$allowOriginPort() {
        return false;
    }

    @Generated
    private static boolean $default$allowOriginSubdomain() {
        return false;
    }

    @Generated
    private static boolean $default$allowUnrequestedExtensions() {
        return false;
    }

    @Generated
    private static boolean $default$validateSignatureCounter() {
        return true;
    }

    @Generated
    FinishAssertionSteps(AssertionRequest request, PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> response, Optional<ByteArray> callerTokenBindingId, Set<String> origins, String rpId, CredentialRepository credentialRepository, boolean allowOriginPort, boolean allowOriginSubdomain, boolean allowUnrequestedExtensions, boolean validateSignatureCounter) {
        this.request = request;
        this.response = response;
        this.callerTokenBindingId = callerTokenBindingId;
        this.origins = origins;
        this.rpId = rpId;
        this.credentialRepository = credentialRepository;
        this.allowOriginPort = allowOriginPort;
        this.allowOriginSubdomain = allowOriginSubdomain;
        this.allowUnrequestedExtensions = allowUnrequestedExtensions;
        this.validateSignatureCounter = validateSignatureCounter;
    }

    @Generated
    public static FinishAssertionStepsBuilder builder() {
        return new FinishAssertionStepsBuilder();
    }

    @Generated
    public static class FinishAssertionStepsBuilder {
        @Generated
        private AssertionRequest request;
        @Generated
        private PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> response;
        @Generated
        private Optional<ByteArray> callerTokenBindingId;
        @Generated
        private Set<String> origins;
        @Generated
        private String rpId;
        @Generated
        private CredentialRepository credentialRepository;
        @Generated
        private boolean allowOriginPort$set;
        @Generated
        private boolean allowOriginPort$value;
        @Generated
        private boolean allowOriginSubdomain$set;
        @Generated
        private boolean allowOriginSubdomain$value;
        @Generated
        private boolean allowUnrequestedExtensions$set;
        @Generated
        private boolean allowUnrequestedExtensions$value;
        @Generated
        private boolean validateSignatureCounter$set;
        @Generated
        private boolean validateSignatureCounter$value;

        @Generated
        FinishAssertionStepsBuilder() {
        }

        @Generated
        public FinishAssertionStepsBuilder request(AssertionRequest request) {
            this.request = request;
            return this;
        }

        @Generated
        public FinishAssertionStepsBuilder response(PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> response) {
            this.response = response;
            return this;
        }

        @Generated
        public FinishAssertionStepsBuilder callerTokenBindingId(Optional<ByteArray> callerTokenBindingId) {
            this.callerTokenBindingId = callerTokenBindingId;
            return this;
        }

        @Generated
        public FinishAssertionStepsBuilder origins(Set<String> origins) {
            this.origins = origins;
            return this;
        }

        @Generated
        public FinishAssertionStepsBuilder rpId(String rpId) {
            this.rpId = rpId;
            return this;
        }

        @Generated
        public FinishAssertionStepsBuilder credentialRepository(CredentialRepository credentialRepository) {
            this.credentialRepository = credentialRepository;
            return this;
        }

        @Generated
        public FinishAssertionStepsBuilder allowOriginPort(boolean allowOriginPort) {
            this.allowOriginPort$value = allowOriginPort;
            this.allowOriginPort$set = true;
            return this;
        }

        @Generated
        public FinishAssertionStepsBuilder allowOriginSubdomain(boolean allowOriginSubdomain) {
            this.allowOriginSubdomain$value = allowOriginSubdomain;
            this.allowOriginSubdomain$set = true;
            return this;
        }

        @Generated
        public FinishAssertionStepsBuilder allowUnrequestedExtensions(boolean allowUnrequestedExtensions) {
            this.allowUnrequestedExtensions$value = allowUnrequestedExtensions;
            this.allowUnrequestedExtensions$set = true;
            return this;
        }

        @Generated
        public FinishAssertionStepsBuilder validateSignatureCounter(boolean validateSignatureCounter) {
            this.validateSignatureCounter$value = validateSignatureCounter;
            this.validateSignatureCounter$set = true;
            return this;
        }

        @Generated
        public FinishAssertionSteps build() {
            boolean allowOriginPort$value = this.allowOriginPort$value;
            if (!this.allowOriginPort$set) {
                allowOriginPort$value = FinishAssertionSteps.$default$allowOriginPort();
            }
            boolean allowOriginSubdomain$value = this.allowOriginSubdomain$value;
            if (!this.allowOriginSubdomain$set) {
                allowOriginSubdomain$value = FinishAssertionSteps.$default$allowOriginSubdomain();
            }
            boolean allowUnrequestedExtensions$value = this.allowUnrequestedExtensions$value;
            if (!this.allowUnrequestedExtensions$set) {
                allowUnrequestedExtensions$value = FinishAssertionSteps.$default$allowUnrequestedExtensions();
            }
            boolean validateSignatureCounter$value = this.validateSignatureCounter$value;
            if (!this.validateSignatureCounter$set) {
                validateSignatureCounter$value = FinishAssertionSteps.$default$validateSignatureCounter();
            }
            return new FinishAssertionSteps(this.request, this.response, this.callerTokenBindingId, this.origins, this.rpId, this.credentialRepository, allowOriginPort$value, allowOriginSubdomain$value, allowUnrequestedExtensions$value, validateSignatureCounter$value);
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.FinishAssertionStepsBuilder(request=" + this.request + ", response=" + this.response + ", callerTokenBindingId=" + this.callerTokenBindingId + ", origins=" + this.origins + ", rpId=" + this.rpId + ", credentialRepository=" + this.credentialRepository + ", allowOriginPort$value=" + this.allowOriginPort$value + ", allowOriginSubdomain$value=" + this.allowOriginSubdomain$value + ", allowUnrequestedExtensions$value=" + this.allowUnrequestedExtensions$value + ", validateSignatureCounter$value=" + this.validateSignatureCounter$value + ")";
        }
    }

    final class Finished
    implements Step<Finished> {
        private final String username;
        private final ByteArray userHandle;
        private final long assertionSignatureCount;
        private final boolean signatureCounterValid;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
        }

        @Override
        public Finished nextStep() {
            return this;
        }

        @Override
        public Optional<AssertionResult> result() {
            return Optional.of(AssertionResult.builder().success(true).credentialId(FinishAssertionSteps.this.response.getId()).userHandle(this.userHandle).username(this.username).signatureCount(this.assertionSignatureCount).signatureCounterValid(this.signatureCounterValid).clientExtensionOutputs((ClientAssertionExtensionOutputs)FinishAssertionSteps.this.response.getClientExtensionResults()).assertionExtensionOutputs(AuthenticatorAssertionExtensionOutputs.fromAuthenticatorData(((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getParsedAuthenticatorData()).orElse(null)).warnings(this.allWarnings()).build());
        }

        @Generated
        public Finished(String username, ByteArray userHandle, long assertionSignatureCount, boolean signatureCounterValid, List<String> prevWarnings) {
            this.username = username;
            this.userHandle = userHandle;
            this.assertionSignatureCount = assertionSignatureCount;
            this.signatureCounterValid = signatureCounterValid;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public ByteArray getUserHandle() {
            return this.userHandle;
        }

        @Generated
        public long getAssertionSignatureCount() {
            return this.assertionSignatureCount;
        }

        @Generated
        public boolean isSignatureCounterValid() {
            return this.signatureCounterValid;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Finished)) {
                return false;
            }
            Finished other = (Finished)o;
            if (this.getAssertionSignatureCount() != other.getAssertionSignatureCount()) {
                return false;
            }
            if (this.isSignatureCounterValid() != other.isSignatureCounterValid()) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            ByteArray this$userHandle = this.getUserHandle();
            ByteArray other$userHandle = other.getUserHandle();
            if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $assertionSignatureCount = this.getAssertionSignatureCount();
            result = result * 59 + (int)($assertionSignatureCount >>> 32 ^ $assertionSignatureCount);
            result = result * 59 + (this.isSignatureCounterValid() ? 79 : 97);
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            ByteArray $userHandle = this.getUserHandle();
            result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Finished(username=" + this.getUsername() + ", userHandle=" + this.getUserHandle() + ", assertionSignatureCount=" + this.getAssertionSignatureCount() + ", signatureCounterValid=" + this.isSignatureCounterValid() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step17
    implements Step<Finished> {
        private final String username;
        private final ByteArray userHandle;
        private final RegisteredCredential credential;
        private final List<String> prevWarnings;
        private final long storedSignatureCountBefore;

        public Step17(String username, ByteArray userHandle, RegisteredCredential credential, List<String> prevWarnings) {
            this.username = username;
            this.userHandle = userHandle;
            this.credential = credential;
            this.prevWarnings = prevWarnings;
            this.storedSignatureCountBefore = credential.getSignatureCount();
        }

        @Override
        public void validate() throws InvalidSignatureCountException {
            if (FinishAssertionSteps.this.validateSignatureCounter && !this.signatureCounterValid()) {
                throw new InvalidSignatureCountException(FinishAssertionSteps.this.response.getId(), this.storedSignatureCountBefore + 1L, this.assertionSignatureCount());
            }
        }

        private boolean signatureCounterValid() {
            return this.assertionSignatureCount() == 0L && this.storedSignatureCountBefore == 0L || this.assertionSignatureCount() > this.storedSignatureCountBefore;
        }

        @Override
        public Finished nextStep() {
            return new Finished(this.username, this.userHandle, this.assertionSignatureCount(), this.signatureCounterValid(), this.allWarnings());
        }

        private long assertionSignatureCount() {
            return ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getParsedAuthenticatorData().getSignatureCounter();
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public ByteArray getUserHandle() {
            return this.userHandle;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public long getStoredSignatureCountBefore() {
            return this.storedSignatureCountBefore;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step17)) {
                return false;
            }
            Step17 other = (Step17)o;
            if (this.getStoredSignatureCountBefore() != other.getStoredSignatureCountBefore()) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            ByteArray this$userHandle = this.getUserHandle();
            ByteArray other$userHandle = other.getUserHandle();
            if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $storedSignatureCountBefore = this.getStoredSignatureCountBefore();
            result = result * 59 + (int)($storedSignatureCountBefore >>> 32 ^ $storedSignatureCountBefore);
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            ByteArray $userHandle = this.getUserHandle();
            result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step17(username=" + this.getUsername() + ", userHandle=" + this.getUserHandle() + ", credential=" + this.getCredential() + ", prevWarnings=" + this.getPrevWarnings() + ", storedSignatureCountBefore=" + this.getStoredSignatureCountBefore() + ")";
        }
    }

    final class Step16
    implements Step<Step17> {
        private final String username;
        private final ByteArray userHandle;
        private final RegisteredCredential credential;
        private final ByteArray clientDataJsonHash;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
            PublicKey key;
            ByteArray cose = this.credential.getPublicKeyCose();
            try {
                key = WebAuthnCodecs.importCosePublicKey(cose);
            }
            catch (CoseException | IOException | InvalidKeySpecException e) {
                throw new IllegalArgumentException(String.format("Failed to decode public key: Credential ID: %s COSE: %s", this.credential.getCredentialId().getBase64Url(), cose.getBase64Url()), e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            COSEAlgorithmIdentifier alg = WebAuthnCodecs.getCoseKeyAlg(cose).orElseThrow(() -> new IllegalArgumentException(String.format("Failed to decode \"alg\" from COSE key: %s", cose)));
            if (!Crypto.verifySignature(key, this.signedBytes(), ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getSignature(), alg)) {
                throw new IllegalArgumentException("Invalid assertion signature.");
            }
        }

        @Override
        public Step17 nextStep() {
            return new Step17(this.username, this.userHandle, this.credential, this.allWarnings());
        }

        public ByteArray signedBytes() {
            return ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getAuthenticatorData().concat(this.clientDataJsonHash);
        }

        @Generated
        public Step16(String username, ByteArray userHandle, RegisteredCredential credential, ByteArray clientDataJsonHash, List<String> prevWarnings) {
            this.username = username;
            this.userHandle = userHandle;
            this.credential = credential;
            this.clientDataJsonHash = clientDataJsonHash;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public ByteArray getUserHandle() {
            return this.userHandle;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Generated
        public ByteArray getClientDataJsonHash() {
            return this.clientDataJsonHash;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step16)) {
                return false;
            }
            Step16 other = (Step16)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            ByteArray this$userHandle = this.getUserHandle();
            ByteArray other$userHandle = other.getUserHandle();
            if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
                return false;
            }
            ByteArray this$clientDataJsonHash = this.getClientDataJsonHash();
            ByteArray other$clientDataJsonHash = other.getClientDataJsonHash();
            if (this$clientDataJsonHash == null ? other$clientDataJsonHash != null : !((Object)this$clientDataJsonHash).equals(other$clientDataJsonHash)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            ByteArray $userHandle = this.getUserHandle();
            result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            ByteArray $clientDataJsonHash = this.getClientDataJsonHash();
            result = result * 59 + ($clientDataJsonHash == null ? 43 : ((Object)$clientDataJsonHash).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step16(username=" + this.getUsername() + ", userHandle=" + this.getUserHandle() + ", credential=" + this.getCredential() + ", clientDataJsonHash=" + this.getClientDataJsonHash() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step15
    implements Step<Step16> {
        private final String username;
        private final ByteArray userHandle;
        private final RegisteredCredential credential;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
            ExceptionUtil.assure((this.clientDataJsonHash().size() == 32 ? 1 : 0) != 0, (String)"Failed to compute hash of client data", (Object[])new Object[0]);
        }

        @Override
        public Step16 nextStep() {
            return new Step16(this.username, this.userHandle, this.credential, this.clientDataJsonHash(), this.allWarnings());
        }

        public ByteArray clientDataJsonHash() {
            return Crypto.sha256(((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getClientDataJSON());
        }

        @Generated
        public Step15(String username, ByteArray userHandle, RegisteredCredential credential, List<String> prevWarnings) {
            this.username = username;
            this.userHandle = userHandle;
            this.credential = credential;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public ByteArray getUserHandle() {
            return this.userHandle;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step15)) {
                return false;
            }
            Step15 other = (Step15)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            ByteArray this$userHandle = this.getUserHandle();
            ByteArray other$userHandle = other.getUserHandle();
            if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            ByteArray $userHandle = this.getUserHandle();
            result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step15(username=" + this.getUsername() + ", userHandle=" + this.getUserHandle() + ", credential=" + this.getCredential() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step14
    implements Step<Step15> {
        private final String username;
        private final ByteArray userHandle;
        private final RegisteredCredential credential;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
            if (!FinishAssertionSteps.this.allowUnrequestedExtensions) {
                ExtensionsValidation.validate(FinishAssertionSteps.this.request.getPublicKeyCredentialRequestOptions().getExtensions(), FinishAssertionSteps.this.response);
            }
        }

        @Override
        public List<String> getWarnings() {
            try {
                ExtensionsValidation.validate(FinishAssertionSteps.this.request.getPublicKeyCredentialRequestOptions().getExtensions(), FinishAssertionSteps.this.response);
                return Collections.emptyList();
            }
            catch (Exception e) {
                return CollectionUtil.immutableList(Collections.singletonList(e.getMessage()));
            }
        }

        @Override
        public Step15 nextStep() {
            return new Step15(this.username, this.userHandle, this.credential, this.allWarnings());
        }

        @Generated
        public Step14(String username, ByteArray userHandle, RegisteredCredential credential, List<String> prevWarnings) {
            this.username = username;
            this.userHandle = userHandle;
            this.credential = credential;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public ByteArray getUserHandle() {
            return this.userHandle;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step14)) {
                return false;
            }
            Step14 other = (Step14)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            ByteArray this$userHandle = this.getUserHandle();
            ByteArray other$userHandle = other.getUserHandle();
            if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            ByteArray $userHandle = this.getUserHandle();
            result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step14(username=" + this.getUsername() + ", userHandle=" + this.getUserHandle() + ", credential=" + this.getCredential() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step13
    implements Step<Step14> {
        private final String username;
        private final ByteArray userHandle;
        private final RegisteredCredential credential;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
            if (FinishAssertionSteps.this.request.getPublicKeyCredentialRequestOptions().getUserVerification() == UserVerificationRequirement.REQUIRED) {
                ExceptionUtil.assure((boolean)((AuthenticatorAssertionResponse)((FinishAssertionSteps)FinishAssertionSteps.this).response.getResponse()).getParsedAuthenticatorData().getFlags().UV, (String)"User Verification is required.", (Object[])new Object[0]);
            }
        }

        @Override
        public Step14 nextStep() {
            return new Step14(this.username, this.userHandle, this.credential, this.allWarnings());
        }

        @Generated
        public Step13(String username, ByteArray userHandle, RegisteredCredential credential, List<String> prevWarnings) {
            this.username = username;
            this.userHandle = userHandle;
            this.credential = credential;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public ByteArray getUserHandle() {
            return this.userHandle;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step13)) {
                return false;
            }
            Step13 other = (Step13)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            ByteArray this$userHandle = this.getUserHandle();
            ByteArray other$userHandle = other.getUserHandle();
            if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            ByteArray $userHandle = this.getUserHandle();
            result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step13(username=" + this.getUsername() + ", userHandle=" + this.getUserHandle() + ", credential=" + this.getCredential() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step12
    implements Step<Step13> {
        private final String username;
        private final ByteArray userHandle;
        private final RegisteredCredential credential;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
            ExceptionUtil.assure((boolean)((AuthenticatorAssertionResponse)((FinishAssertionSteps)FinishAssertionSteps.this).response.getResponse()).getParsedAuthenticatorData().getFlags().UP, (String)"User Presence is required.", (Object[])new Object[0]);
        }

        @Override
        public Step13 nextStep() {
            return new Step13(this.username, this.userHandle, this.credential, this.allWarnings());
        }

        @Generated
        public Step12(String username, ByteArray userHandle, RegisteredCredential credential, List<String> prevWarnings) {
            this.username = username;
            this.userHandle = userHandle;
            this.credential = credential;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public ByteArray getUserHandle() {
            return this.userHandle;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step12)) {
                return false;
            }
            Step12 other = (Step12)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            ByteArray this$userHandle = this.getUserHandle();
            ByteArray other$userHandle = other.getUserHandle();
            if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            ByteArray $userHandle = this.getUserHandle();
            result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step12(username=" + this.getUsername() + ", userHandle=" + this.getUserHandle() + ", credential=" + this.getCredential() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step11
    implements Step<Step12> {
        private final String username;
        private final ByteArray userHandle;
        private final RegisteredCredential credential;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
            try {
                ExceptionUtil.assure((boolean)Crypto.sha256(FinishAssertionSteps.this.rpId).equals(((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getParsedAuthenticatorData().getRpIdHash()), (String)"Wrong RP ID hash.", (Object[])new Object[0]);
            }
            catch (IllegalArgumentException e) {
                Optional<AppId> appid = FinishAssertionSteps.this.request.getPublicKeyCredentialRequestOptions().getExtensions().getAppid();
                if (appid.isPresent()) {
                    ExceptionUtil.assure((boolean)Crypto.sha256(appid.get().getId()).equals(((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getParsedAuthenticatorData().getRpIdHash()), (String)"Wrong RP ID hash.", (Object[])new Object[0]);
                }
                throw e;
            }
        }

        @Override
        public Step12 nextStep() {
            return new Step12(this.username, this.userHandle, this.credential, this.allWarnings());
        }

        @Generated
        public Step11(String username, ByteArray userHandle, RegisteredCredential credential, List<String> prevWarnings) {
            this.username = username;
            this.userHandle = userHandle;
            this.credential = credential;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public ByteArray getUserHandle() {
            return this.userHandle;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step11)) {
                return false;
            }
            Step11 other = (Step11)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            ByteArray this$userHandle = this.getUserHandle();
            ByteArray other$userHandle = other.getUserHandle();
            if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            ByteArray $userHandle = this.getUserHandle();
            result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step11(username=" + this.getUsername() + ", userHandle=" + this.getUserHandle() + ", credential=" + this.getCredential() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step10
    implements Step<Step11> {
        private final String username;
        private final ByteArray userHandle;
        private final RegisteredCredential credential;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
            TokenBindingValidator.validate(((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getClientData().getTokenBinding(), FinishAssertionSteps.this.callerTokenBindingId);
        }

        @Override
        public Step11 nextStep() {
            return new Step11(this.username, this.userHandle, this.credential, this.allWarnings());
        }

        @Generated
        public Step10(String username, ByteArray userHandle, RegisteredCredential credential, List<String> prevWarnings) {
            this.username = username;
            this.userHandle = userHandle;
            this.credential = credential;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public ByteArray getUserHandle() {
            return this.userHandle;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step10)) {
                return false;
            }
            Step10 other = (Step10)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            ByteArray this$userHandle = this.getUserHandle();
            ByteArray other$userHandle = other.getUserHandle();
            if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            ByteArray $userHandle = this.getUserHandle();
            result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step10(username=" + this.getUsername() + ", userHandle=" + this.getUserHandle() + ", credential=" + this.getCredential() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step9
    implements Step<Step10> {
        private final String username;
        private final ByteArray userHandle;
        private final RegisteredCredential credential;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
            String responseOrigin = ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getClientData().getOrigin();
            ExceptionUtil.assure((boolean)OriginMatcher.isAllowed(responseOrigin, FinishAssertionSteps.this.origins, FinishAssertionSteps.this.allowOriginPort, FinishAssertionSteps.this.allowOriginSubdomain), (String)("Incorrect origin: " + responseOrigin), (Object[])new Object[0]);
        }

        @Override
        public Step10 nextStep() {
            return new Step10(this.username, this.userHandle, this.credential, this.allWarnings());
        }

        @Generated
        public Step9(String username, ByteArray userHandle, RegisteredCredential credential, List<String> prevWarnings) {
            this.username = username;
            this.userHandle = userHandle;
            this.credential = credential;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public ByteArray getUserHandle() {
            return this.userHandle;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step9)) {
                return false;
            }
            Step9 other = (Step9)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            ByteArray this$userHandle = this.getUserHandle();
            ByteArray other$userHandle = other.getUserHandle();
            if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            ByteArray $userHandle = this.getUserHandle();
            result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step9(username=" + this.getUsername() + ", userHandle=" + this.getUserHandle() + ", credential=" + this.getCredential() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step8
    implements Step<Step9> {
        private final String username;
        private final ByteArray userHandle;
        private final RegisteredCredential credential;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
            ExceptionUtil.assure((boolean)FinishAssertionSteps.this.request.getPublicKeyCredentialRequestOptions().getChallenge().equals(((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getClientData().getChallenge()), (String)"Incorrect challenge.", (Object[])new Object[0]);
        }

        @Override
        public Step9 nextStep() {
            return new Step9(this.username, this.userHandle, this.credential, this.allWarnings());
        }

        @Generated
        public Step8(String username, ByteArray userHandle, RegisteredCredential credential, List<String> prevWarnings) {
            this.username = username;
            this.userHandle = userHandle;
            this.credential = credential;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public ByteArray getUserHandle() {
            return this.userHandle;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step8)) {
                return false;
            }
            Step8 other = (Step8)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            ByteArray this$userHandle = this.getUserHandle();
            ByteArray other$userHandle = other.getUserHandle();
            if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            ByteArray $userHandle = this.getUserHandle();
            result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step8(username=" + this.getUsername() + ", userHandle=" + this.getUserHandle() + ", credential=" + this.getCredential() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step7
    implements Step<Step8> {
        private final String username;
        private final ByteArray userHandle;
        private final RegisteredCredential credential;
        private final CollectedClientData clientData;
        private final List<String> prevWarnings;
        private final List<String> warnings = new LinkedList<String>();

        @Override
        public List<String> getWarnings() {
            return CollectionUtil.immutableList(this.warnings);
        }

        @Override
        public void validate() {
            ExceptionUtil.assure((boolean)FinishAssertionSteps.CLIENT_DATA_TYPE.equals(this.clientData.getType()), (String)"The \"type\" in the client data must be exactly \"%s\", was: %s", (Object[])new Object[]{FinishAssertionSteps.CLIENT_DATA_TYPE, this.clientData.getType()});
        }

        @Override
        public Step8 nextStep() {
            return new Step8(this.username, this.userHandle, this.credential, this.allWarnings());
        }

        @Generated
        public Step7(String username, ByteArray userHandle, RegisteredCredential credential, CollectedClientData clientData, List<String> prevWarnings) {
            this.username = username;
            this.userHandle = userHandle;
            this.credential = credential;
            this.clientData = clientData;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public ByteArray getUserHandle() {
            return this.userHandle;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Generated
        public CollectedClientData getClientData() {
            return this.clientData;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step7)) {
                return false;
            }
            Step7 other = (Step7)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            ByteArray this$userHandle = this.getUserHandle();
            ByteArray other$userHandle = other.getUserHandle();
            if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
                return false;
            }
            CollectedClientData this$clientData = this.getClientData();
            CollectedClientData other$clientData = other.getClientData();
            if (this$clientData == null ? other$clientData != null : !((Object)this$clientData).equals(other$clientData)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            if (this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings)) {
                return false;
            }
            List<String> this$warnings = this.getWarnings();
            List<String> other$warnings = other.getWarnings();
            return !(this$warnings == null ? other$warnings != null : !((Object)this$warnings).equals(other$warnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            ByteArray $userHandle = this.getUserHandle();
            result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            CollectedClientData $clientData = this.getClientData();
            result = result * 59 + ($clientData == null ? 43 : ((Object)$clientData).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            List<String> $warnings = this.getWarnings();
            result = result * 59 + ($warnings == null ? 43 : ((Object)$warnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step7(username=" + this.getUsername() + ", userHandle=" + this.getUserHandle() + ", credential=" + this.getCredential() + ", clientData=" + this.getClientData() + ", prevWarnings=" + this.getPrevWarnings() + ", warnings=" + this.getWarnings() + ")";
        }
    }

    final class Step6
    implements Step<Step7> {
        private final String username;
        private final ByteArray userHandle;
        private final RegisteredCredential credential;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
            ExceptionUtil.assure((this.clientData() != null ? 1 : 0) != 0, (String)"Missing client data.", (Object[])new Object[0]);
        }

        @Override
        public Step7 nextStep() {
            return new Step7(this.username, this.userHandle, this.credential, this.clientData(), this.allWarnings());
        }

        public CollectedClientData clientData() {
            return ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getClientData();
        }

        @Generated
        public Step6(String username, ByteArray userHandle, RegisteredCredential credential, List<String> prevWarnings) {
            this.username = username;
            this.userHandle = userHandle;
            this.credential = credential;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public ByteArray getUserHandle() {
            return this.userHandle;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step6)) {
                return false;
            }
            Step6 other = (Step6)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            ByteArray this$userHandle = this.getUserHandle();
            ByteArray other$userHandle = other.getUserHandle();
            if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            ByteArray $userHandle = this.getUserHandle();
            result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step6(username=" + this.getUsername() + ", userHandle=" + this.getUserHandle() + ", credential=" + this.getCredential() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step5
    implements Step<Step6> {
        private final String username;
        private final ByteArray userHandle;
        private final RegisteredCredential credential;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
        }

        @Override
        public Step6 nextStep() {
            return new Step6(this.username, this.userHandle, this.credential, this.allWarnings());
        }

        @Generated
        public Step5(String username, ByteArray userHandle, RegisteredCredential credential, List<String> prevWarnings) {
            this.username = username;
            this.userHandle = userHandle;
            this.credential = credential;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public ByteArray getUserHandle() {
            return this.userHandle;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step5)) {
                return false;
            }
            Step5 other = (Step5)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            ByteArray this$userHandle = this.getUserHandle();
            ByteArray other$userHandle = other.getUserHandle();
            if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            ByteArray $userHandle = this.getUserHandle();
            result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step5(username=" + this.getUsername() + ", userHandle=" + this.getUserHandle() + ", credential=" + this.getCredential() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step4
    implements Step<Step5> {
        private final String username;
        private final ByteArray userHandle;
        private final RegisteredCredential credential;
        private final List<String> prevWarnings;

        @Override
        public void validate() {
            ExceptionUtil.assure((this.clientData() != null ? 1 : 0) != 0, (String)"Missing client data.", (Object[])new Object[0]);
            ExceptionUtil.assure((this.authenticatorData() != null ? 1 : 0) != 0, (String)"Missing authenticator data.", (Object[])new Object[0]);
            ExceptionUtil.assure((this.signature() != null ? 1 : 0) != 0, (String)"Missing signature.", (Object[])new Object[0]);
        }

        @Override
        public Step5 nextStep() {
            return new Step5(this.username, this.userHandle, this.credential, this.allWarnings());
        }

        public ByteArray authenticatorData() {
            return ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getAuthenticatorData();
        }

        public ByteArray clientData() {
            return ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getClientDataJSON();
        }

        public ByteArray signature() {
            return ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getSignature();
        }

        @Generated
        public Step4(String username, ByteArray userHandle, RegisteredCredential credential, List<String> prevWarnings) {
            this.username = username;
            this.userHandle = userHandle;
            this.credential = credential;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public ByteArray getUserHandle() {
            return this.userHandle;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step4)) {
                return false;
            }
            Step4 other = (Step4)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            ByteArray this$userHandle = this.getUserHandle();
            ByteArray other$userHandle = other.getUserHandle();
            if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            ByteArray $userHandle = this.getUserHandle();
            result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step4(username=" + this.getUsername() + ", userHandle=" + this.getUserHandle() + ", credential=" + this.getCredential() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step3
    implements Step<Step4> {
        private final String username;
        private final ByteArray userHandle;
        private final Optional<RegisteredCredential> credential;
        private final List<String> prevWarnings;

        @Override
        public Step4 nextStep() {
            return new Step4(this.username, this.userHandle, this.credential.get(), this.allWarnings());
        }

        @Override
        public void validate() {
            ExceptionUtil.assure((boolean)this.credential.isPresent(), (String)"Unknown credential. Credential ID: %s, user handle: %s", (Object[])new Object[]{FinishAssertionSteps.this.response.getId(), this.userHandle});
        }

        @Generated
        public Step3(String username, ByteArray userHandle, Optional<RegisteredCredential> credential, List<String> prevWarnings) {
            this.username = username;
            this.userHandle = userHandle;
            this.credential = credential;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public ByteArray getUserHandle() {
            return this.userHandle;
        }

        @Generated
        public Optional<RegisteredCredential> getCredential() {
            return this.credential;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step3)) {
                return false;
            }
            Step3 other = (Step3)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            ByteArray this$userHandle = this.getUserHandle();
            ByteArray other$userHandle = other.getUserHandle();
            if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
                return false;
            }
            Optional<RegisteredCredential> this$credential = this.getCredential();
            Optional<RegisteredCredential> other$credential = other.getCredential();
            if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            ByteArray $userHandle = this.getUserHandle();
            result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
            Optional<RegisteredCredential> $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step3(username=" + this.getUsername() + ", userHandle=" + this.getUserHandle() + ", credential=" + this.getCredential() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step2
    implements Step<Step3> {
        private final String username;
        private final ByteArray userHandle;
        private final List<String> prevWarnings;
        private final Optional<RegisteredCredential> registration;

        public Step2(String username, ByteArray userHandle, List<String> prevWarnings) {
            this.username = username;
            this.userHandle = userHandle;
            this.prevWarnings = prevWarnings;
            this.registration = FinishAssertionSteps.this.credentialRepository.lookup(FinishAssertionSteps.this.response.getId(), userHandle);
        }

        @Override
        public Step3 nextStep() {
            return new Step3(this.username, this.userHandle, this.registration, this.allWarnings());
        }

        @Override
        public void validate() {
            ExceptionUtil.assure((boolean)this.registration.isPresent(), (String)"Unknown credential: %s", (Object[])new Object[]{FinishAssertionSteps.this.response.getId()});
            ExceptionUtil.assure((boolean)this.userHandle.equals(this.registration.get().getUserHandle()), (String)"User handle %s does not own credential %s", (Object[])new Object[]{this.userHandle, FinishAssertionSteps.this.response.getId()});
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public ByteArray getUserHandle() {
            return this.userHandle;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public Optional<RegisteredCredential> getRegistration() {
            return this.registration;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step2)) {
                return false;
            }
            Step2 other = (Step2)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            ByteArray this$userHandle = this.getUserHandle();
            ByteArray other$userHandle = other.getUserHandle();
            if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            if (this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings)) {
                return false;
            }
            Optional<RegisteredCredential> this$registration = this.getRegistration();
            Optional<RegisteredCredential> other$registration = other.getRegistration();
            return !(this$registration == null ? other$registration != null : !((Object)this$registration).equals(other$registration));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            ByteArray $userHandle = this.getUserHandle();
            result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            Optional<RegisteredCredential> $registration = this.getRegistration();
            result = result * 59 + ($registration == null ? 43 : ((Object)$registration).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step2(username=" + this.getUsername() + ", userHandle=" + this.getUserHandle() + ", prevWarnings=" + this.getPrevWarnings() + ", registration=" + this.getRegistration() + ")";
        }
    }

    final class Step1
    implements Step<Step2> {
        private final String username;
        private final ByteArray userHandle;
        private final List<String> prevWarnings;

        @Override
        public Step2 nextStep() {
            return new Step2(this.username, this.userHandle, this.allWarnings());
        }

        @Override
        public void validate() {
            FinishAssertionSteps.this.request.getPublicKeyCredentialRequestOptions().getAllowCredentials().ifPresent(allowed -> ExceptionUtil.assure((boolean)allowed.stream().anyMatch(allow -> allow.getId().equals(FinishAssertionSteps.this.response.getId())), (String)"Unrequested credential ID: %s", (Object[])new Object[]{FinishAssertionSteps.this.response.getId()}));
        }

        @Generated
        public Step1(String username, ByteArray userHandle, List<String> prevWarnings) {
            this.username = username;
            this.userHandle = userHandle;
            this.prevWarnings = prevWarnings;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public ByteArray getUserHandle() {
            return this.userHandle;
        }

        @Override
        @Generated
        public List<String> getPrevWarnings() {
            return this.prevWarnings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step1)) {
                return false;
            }
            Step1 other = (Step1)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            ByteArray this$userHandle = this.getUserHandle();
            ByteArray other$userHandle = other.getUserHandle();
            if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
                return false;
            }
            List<String> this$prevWarnings = this.getPrevWarnings();
            List<String> other$prevWarnings = other.getPrevWarnings();
            return !(this$prevWarnings == null ? other$prevWarnings != null : !((Object)this$prevWarnings).equals(other$prevWarnings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            ByteArray $userHandle = this.getUserHandle();
            result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
            List<String> $prevWarnings = this.getPrevWarnings();
            result = result * 59 + ($prevWarnings == null ? 43 : ((Object)$prevWarnings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step1(username=" + this.getUsername() + ", userHandle=" + this.getUserHandle() + ", prevWarnings=" + this.getPrevWarnings() + ")";
        }
    }

    final class Step0
    implements Step<Step1> {
        private final Optional<ByteArray> userHandle;
        private final Optional<String> username;

        @Override
        public Step1 nextStep() {
            return new Step1(this.username.get(), this.userHandle.get(), this.allWarnings());
        }

        @Override
        public void validate() {
            ExceptionUtil.assure((FinishAssertionSteps.this.request.getUsername().isPresent() || ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getUserHandle().isPresent() ? 1 : 0) != 0, (String)"At least one of username and user handle must be given; none was.", (Object[])new Object[0]);
            ExceptionUtil.assure((boolean)this.userHandle.isPresent(), (String)"No user found for username: %s, userHandle: %s", (Object[])new Object[]{FinishAssertionSteps.this.request.getUsername(), ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getUserHandle()});
            ExceptionUtil.assure((boolean)this.username.isPresent(), (String)"No user found for username: %s, userHandle: %s", (Object[])new Object[]{FinishAssertionSteps.this.request.getUsername(), ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getUserHandle()});
        }

        @Override
        public List<String> getPrevWarnings() {
            return Collections.emptyList();
        }

        @Generated
        public Step0() {
            this.userHandle = ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getUserHandle().map(Optional::of).orElseGet(() -> FinishAssertionSteps.this.credentialRepository.getUserHandleForUsername(FinishAssertionSteps.this.request.getUsername().get()));
            this.username = FinishAssertionSteps.this.request.getUsername().map(Optional::of).orElseGet(() -> FinishAssertionSteps.this.credentialRepository.getUsernameForUserHandle(((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getUserHandle().get()));
        }

        @Generated
        public Optional<ByteArray> getUserHandle() {
            return this.userHandle;
        }

        @Generated
        public Optional<String> getUsername() {
            return this.username;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step0)) {
                return false;
            }
            Step0 other = (Step0)o;
            Optional<ByteArray> this$userHandle = this.getUserHandle();
            Optional<ByteArray> other$userHandle = other.getUserHandle();
            if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
                return false;
            }
            Optional<String> this$username = this.getUsername();
            Optional<String> other$username = other.getUsername();
            return !(this$username == null ? other$username != null : !((Object)this$username).equals(other$username));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<ByteArray> $userHandle = this.getUserHandle();
            result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
            Optional<String> $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step0(userHandle=" + this.getUserHandle() + ", username=" + this.getUsername() + ")";
        }
    }

    static interface Step<Next extends Step<?>> {
        public Next nextStep();

        public void validate() throws InvalidSignatureCountException;

        public List<String> getPrevWarnings();

        default public Optional<AssertionResult> result() {
            return Optional.empty();
        }

        default public List<String> getWarnings() {
            return Collections.emptyList();
        }

        default public List<String> allWarnings() {
            ArrayList<String> result = new ArrayList<String>(this.getPrevWarnings().size() + this.getWarnings().size());
            result.addAll(this.getPrevWarnings());
            result.addAll(this.getWarnings());
            return CollectionUtil.immutableList(result);
        }

        default public Next next() throws InvalidSignatureCountException {
            this.validate();
            return this.nextStep();
        }

        default public AssertionResult run() throws InvalidSignatureCountException {
            if (this.result().isPresent()) {
                return this.result().get();
            }
            return this.next().run();
        }
    }
}

