/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.nio.BufferObjectDataInput;
import com.hazelcast.internal.nio.BufferObjectDataOutput;
import com.hazelcast.internal.serialization.impl.compact.CompactStreamSerializer;
import com.hazelcast.internal.serialization.impl.compact.DefaultCompactReader;
import com.hazelcast.internal.serialization.impl.compact.DefaultCompactWriter;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.nio.serialization.GenericRecordBuilder;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class SerializingGenericRecordBuilder
implements GenericRecordBuilder {
    private final DefaultCompactWriter defaultCompactWriter;
    private final CompactStreamSerializer serializer;
    private final Schema schema;
    private final Function<byte[], BufferObjectDataInput> bufferObjectDataInputFunc;
    private final Set<String> writtenFields = new HashSet<String>();

    public SerializingGenericRecordBuilder(CompactStreamSerializer serializer, Schema schema, Function<byte[], BufferObjectDataInput> bufferObjectDataInputFunc, Supplier<BufferObjectDataOutput> bufferObjectDataOutputSupplier) {
        this.serializer = serializer;
        this.schema = schema;
        this.defaultCompactWriter = new DefaultCompactWriter(serializer, bufferObjectDataOutputSupplier.get(), schema, false);
        this.bufferObjectDataInputFunc = bufferObjectDataInputFunc;
    }

    @Override
    @Nonnull
    public GenericRecord build() {
        Set<String> fieldNames = this.schema.getFieldNames();
        for (String fieldName : fieldNames) {
            if (this.writtenFields.contains(fieldName)) continue;
            throw new HazelcastSerializationException("Found an unset field " + fieldName + ". All the fields must be set before build");
        }
        this.defaultCompactWriter.end();
        byte[] bytes = this.defaultCompactWriter.toByteArray();
        return new DefaultCompactReader(this.serializer, this.bufferObjectDataInputFunc.apply(bytes), this.schema, null, false);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setInt(@Nonnull String fieldName, int value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeInt(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setLong(@Nonnull String fieldName, long value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeLong(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setString(@Nonnull String fieldName, String value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeString(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setBoolean(@Nonnull String fieldName, boolean value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeBoolean(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setByte(@Nonnull String fieldName, byte value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeByte(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setChar(@Nonnull String fieldName, char value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeChar(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDouble(@Nonnull String fieldName, double value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeDouble(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setFloat(@Nonnull String fieldName, float value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeFloat(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setShort(@Nonnull String fieldName, short value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeShort(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDecimal(@Nonnull String fieldName, BigDecimal value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeDecimal(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTime(@Nonnull String fieldName, LocalTime value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeTime(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDate(@Nonnull String fieldName, LocalDate value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeDate(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimestamp(@Nonnull String fieldName, LocalDateTime value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeTimestamp(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimestampWithTimezone(@Nonnull String fieldName, OffsetDateTime value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeTimestampWithTimezone(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setGenericRecord(@Nonnull String fieldName, GenericRecord value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeGenericRecord(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setGenericRecordArray(@Nonnull String fieldName, GenericRecord[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeGenericRecordArray(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setByteArray(@Nonnull String fieldName, byte[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeByteArray(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setBooleanArray(@Nonnull String fieldName, boolean[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeBooleanArray(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setCharArray(@Nonnull String fieldName, char[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeCharArray(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setIntArray(@Nonnull String fieldName, int[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeIntArray(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setLongArray(@Nonnull String fieldName, long[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeLongArray(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDoubleArray(@Nonnull String fieldName, double[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeDoubleArray(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setFloatArray(@Nonnull String fieldName, float[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeFloatArray(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setShortArray(@Nonnull String fieldName, short[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeShortArray(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setStringArray(@Nonnull String fieldName, String[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeStringArray(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDecimalArray(@Nonnull String fieldName, BigDecimal[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeDecimalArray(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimeArray(@Nonnull String fieldName, LocalTime[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeTimeArray(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDateArray(@Nonnull String fieldName, LocalDate[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeDateArray(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimestampArray(@Nonnull String fieldName, LocalDateTime[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeTimestampArray(fieldName, value);
        return this;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimestampWithTimezoneArray(@Nonnull String fieldName, OffsetDateTime[] value) {
        this.checkIfAlreadyWritten(fieldName);
        this.defaultCompactWriter.writeTimestampWithTimezoneArray(fieldName, value);
        return this;
    }

    private void checkIfAlreadyWritten(@Nonnull String fieldName) {
        if (!this.writtenFields.add(fieldName)) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
    }
}

