/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordReaderWriter;
import com.hazelcast.query.impl.Metadata;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;

public abstract class AbstractRecord<V>
implements Record<V> {
    private static final int NUMBER_OF_LONGS = 1;
    private static final int NUMBER_OF_INTS = 6;
    protected int ttl;
    protected int maxIdle;
    protected long version;
    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="Record can be accessed by only its own partition thread.")
    protected volatile int hits;
    private volatile int lastAccessTime = -1;
    private volatile int lastUpdateTime = -1;
    private int creationTime = -1;
    private transient Metadata metadata;

    AbstractRecord() {
    }

    @Override
    public RecordReaderWriter getMatchingRecordReaderWriter() {
        return RecordReaderWriter.DATA_RECORD_READER_WRITER;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public final long getVersion() {
        return this.version;
    }

    @Override
    public final void setVersion(long version) {
        this.version = version;
    }

    @Override
    public long getLastAccessTime() {
        return this.recomputeWithBaseTime(this.lastAccessTime);
    }

    @Override
    public void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = this.stripBaseTime(lastAccessTime);
    }

    @Override
    public long getLastUpdateTime() {
        return this.recomputeWithBaseTime(this.lastUpdateTime);
    }

    @Override
    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = this.stripBaseTime(lastUpdateTime);
    }

    @Override
    public long getCreationTime() {
        return this.recomputeWithBaseTime(this.creationTime);
    }

    @Override
    public void setCreationTime(long creationTime) {
        this.creationTime = this.stripBaseTime(creationTime);
    }

    @Override
    public int getHits() {
        return this.hits;
    }

    @Override
    public void setHits(int hits) {
        this.hits = hits;
    }

    @Override
    public long getCost() {
        return 32L;
    }

    @Override
    public Object getCachedValueUnsafe() {
        return Record.NOT_CACHED;
    }

    @Override
    public boolean casCachedValue(Object expectedValue, Object newValue) {
        return true;
    }

    @Override
    public final long getSequence() {
        return -1L;
    }

    @Override
    public final void setSequence(long sequence) {
    }

    @Override
    public long getExpirationTime() {
        return -1L;
    }

    @Override
    public void setExpirationTime(long expirationTime) {
    }

    @Override
    public long getLastStoredTime() {
        return -1L;
    }

    @Override
    public void setLastStoredTime(long lastStoredTime) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractRecord that = (AbstractRecord)o;
        if (this.ttl != that.ttl) {
            return false;
        }
        if (this.maxIdle != that.maxIdle) {
            return false;
        }
        if (this.version != that.version) {
            return false;
        }
        if (this.hits != that.hits) {
            return false;
        }
        if (this.lastAccessTime != that.lastAccessTime) {
            return false;
        }
        if (this.lastUpdateTime != that.lastUpdateTime) {
            return false;
        }
        if (this.creationTime != that.creationTime) {
            return false;
        }
        return Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        int result = 31 * this.ttl + this.maxIdle;
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        result = 31 * result + this.hits;
        result = 31 * result + this.lastAccessTime;
        result = 31 * result + this.lastUpdateTime;
        result = 31 * result + this.creationTime;
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    @Override
    public int getRawTtl() {
        return this.ttl;
    }

    @Override
    public int getRawMaxIdle() {
        return this.maxIdle;
    }

    @Override
    public int getRawCreationTime() {
        return this.creationTime;
    }

    @Override
    public int getRawLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public int getRawLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public void setRawTtl(int ttl) {
        this.ttl = ttl;
    }

    @Override
    public void setRawMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    @Override
    public void setRawCreationTime(int creationTime) {
        this.creationTime = creationTime;
    }

    @Override
    public void setRawLastAccessTime(int lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    @Override
    public void setRawLastUpdateTime(int lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Override
    public int getRawLastStoredTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRawLastStoredTime(int time) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRawExpirationTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRawExpirationTime(int time) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "AbstractRecord{, ttl=" + this.ttl + ", maxIdle=" + this.maxIdle + ", version=" + this.version + ", hits=" + this.hits + ", lastAccessTime=" + this.lastAccessTime + ", lastUpdateTime=" + this.lastUpdateTime + ", creationTime=" + this.creationTime + ", metadata=" + this.metadata + '}';
    }
}

