/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.xml.jdom;

import java.io.IOException;
import java.io.InputStream;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import com.openexchange.osgi.annotation.SingletonService;

/**
 * @author Francisco Laguna <francisco.laguna@open-xchange.com>
 */
@SingletonService
public interface JDOMParser {

    /**
     * Parses given input stream to a jDOM document.
     *
     * @param is The input stream to parse
     * @return The parsed jDOM document
     * @throws JDOMException If a jDOM error occurs
     * @throws IOException If an I/O error occurs
     */
    public Document parse(InputStream is) throws JDOMException, IOException;
}

