/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.snippet.rdb;

import java.util.List;
import com.openexchange.exception.OXException;
import com.openexchange.quota.QuotaProvider;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Session;
import com.openexchange.snippet.SnippetManagement;
import com.openexchange.snippet.SnippetService;


/**
 * {@link RdbSnippetService}
 *
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 */
public final class RdbSnippetService implements SnippetService {

    private final ServiceLookup services;
    private final QuotaProvider quotaProvider;

    /**
     * Initializes a new {@link RdbSnippetService}.
     */
    public RdbSnippetService(QuotaProvider quotaProvider, ServiceLookup services) {
        super();
        this.services = services;
        this.quotaProvider = quotaProvider;
    }

    @Override
    public SnippetManagement getManagement(final Session session) throws OXException {
        return new RdbSnippetManagement(session, quotaProvider, services);
    }

    @Override
    public List<String> neededCapabilities() {
        return null;
    }

}
