/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mail.json.compose.internal;

import com.openexchange.exception.OXException;
import com.openexchange.mail.json.compose.ComposeHandler;
import com.openexchange.mail.json.compose.ComposeHandlerRegistry;
import com.openexchange.mail.json.compose.ComposeRequest;
import com.openexchange.mail.json.compose.abort.AbortComposeHandler;
import com.openexchange.osgi.ServiceListing;


/**
 * {@link ComposeHandlerRegistryImpl}
 *
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 * @since v7.8.2
 */
public class ComposeHandlerRegistryImpl implements ComposeHandlerRegistry {

    private final ServiceListing<ComposeHandler> handlers;

    /**
     * Initializes a new {@link ComposeHandlerRegistryImpl}.
     */
    public ComposeHandlerRegistryImpl(ServiceListing<ComposeHandler> handlers) {
        super();
        this.handlers = handlers;
    }

    @Override
    public ComposeHandler getComposeHandlerFor(ComposeRequest composeRequest) throws OXException {
        for (ComposeHandler handler : handlers.getServiceList()) {
            if (handler.applicableFor(composeRequest)) {
                return handler;
            }
        }

        // Return "default" handler
        return AbortComposeHandler.getInstance();
    }

}
