/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.contact.vcard.impl.internal;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * {@link VCardInputStream}
 *
 * @author <a href="mailto:tobias.friedrich@open-xchange.org">Tobias Friedrich</a>
 */
public class VCardInputStream extends FilterInputStream {

    private long currentSize;

    /**
     * Initializes a new {@link VCardInputStream}.
     *
     * @param delegate The underlying stream
     */
    public VCardInputStream(InputStream delegate) {
        super(delegate);
    }

    /**
     * Resets the current number of read bytes.
     *
     * @return The reader's current size, prior reseting
     */
    public long resetCurrentSize() {
        long size = this.currentSize;
        this.currentSize = 0;
        return size;
    }

    /**
     * Gets the current size of the input stream, i.e. the number of read bytes since last reset.
     *
     * @return The current size
     */
    public long getCurrentSize() {
        return currentSize;
    }

    @Override
    public int read() throws IOException {
        int r = in.read();
        if (r != -1) {
            currentSize++;
        }
        return r;
    }

    @Override
    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        int r = in.read(arg0, arg1, arg2);
        if (r > 0) {
            currentSize += r;
        }
        return r;
    }

    @Override
    public int read(byte[] arg0) throws IOException {
        return read(arg0, 0, arg0.length);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long arg0) throws IOException {
        return in.skip(arg0);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

}
