/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.api.client.common.calls.mapping;

import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.EntityInfo;
import com.openexchange.groupware.tools.mappings.json.DefaultJsonMapping;
import com.openexchange.session.Session;

/**
 * {@link EntityInfoMapping}
 *
 * @author <a href="mailto:tobias.friedrich@open-xchange.com">Tobias Friedrich</a>
 * @since v7.10.5
 */
public abstract class EntityInfoMapping<O> extends DefaultJsonMapping<EntityInfo, O> {

    /**
     * Initializes a new {@link EntityInfoMapping}.
     *
     * @param ajaxName The mapped ajax name
     * @param columnID the mapped column identifier
     */
    public EntityInfoMapping(String ajaxName, Integer columnID) {
        super(ajaxName, columnID);
    }

    @Override
    public void deserialize(JSONObject from, O to) throws JSONException, OXException {
        JSONObject jsonObject = from.optJSONObject(getAjaxName());
        set(to, null != jsonObject ? EntityInfo.parseJSON(jsonObject) : null);
    }

    @Override
    public Object serialize(O from, TimeZone timeZone, Session session) throws JSONException, OXException {
        EntityInfo value = get(from);
        return null != value ? value.toJSON() : null;
    }

}
