/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.jpeg;

import com.twelvemonkeys.imageio.plugins.jpeg.Segment;
import java.io.DataInput;
import java.io.IOException;
import javax.imageio.IIOException;

final class HuffmanTable
extends Segment {
    final int[][][] l = new int[4][2][16];
    final int[] th = new int[4];
    final int[][][][] v = new int[4][2][16][200];
    final int[][] tc = new int[4][2];
    public static final int MSB = Integer.MIN_VALUE;

    private HuffmanTable() {
        super(65476);
        this.tc[0][0] = 0;
        this.tc[1][0] = 0;
        this.tc[2][0] = 0;
        this.tc[3][0] = 0;
        this.tc[0][1] = 0;
        this.tc[1][1] = 0;
        this.tc[2][1] = 0;
        this.tc[3][1] = 0;
        this.th[0] = 0;
        this.th[1] = 0;
        this.th[2] = 0;
        this.th[3] = 0;
    }

    protected void buildHuffTables(int[][][] nArray) throws IOException {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 2; ++j) {
                if (this.tc[i][j] == 0) continue;
                this.buildHuffTable(nArray[i][j], this.l[i][j], this.v[i][j]);
            }
        }
    }

    private void buildHuffTable(int[] nArray, int[] nArray2, int[][] nArray3) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = 256;
        int n5 = 0;
        for (n3 = 0; n3 < 8; ++n3) {
            for (n2 = 0; n2 < nArray2[n3]; ++n2) {
                for (n = 0; n < n4 >> n3 + 1; ++n) {
                    nArray[n5] = nArray3[n3][n2] | n3 + 1 << 8;
                    ++n5;
                }
            }
        }
        n3 = 1;
        while (n5 < 256) {
            nArray[n5] = n3 | Integer.MIN_VALUE;
            ++n3;
            ++n5;
        }
        int n6 = 1;
        n5 = 0;
        for (n3 = 8; n3 < 16; ++n3) {
            for (n2 = 0; n2 < nArray2[n3]; ++n2) {
                for (n = 0; n < n4 >> n3 - 7; ++n) {
                    nArray[n6 * 256 + n5] = nArray3[n3][n2] | n3 + 1 << 8;
                    ++n5;
                }
                if (n5 < 256) continue;
                if (n5 > 256) {
                    throw new IIOException("JPEG Huffman Table error");
                }
                n5 = 0;
                ++n6;
            }
        }
    }

    public String toString() {
        return "DHT[]";
    }

    public static Segment read(DataInput dataInput, int n) throws IOException {
        int n2 = 2;
        HuffmanTable huffmanTable = new HuffmanTable();
        while (n2 < n) {
            int n3;
            int n4 = dataInput.readUnsignedByte();
            ++n2;
            int n5 = n4 & 0xF;
            if (n5 > 3) {
                throw new IIOException("Unexpected JPEG Huffman Table Id (> 3):" + n5);
            }
            int n6 = n4 >> 4;
            if (n6 > 2) {
                throw new IIOException("Unexpected JPEG Huffman Table class (> 2): " + n6);
            }
            huffmanTable.th[n5] = 1;
            huffmanTable.tc[n5][n6] = 1;
            for (n3 = 0; n3 < 16; ++n3) {
                huffmanTable.l[n5][n6][n3] = dataInput.readUnsignedByte();
                ++n2;
            }
            for (n3 = 0; n3 < 16; ++n3) {
                for (int i = 0; i < huffmanTable.l[n5][n6][n3]; ++i) {
                    if (n2 > n) {
                        throw new IIOException("JPEG Huffman Table format error");
                    }
                    huffmanTable.v[n5][n6][n3][i] = dataInput.readUnsignedByte();
                    ++n2;
                }
            }
        }
        if (n2 != n) {
            throw new IIOException("JPEG Huffman Table format error, bad segment length: " + n);
        }
        return huffmanTable;
    }
}

