/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util.impl;

import java.text.MessageFormat;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.impl.JSR47Logger_impl;
import org.apache.uima.util.impl.Log4jLogger_impl;
import org.apache.uima.util.impl.Logger_common_impl;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jLogger_impl
extends Logger_common_impl {
    public static final String DEFAULT_JUL = "uima.use_jul_as_default_uima_logger";
    public static final boolean IS_DEFAULT_JUL = Misc.getNoValueSystemProperty("uima.use_jul_as_default_uima_logger");
    static final boolean isJul;
    static final boolean isLog4j;
    private final org.slf4j.Logger logger;
    private final boolean isLocationCapable;

    private Slf4jLogger_impl(Class<?> component) {
        super(component);
        String loggerName = component != null ? component.getName() : "org.apache.uima";
        this.logger = LoggerFactory.getLogger((String)loggerName);
        this.isLocationCapable = this.logger instanceof LocationAwareLogger;
    }

    private Slf4jLogger_impl(Slf4jLogger_impl l, int limit) {
        super(l, limit);
        this.logger = l.logger;
        this.isLocationCapable = this.logger instanceof LocationAwareLogger;
    }

    public static synchronized Logger getInstance(Class<?> component) {
        if (isJul) {
            return JSR47Logger_impl.getInstance(component);
        }
        if (isLog4j) {
            return Log4jLogger_impl.getInstance(component);
        }
        return new Slf4jLogger_impl(component);
    }

    public static synchronized Logger getInstance() {
        return Slf4jLogger_impl.getInstance(null);
    }

    @Override
    public Slf4jLogger_impl getLimitedLogger(int aLimit) {
        if (aLimit == Integer.MAX_VALUE || aLimit == this.limit_common) {
            return this;
        }
        return new Slf4jLogger_impl(this, aLimit);
    }

    public static int getSlf4jLevel(Level level) {
        switch (level.toInteger()) {
            case 70000: {
                return 40;
            }
            case 60000: {
                return 30;
            }
            case 50000: {
                return 20;
            }
            case 40000: {
                return 20;
            }
            case 30000: {
                return 10;
            }
            case 20000: {
                return 0;
            }
            case 10000: {
                return 0;
            }
        }
        Misc.internalError();
        return 40;
    }

    @Override
    public boolean isLoggable(Level level) {
        switch (level.toInteger()) {
            case 0x7FFFFFFF: {
                return false;
            }
            case 70000: {
                return this.logger.isErrorEnabled();
            }
            case 60000: {
                return this.logger.isWarnEnabled();
            }
            case 50000: {
                return this.logger.isInfoEnabled();
            }
            case 40000: {
                return this.logger.isInfoEnabled(UIMA_MARKER_CONFIG);
            }
            case 30000: {
                return this.logger.isDebugEnabled();
            }
            case 20000: {
                return this.logger.isTraceEnabled();
            }
            case 10000: {
                return this.logger.isTraceEnabled(UIMA_MARKER_FINEST);
            }
        }
        return false;
    }

    @Override
    public boolean isLoggable(Level level, Marker marker) {
        switch (level.toInteger()) {
            case 0x7FFFFFFF: {
                return false;
            }
            case 70000: {
                return this.logger.isErrorEnabled(marker);
            }
            case 60000: {
                return this.logger.isWarnEnabled(marker);
            }
            case 50000: {
                return this.logger.isInfoEnabled(marker);
            }
            case 40000: {
                return this.logger.isInfoEnabled(marker);
            }
            case 30000: {
                return this.logger.isDebugEnabled(marker);
            }
            case 20000: {
                return this.logger.isTraceEnabled(marker);
            }
            case 10000: {
                return this.logger.isTraceEnabled(marker);
            }
        }
        return false;
    }

    @Override
    public void setLevel(Level level) {
    }

    @Override
    public void log(Marker m, String aFqcn, Level level, String message, Object[] args, Throwable thrown) {
        this.log(m, aFqcn, level, MessageFormat.format(message, args), thrown);
    }

    @Override
    public void log(Marker m, String aFqcn, Level level, String msg_with_params, Throwable thrown) {
        Marker marker = m = m == null ? Slf4jLogger_impl.getMarkerForLevel(level) : m;
        if (this.isLocationCapable) {
            ((LocationAwareLogger)this.logger).log(m, aFqcn, Slf4jLogger_impl.getSlf4jLevel(level), msg_with_params, null, thrown);
        } else {
            switch (level.toInteger()) {
                case 70000: {
                    this.logger.error(m, msg_with_params, thrown);
                    break;
                }
                case 60000: {
                    this.logger.warn(m, msg_with_params, thrown);
                    break;
                }
                case 50000: {
                    this.logger.info(m, msg_with_params, thrown);
                    break;
                }
                case 40000: {
                    this.logger.info(m, msg_with_params, thrown);
                    break;
                }
                case 30000: {
                    this.logger.debug(m, msg_with_params, thrown);
                    break;
                }
                case 20000: {
                    this.logger.trace(m, msg_with_params, thrown);
                    break;
                }
                case 10000: {
                    this.logger.trace(m, msg_with_params, thrown);
                    break;
                }
                default: {
                    Misc.internalError();
                }
            }
        }
    }

    @Override
    public void log2(Marker m, String aFqcn, Level level, String message, Object[] args, Throwable thrown) {
        Marker marker = m = m == null ? Slf4jLogger_impl.getMarkerForLevel(level) : m;
        if (this.isLocationCapable) {
            ((LocationAwareLogger)this.logger).log(m, aFqcn, Slf4jLogger_impl.getSlf4jLevel(level), message, args, thrown);
        } else {
            if (thrown != null) {
                Object[] args1;
                Object[] objectArray = args1 = args == null ? new Object[1] : new Object[args.length + 1];
                if (args != null) {
                    System.arraycopy(args, 0, args1, 0, args.length);
                }
                args1[args1.length - 1] = thrown;
                args = args1;
            }
            switch (level.toInteger()) {
                case 70000: {
                    this.logger.error(m, message, args);
                    break;
                }
                case 60000: {
                    this.logger.warn(m, message, args);
                    break;
                }
                case 50000: {
                    this.logger.info(m, message, args);
                    break;
                }
                case 40000: {
                    this.logger.info(m, message, args);
                    break;
                }
                case 30000: {
                    this.logger.debug(m, message, args);
                    break;
                }
                case 20000: {
                    this.logger.trace(m, message, args);
                    break;
                }
                case 10000: {
                    this.logger.trace(m, message, args);
                    break;
                }
                default: {
                    Misc.internalError();
                }
            }
        }
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isDebugEnabled(marker);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isInfoEnabled(marker);
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isWarnEnabled(marker);
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isErrorEnabled(marker);
    }

    static {
        Class<?> staticLoggerBinderClass = null;
        try {
            staticLoggerBinderClass = Class.forName("org.slf4j.impl.StaticLoggerBinder");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == staticLoggerBinderClass) {
            if (IS_DEFAULT_JUL) {
                isJul = true;
                isLog4j = false;
            } else {
                isJul = false;
                isLog4j = false;
            }
        } else {
            boolean tb;
            Class<?> clazz;
            org.slf4j.Logger tempLogger = LoggerFactory.getLogger((String)"org.apache.uima");
            try {
                clazz = Class.forName("org.slf4j.impl.JDK14LoggerAdapter");
                tb = clazz != null && clazz.isAssignableFrom(tempLogger.getClass());
            }
            catch (ClassNotFoundException e1) {
                tb = false;
            }
            isJul = tb;
            tb = false;
            if (!isJul) {
                try {
                    clazz = Class.forName("org.apache.logging.slf4j.Log4jLogger");
                    tb = null != clazz && clazz.isAssignableFrom(tempLogger.getClass());
                }
                catch (ClassNotFoundException e1) {
                    tb = false;
                }
            }
            isLog4j = tb;
        }
    }
}

