/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.Arrays;
import java.util.Map;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.impl.JCasHashMap;
import org.apache.uima.util.IteratorNvc;

public class Id2FS
implements Iterable<TOP> {
    static final boolean MEASURE = false;
    private static final int MEASURE_STACK_SIZE = 10;
    private static Map<MeasureCaller, MeasureCaller> callers = null;
    private static Map<MeasureCaller, MeasureCaller> walkableCallers = null;
    private final JCasHashMap id2fs;
    private final int initialSize;

    public Id2FS(int initialHeapSize) {
        this.initialSize = Math.max(32, initialHeapSize >> 4);
        this.id2fs = new JCasHashMap(this.initialSize);
    }

    void put(int id, TOP fs) {
        TOP prev = this.id2fs.put(id, fs);
        assert (prev == null);
    }

    void putUnconditionally(TOP fs) {
        this.id2fs.put(fs._id, fs);
    }

    void putChange(int id, TOP fs) {
        TOP prev = this.id2fs.put(id, fs);
        assert (prev != null);
    }

    void put(TOP fs) {
        this.put(fs._id, fs);
    }

    TOP get(int id) {
        return this.id2fs.get(id);
    }

    int size() {
        return this.id2fs.getApproximateSize();
    }

    void clear() {
        this.id2fs.clear();
    }

    void traceWeakGets() {
        this.trace(callers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trace(Map<MeasureCaller, MeasureCaller> map) {
        Map<MeasureCaller, MeasureCaller> map2 = map;
        synchronized (map2) {
            StackTraceElement[] e = Thread.currentThread().getStackTrace();
            MeasureCaller k = new MeasureCaller();
            int i = 3;
            for (int j = 0; i < e.length && j < 10; ++i, ++j) {
                k.className[j] = e[i].getClassName();
                k.methodName[j] = e[i].getMethodName();
                k.lineNumber[j] = e[i].getLineNumber();
            }
            MeasureCaller prev = map.putIfAbsent(k, k);
            if (null != prev) {
                ++prev.count;
            }
        }
    }

    private static void dumpCallers(String title, Map<MeasureCaller, MeasureCaller> map) {
        System.out.println(title + ": size:" + map.size());
        MeasureCaller[] a = map.keySet().toArray(new MeasureCaller[map.size()]);
        Arrays.sort(a, (c1, c2) -> -Integer.compare(c1.count, c2.count));
        for (MeasureCaller c : a) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 10 && c.className[i] != null; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(Misc.formatcaller(c.className[i], c.methodName[i], c.lineNumber[i]));
            }
            System.out.format("count: %,d, %s%n", c.count, sb);
        }
    }

    @Override
    public IteratorNvc<TOP> iterator() {
        return this.id2fs.iterator();
    }

    private static /* synthetic */ void lambda$static$1() {
        Id2FS.dumpCallers("Callers of getId with weak ref", callers);
        Id2FS.dumpCallers("Callers of walkReachablePlueFSsSorted", walkableCallers);
    }

    private static class MeasureCaller {
        int count = 1;
        String[] className = new String[10];
        String[] methodName = new String[10];
        int[] lineNumber = new int[10];

        private MeasureCaller() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.className);
            result = 31 * result + Arrays.hashCode(this.lineNumber);
            result = 31 * result + Arrays.hashCode(this.methodName);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MeasureCaller)) {
                return false;
            }
            MeasureCaller other = (MeasureCaller)obj;
            if (!Arrays.equals(this.className, other.className)) {
                return false;
            }
            if (!Arrays.equals(this.lineNumber, other.lineNumber)) {
                return false;
            }
            return Arrays.equals(this.methodName, other.methodName);
        }
    }
}

