/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.lang.invoke.MethodHandle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.IntConsumer;
import org.apache.uima.UIMA_IllegalStateException;
import org.apache.uima.UimaSerializableFSs;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.SofaFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.impl.SlotKinds;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeImpl_string;
import org.apache.uima.cas.impl.TypeImpl_stringSubtype;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.BooleanArray;
import org.apache.uima.jcas.cas.ByteArray;
import org.apache.uima.jcas.cas.DoubleArray;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.FloatArray;
import org.apache.uima.jcas.cas.IntegerArray;
import org.apache.uima.jcas.cas.LongArray;
import org.apache.uima.jcas.cas.ShortArray;
import org.apache.uima.jcas.cas.Sofa;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.impl.JCasImpl;

public class FeatureStructureImplC
implements FeatureStructureImpl {
    public static final String DISABLE_RUNTIME_FEATURE_VALIDATION = "uima.disable_runtime_feature_validation";
    public static final boolean IS_ENABLE_RUNTIME_FEATURE_VALIDATION = !Misc.getNoValueSystemProperty("uima.disable_runtime_feature_validation");
    public static final String DISABLE_RUNTIME_FEATURE_VALUE_VALIDATION = "uima.disable_runtime_feature_value_validation";
    public static final boolean IS_ENABLE_RUNTIME_FEATURE_VALUE_VALIDATION = !Misc.getNoValueSystemProperty("uima.disable_runtime_feature_value_validation");
    public static final String V2_PRETTY_PRINT = "uima.v2_pretty_print_format";
    public static final boolean IS_V2_PRETTY_PRINT = Misc.getNoValueSystemProperty("uima.v2_pretty_print_format");
    private static final boolean traceFSs = CASImpl.traceFSs;
    private static final int _BIT_IN_SET_SORTED_INDEX = 1;
    private static final int _BIT_PEAR_TRAMPOLINE = 2;
    private static final int _BIT_JCASHASHMAP_RESERVE = 4;
    private final int[] _intData;
    private final Object[] _refData;
    protected final int _id;
    private int _flags = 0;
    public final CASImpl _casView;
    private TypeImpl _typeImpl;

    public FeatureStructureImplC() {
        this._casView = null;
        this._typeImpl = null;
        this._intData = null;
        this._refData = null;
        this._id = 0;
    }

    protected FeatureStructureImplC(int id) {
        this._casView = null;
        this._typeImpl = null;
        this._intData = null;
        this._refData = null;
        this._id = id;
    }

    protected FeatureStructureImplC(TypeImpl type, CASImpl casView) {
        FeatureStructureImplC baseFs;
        this._casView = casView;
        this._typeImpl = type;
        this._id = casView.getNextFsId((TOP)this);
        if (this._casView.maybeMakeBaseVersionForPear(this, this._typeImpl)) {
            this._setPearTrampoline();
        }
        if (null != (baseFs = this._casView.pearBaseFs)) {
            this._intData = baseFs._intData;
            this._refData = baseFs._refData;
            this._casView.pearBaseFs = null;
        } else {
            this._intData = this._allocIntData();
            this._refData = this._allocRefData();
        }
        if (traceFSs && !(this instanceof CommonArrayFS)) {
            this._casView.traceFSCreate(this);
        }
        this._casView.maybeHoldOntoFS(this);
    }

    protected FeatureStructureImplC(JCasImpl jcasImpl) {
        FeatureStructureImplC baseFs;
        this._casView = jcasImpl.getCasImpl();
        this._typeImpl = this._casView.getTypeSystemImpl().getJCasRegisteredType(this.getTypeIndexID());
        this._id = this._casView.getNextFsId((TOP)this);
        if (null == this._typeImpl) {
            throw new CASRuntimeException("JCAS_TYPE_NOT_IN_CAS", this.getClass().getName());
        }
        if (this._casView.maybeMakeBaseVersionForPear(this, this._typeImpl)) {
            this._setPearTrampoline();
        }
        if (null != (baseFs = this._casView.pearBaseFs)) {
            this._intData = baseFs._intData;
            this._refData = baseFs._refData;
            this._casView.pearBaseFs = null;
        } else {
            this._intData = this._allocIntData();
            this._refData = this._allocRefData();
        }
        if (traceFSs && !(this instanceof CommonArrayFS)) {
            this._casView.traceFSCreate(this);
        }
        this._casView.maybeHoldOntoFS(this);
    }

    private int[] _allocIntData() {
        int c = this._typeImpl.nbrOfUsedIntDataSlots;
        if (c != 0) {
            return new int[c];
        }
        return null;
    }

    private Object[] _allocRefData() {
        int c = this._typeImpl.nbrOfUsedRefDataSlots;
        if (c != 0) {
            return new Object[c];
        }
        return null;
    }

    public void addToIndexes() {
        this._casView.addFsToIndexes(this);
    }

    public void addToIndexes(JCas jcas) {
        jcas.getCas().addFsToIndexes(this);
    }

    public void addToIndexes(CAS cas) {
        cas.addFsToIndexes(this);
    }

    public void removeFromIndexes() {
        this.removeFromIndexes(this._casView);
    }

    public void removeFromIndexes(CAS cas) {
        cas.removeFsFromIndexes(this);
    }

    public void removeFromIndexes(JCas jcas) {
        jcas.removeFsFromIndexes(this);
    }

    public LowLevelCAS getLowLevelCas() {
        return this._casView;
    }

    @Override
    public final int getAddress() {
        return this._casView.ll_getFSRef(this);
    }

    @Override
    public final int _id() {
        return this._id;
    }

    @Override
    public Type getType() {
        return this._typeImpl;
    }

    @Override
    public int _getTypeCode() {
        return this._typeImpl.getCode();
    }

    public CASImpl _getView() {
        return this._casView;
    }

    private void checkFeatRange(Feature feat, String shortRangeName) {
        if (!feat.getRange().getShortName().equals(shortRangeName)) {
            throw new CASRuntimeException("INAPPROP_RANGE", feat.getName(), "uima.cas." + shortRangeName, feat.getRange().getName());
        }
    }

    @Override
    public void setBooleanValue(Feature feat, boolean v) {
        this.checkFeatRange(feat, "Boolean");
        this._setIntValueCJ((FeatureImpl)feat, v ? 1 : 0);
    }

    public void _setBooleanValueNfc(int adjOffset, boolean v) {
        this._setIntValueNfcCJ(adjOffset, v ? 1 : 0);
    }

    public final void _setBooleanValueNcNj(FeatureImpl fi, boolean v) {
        this._setIntValueCommon(fi, v ? 1 : 0);
    }

    public final void _setBooleanValueNcNj(int adjOffset, boolean v) {
        this._setIntValueCommon(adjOffset, v ? 1 : 0);
    }

    @Override
    public void setByteValue(Feature feat, byte v) {
        this.checkFeatRange(feat, "Byte");
        this._setIntValueCJ((FeatureImpl)feat, v);
    }

    public void _setByteValueNfc(int adjOffset, byte v) {
        this._setIntValueNfcCJ(adjOffset, v);
    }

    public void _setByteValueNcNj(FeatureImpl fi, byte v) {
        this._setIntValueCommon(fi, (int)v);
    }

    public void _setByteValueNcNj(int adjOffset, byte v) {
        this._setIntValueCommon(adjOffset, (int)v);
    }

    @Override
    public void setShortValue(Feature feat, short v) {
        this.checkFeatRange(feat, "Short");
        this._setIntValueCJ((FeatureImpl)feat, v);
    }

    public void _setShortValueNfc(int adjOffset, short v) {
        this._setIntValueNfcCJ(adjOffset, v);
    }

    public void _setShortValueNcNj(FeatureImpl fi, short v) {
        this._setIntValueCommon(fi, (int)v);
    }

    public void _setShortValueNcNj(int adjOffset, short v) {
        this._setIntValueCommon(adjOffset, (int)v);
    }

    @Override
    public void setIntValue(Feature feat, int v) {
        this.checkFeatRange(feat, "Integer");
        this._setIntValueCJ((FeatureImpl)feat, v);
    }

    public void _setIntValueNfc(int adjOffset, int v) {
        this._setIntValueNfcCJ(adjOffset, v);
    }

    public void _setIntValueNcNj(FeatureImpl fi, int v) {
        this._setIntValueCommon(fi, v);
    }

    public void _setIntValueNcNj(int adjOffset, int v) {
        this._setIntValueCommon(adjOffset, v);
    }

    @Override
    public void setLongValue(Feature feat, long v) {
        this.checkFeatRange(feat, "Long");
        this._setLongValueCJ((FeatureImpl)feat, v);
    }

    public void _setLongValueNfc(int adjOffset, long v) {
        FeatureImpl fi = this._getFeatFromAdjOffset(adjOffset, true);
        this._casView.setLongValue(this, fi, v);
    }

    public void _setLongValueNcNj(FeatureImpl fi, long v) {
        this._setLongValueNcNj(fi.getAdjustedOffset(), v);
    }

    public void _setLongValueNcNj(int adjOffset, long v) {
        this._intData[adjOffset] = (int)v;
        this._intData[adjOffset + 1] = (int)(v >> 32);
        if (traceFSs) {
            this._casView.traceFSfeat(this, this._getFeatFromAdjOffset(adjOffset, true), v);
        }
    }

    @Override
    public void setFloatValue(Feature feat, float v) {
        this.checkFeatRange(feat, "Float");
        this._setIntValueCJ((FeatureImpl)feat, CASImpl.float2int(v));
    }

    protected void _setFloatValueNfc(int adjOffset, float v) {
        this._setIntValueNfc(adjOffset, CASImpl.float2int(v));
    }

    public void _setFloatValueNcNj(FeatureImpl fi, float v) {
        this._setIntValueCommon(fi, CASImpl.float2int(v));
    }

    public void _setFloatValueNcNj(int adjOffset, float v) {
        this._setIntValueCommon(adjOffset, CASImpl.float2int(v));
    }

    @Override
    public void setDoubleValue(Feature feat, double v) {
        this.checkFeatRange(feat, "Double");
        this._setLongValueCJ((FeatureImpl)feat, CASImpl.double2long(v));
    }

    protected void _setDoubleValueNfc(int adjOffset, double v) {
        this._setLongValueNfc(adjOffset, CASImpl.double2long(v));
    }

    public void _setDoubleValueNcNj(FeatureImpl fi, double v) {
        this._setLongValueNcNj(fi, CASImpl.double2long(v));
    }

    public void _setDoubleValueNcNj(int adjOffset, double v) {
        this._setLongValueNcNj(adjOffset, CASImpl.double2long(v));
    }

    @Override
    public void setStringValue(Feature feat, String v) {
        this.subStringRangeCheck(feat, v);
        this._setRefValueCJ((FeatureImpl)feat, v);
    }

    public void _setStringValueNfc(int adjOffset, String v) {
        FeatureImpl fi = this._getFeatFromAdjOffset(adjOffset, false);
        this.subStringRangeCheck(fi, v);
        this._setRefValueNfcCJ(fi, v);
    }

    public void _setStringValueNcNj(FeatureImpl fi, String v) {
        this.subStringRangeCheck(fi, v);
        this._setRefValueCommon(fi, (Object)v);
    }

    public void _setStringValueNcWj(int adjOffset, String v) {
        this._setRefValueCommonWj(this._getFeatFromAdjOffset(adjOffset, false), v);
    }

    @Override
    public void setFeatureValue(Feature feat, FeatureStructure v) {
        FeatureImpl fi = (FeatureImpl)feat;
        if (IS_ENABLE_RUNTIME_FEATURE_VALIDATION) {
            this.featureValidation(feat);
        }
        if (IS_ENABLE_RUNTIME_FEATURE_VALUE_VALIDATION) {
            this.featureValueValidation(feat, v);
        }
        this._setRefValueCommon(fi, (Object)this._maybeGetBaseForPearFs((TOP)v));
        this._casView.maybeLogUpdate(this, fi);
    }

    public void _setFeatureValueNcNj(FeatureImpl fi, Object v) {
        this._setRefValueCommon(fi, v);
    }

    public void _setFeatureValueNcNj(int adjOffset, Object v) {
        this._setRefValueCommon(adjOffset, v);
    }

    protected <N extends TOP> N _maybeGetBaseForPearFs(N v) {
        return v == null ? null : (N)v._maybeGetBaseForPearFs();
    }

    public <N extends TOP> N _maybeGetBaseForPearFs() {
        return (N)(this._isPearTrampoline() ? this._casView.getBaseFsFromTrampoline((TOP)this) : (TOP)this);
    }

    protected <N extends TOP> N _maybeGetPearFs(N v) {
        return this._casView.inPearContext() ? CASImpl.pearConvert(v) : v;
    }

    public <N extends TOP> N _maybeGetPearFs() {
        return (N)(this._casView.inPearContext() ? CASImpl.pearConvert((TOP)this) : (TOP)this);
    }

    public void _setFeatureValueNcWj(int adjOffset, FeatureStructure v) {
        this._setRefValueCommonWj(this._getFeatFromAdjOffset(adjOffset, false), this._maybeGetBaseForPearFs((TOP)v));
    }

    @Override
    public void setFeatureValueFromString(Feature feat, String s) throws CASRuntimeException {
        if (IS_ENABLE_RUNTIME_FEATURE_VALIDATION) {
            this.featureValidation(feat);
        }
        CASImpl.setFeatureValueFromString(this, (FeatureImpl)feat, s);
    }

    protected void _setIntValueCJ(FeatureImpl fi, int v) {
        if (!fi.isInInt) {
            throw new CASRuntimeException("INAPPROP_RANGE", fi.getName(), "boolean, byte, short, int, or float", fi.getRange().getName());
        }
        if (IS_ENABLE_RUNTIME_FEATURE_VALIDATION) {
            this.featureValidation(fi);
        }
        this._casView.setWithCheckAndJournal((TOP)this, fi.getCode(), () -> this._setIntValueCommon(fi, v));
    }

    protected void _setLongValueCJ(FeatureImpl fi, long v) {
        if (!fi.isInInt) {
            throw new CASRuntimeException("INAPPROP_RANGE", fi.getName(), "long or double", fi.getRange().getName());
        }
        if (IS_ENABLE_RUNTIME_FEATURE_VALIDATION) {
            this.featureValidation(fi);
        }
        this._casView.setLongValue(this, fi, v);
    }

    protected void _setIntValueNfcCJ(int adjOffset, int v) {
        FeatureImpl fi = this._getFeatFromAdjOffset(adjOffset, true);
        this._casView.setWithCheckAndJournal((TOP)this, fi, () -> this._setIntValueCommon(adjOffset, v));
    }

    protected void _setLongValueNfcCJ(FeatureImpl fi, long v) {
        this._casView.setLongValue(this, fi, v);
    }

    protected void _setRefValueCJ(FeatureImpl fi, Object v) {
        if (fi.isInInt) {
            throw new CASRuntimeException("INAPPROP_RANGE", fi.getName(), "int", fi.getRange().getName());
        }
        if (IS_ENABLE_RUNTIME_FEATURE_VALIDATION) {
            this.featureValidation(fi);
        }
        this._casView.setWithCheckAndJournal((TOP)this, fi.getCode(), () -> this._setRefValueCommon(fi, v));
    }

    protected void _setRefValueNfcCJ(FeatureImpl fi, Object v) {
        this._casView.setWithCheckAndJournal((TOP)this, fi.getCode(), () -> this._setRefValueCommon(fi, v));
    }

    @Override
    public boolean getBooleanValue(Feature feat) {
        if (IS_ENABLE_RUNTIME_FEATURE_VALIDATION) {
            this.featureValidation(feat);
        }
        this.checkFeatRange(feat, "Boolean");
        return this._getBooleanValueNc((FeatureImpl)feat);
    }

    public boolean _getBooleanValueNc(FeatureImpl fi) {
        return this._getIntValueCommon(fi) == 1;
    }

    public boolean _getBooleanValueNc(int adjOffset) {
        return this._getIntValueCommon(adjOffset) == 1;
    }

    @Override
    public byte getByteValue(Feature feat) {
        this.checkFeatRange(feat, "Byte");
        return (byte)this._getIntValueCommon((FeatureImpl)feat);
    }

    public byte _getByteValueNc(FeatureImpl feat) {
        return (byte)this._getIntValueNc(feat);
    }

    public byte _getByteValueNc(int adjOffset) {
        return (byte)this._getIntValueNc(adjOffset);
    }

    @Override
    public short getShortValue(Feature feat) {
        this.checkFeatRange(feat, "Short");
        return (short)this._getIntValueCommon((FeatureImpl)feat);
    }

    public short _getShortValueNc(FeatureImpl feat) {
        return (short)this._getIntValueNc(feat);
    }

    public short _getShortValueNc(int adjOffset) {
        return (short)this._getIntValueNc(adjOffset);
    }

    @Override
    public int getIntValue(Feature feat) {
        if (IS_ENABLE_RUNTIME_FEATURE_VALIDATION) {
            this.featureValidation(feat);
        }
        this.checkFeatRange(feat, "Integer");
        return this._getIntValueCommon((FeatureImpl)feat);
    }

    public int _getIntValueNc(FeatureImpl feat) {
        return this._getIntValueCommon(feat);
    }

    public int _getIntValueNc(int adjOffset) {
        return this._getIntValueCommon(adjOffset);
    }

    @Override
    public long getLongValue(Feature feat) {
        if (IS_ENABLE_RUNTIME_FEATURE_VALIDATION) {
            this.featureValidation(feat);
        }
        this.checkFeatRange(feat, "Long");
        return this._getLongValueNc((FeatureImpl)feat);
    }

    public long _getLongValueNc(FeatureImpl feat) {
        return this._getLongValueNc(feat.getAdjustedOffset());
    }

    public long _getLongValueNc(int adjOffset) {
        return (long)this._intData[adjOffset] & 0xFFFFFFFFL | (long)this._intData[adjOffset + 1] << 32;
    }

    @Override
    public float getFloatValue(Feature feat) {
        if (IS_ENABLE_RUNTIME_FEATURE_VALIDATION) {
            this.featureValidation(feat);
        }
        this.checkFeatRange(feat, "Float");
        return this._getFloatValueNc(((FeatureImpl)feat).getAdjustedOffset());
    }

    public float _getFloatValueNc(FeatureImpl fi) {
        return this._getFloatValueNc(fi.getAdjustedOffset());
    }

    public float _getFloatValueNc(int adjOffset) {
        return CASImpl.int2float(this._getIntValueCommon(adjOffset));
    }

    @Override
    public double getDoubleValue(Feature feat) {
        if (IS_ENABLE_RUNTIME_FEATURE_VALIDATION) {
            this.featureValidation(feat);
        }
        this.checkFeatRange(feat, "Double");
        return this._getDoubleValueNc((FeatureImpl)feat);
    }

    public double _getDoubleValueNc(FeatureImpl fi) {
        return this._getDoubleValueNc(fi.getAdjustedOffset());
    }

    public double _getDoubleValueNc(int adjOffset) {
        return CASImpl.long2double(this._getLongValueNc(adjOffset));
    }

    @Override
    public String getStringValue(Feature feat) {
        if (IS_ENABLE_RUNTIME_FEATURE_VALIDATION) {
            this.featureValidation(feat);
        }
        return this._getStringValueNc((FeatureImpl)feat);
    }

    public String _getStringValueNc(FeatureImpl feat) {
        return this._getStringValueNc(feat.getAdjustedOffset());
    }

    public String _getStringValueNc(int adjOffset) {
        return (String)this._refData[adjOffset];
    }

    @Override
    public TOP getFeatureValue(Feature feat) {
        if (IS_ENABLE_RUNTIME_FEATURE_VALIDATION) {
            this.featureValidation(feat);
        }
        return this._getFeatureValueNc((FeatureImpl)feat);
    }

    public TOP _getFeatureValueNc(FeatureImpl feat) {
        return this._getFeatureValueNc(feat.getAdjustedOffset());
    }

    public TOP _getFeatureValueNc(int adjOffset) {
        return this._maybeGetPearFs((TOP)this._refData[adjOffset]);
    }

    @Override
    public CAS getCAS() {
        return this._casView;
    }

    public CASImpl getCASImpl() {
        return this._casView;
    }

    @Override
    public FeatureStructureImplC clone() throws CASRuntimeException {
        if (this._typeImpl.isArray()) {
            CommonArrayFS original = (CommonArrayFS)((Object)this);
            CommonArrayFS copy = (CommonArrayFS)((Object)this._casView.createArray(this._typeImpl, original.size()));
            copy.copyValuesFrom(original);
            return (FeatureStructureImplC)((Object)copy);
        }
        TOP fs = (TOP)this._casView.createFS(this._typeImpl);
        TOP srcFs = (TOP)this;
        fs._copyIntAndRefArraysEqTypesFrom(srcFs);
        return fs;
    }

    @Override
    public int hashCode() {
        return this._id;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof FeatureStructureImplC) {
            FeatureStructureImplC c2 = (FeatureStructureImplC)obj;
            if (c2._id != this._id) {
                return false;
            }
            return this._casView == null && c2._casView == null || this._casView != null && c2._casView != null && (this._casView == c2._casView || this._casView.getBaseCAS() == c2._casView.getBaseCAS());
        }
        return false;
    }

    private final void getPrintRefs(PrintReferences printRefs) {
        this.getPrintRefs(printRefs, this);
    }

    private final void getPrintRefs(PrintReferences printRefs, FeatureStructureImplC fs) {
        if (null == fs) {
            return;
        }
        boolean seenBefore = printRefs.addReference(fs);
        if (seenBefore) {
            return;
        }
        TypeImpl ti = fs._typeImpl;
        if (ti != null) {
            if (!IS_V2_PRETTY_PRINT && ti.isArray() && fs instanceof FSArray) {
                for (TOP item : ((FSArray)fs)._getTheArray()) {
                    this.getPrintRefs(printRefs, item);
                }
            } else {
                if (fs instanceof UimaSerializableFSs) {
                    ((UimaSerializableFSs)((Object)fs))._save_fsRefs_to_cas_data();
                }
                ti.getFeaturesAsStream().filter(fi -> fi.getRangeImpl().isRefType).map(fi -> fs.getFeatureValue((Feature)fi)).filter(refFs -> refFs != null).forEachOrdered(refFs -> this.getPrintRefs(printRefs, (FeatureStructureImplC)refFs));
            }
        }
    }

    public String toString() {
        return this.toString(3);
    }

    @Override
    public String toString(int indent) {
        StringBuilder buf = new StringBuilder();
        this.prettyPrint(0, indent, buf, true, null);
        return buf.toString();
    }

    @Override
    public void prettyPrint(int indent, int incr, StringBuilder buf, boolean useShortNames) {
        this.prettyPrint(indent, incr, buf, useShortNames, null);
    }

    @Override
    public void prettyPrint(int indent, int incr, StringBuffer buf, boolean useShortNames) {
        this.prettyPrint(indent, incr, buf, useShortNames, null);
    }

    @Override
    @Deprecated
    public void prettyPrint(int indent, int incr, StringBuffer buf, boolean useShortNames, String s) {
        PrintReferences printRefs = new PrintReferences();
        this.getPrintRefs(printRefs);
        this.prettyPrint(indent, incr, buf, useShortNames, s, printRefs);
    }

    @Override
    public void prettyPrint(int indent, int incr, StringBuilder buf, boolean useShortNames, String s) {
        PrintReferences printRefs = new PrintReferences();
        this.getPrintRefs(printRefs);
        this.prettyPrint(indent, incr, buf, useShortNames, s, printRefs);
    }

    @Deprecated
    public void prettyPrint(int indent, int incr, StringBuffer buf, boolean useShortNames, String s, PrintReferences printRefs) {
        StringBuilder b2 = new StringBuilder(buf);
        this.prettyPrint(indent, incr, b2, useShortNames, s, printRefs);
        buf.setLength(0);
        buf.append(b2.toString());
    }

    public void prettyPrint(int indent, int incr, StringBuilder buf, boolean useShortNames, String s, PrintReferences printRefs) {
        this.prettyPrint(indent, incr, buf, useShortNames, s, printRefs, false);
    }

    public void prettyPrintShort(StringBuilder sb) {
        this.prettyPrint(0, 2, sb, true, "", new PrintReferences(), true);
    }

    private void prettyPrint(int indent, int incr, StringBuilder buf, boolean useShortNames, String s, PrintReferences printRefs, boolean isShortForm_arg) {
        boolean isShortForm = isShortForm_arg;
        try {
            TOP a;
            if (!IS_V2_PRETTY_PRINT && (indent += incr) > 20 * incr) {
                buf.append(" ... past indent limit ... ");
                return;
            }
            int printInfo = printRefs.printInfo(this);
            if (printInfo != 0) {
                String label = printRefs.getLabel(this);
                if (!label.equals("seen once")) {
                    buf.append(printRefs.getLabel(this));
                }
                if (printInfo == 2) {
                    buf.append(IS_V2_PRETTY_PRINT ? (char)' ' : '\n');
                    return;
                }
                buf.append(' ');
            }
            if (this._typeImpl == null) {
                buf.append(this._id == 0 ? " Special REMOVED marker " : (this._isJCasHashMapReserve() ? " Special JCasHashMap Reserve, id = " + this._id : " Special Search Key, id = " + this._id));
            } else {
                if (useShortNames) {
                    buf.append(this.getType().getShortName());
                } else {
                    buf.append(this.getType().getName());
                }
                if (!IS_V2_PRETTY_PRINT) {
                    buf.append(':').append(this._id);
                }
                if (s != null) {
                    buf.append(" \"" + s + "\"");
                }
            }
            buf.append('\n');
            if (this._typeImpl == null) {
                return;
            }
            switch (this._getTypeCode()) {
                case 9: {
                    a = (StringArray)this;
                    this.printArrayElements(a.size(), arg_0 -> this.lambda$prettyPrint$8(buf, (StringArray)a, arg_0), indent, incr, buf);
                    return;
                }
                case 8: {
                    a = (IntegerArray)this;
                    this.printArrayElements(((IntegerArray)a).size(), arg_0 -> this.lambda$prettyPrint$9(buf, (IntegerArray)a, arg_0), indent, incr, buf);
                    return;
                }
                case 7: {
                    a = (FloatArray)this;
                    this.printArrayElements(((FloatArray)a).size(), arg_0 -> this.lambda$prettyPrint$10(buf, (FloatArray)a, arg_0), indent, incr, buf);
                    return;
                }
                case 28: {
                    a = (BooleanArray)this;
                    this.printArrayElements(((BooleanArray)a).size(), arg_0 -> this.lambda$prettyPrint$11(buf, (BooleanArray)a, arg_0), indent, incr, buf);
                    return;
                }
                case 29: {
                    a = (ByteArray)this;
                    this.printArrayElements(((ByteArray)a).size(), arg_0 -> this.lambda$prettyPrint$12(buf, (ByteArray)a, arg_0), indent, incr, buf);
                    return;
                }
                case 30: {
                    a = (ShortArray)this;
                    this.printArrayElements(((ShortArray)a).size(), arg_0 -> this.lambda$prettyPrint$13(buf, (ShortArray)a, arg_0), indent, incr, buf);
                    return;
                }
                case 31: {
                    a = (LongArray)this;
                    this.printArrayElements(((LongArray)a).size(), arg_0 -> this.lambda$prettyPrint$14(buf, (LongArray)a, arg_0), indent, incr, buf);
                    return;
                }
                case 32: {
                    a = (DoubleArray)this;
                    this.printArrayElements(((DoubleArray)a).size(), arg_0 -> this.lambda$prettyPrint$15(buf, (DoubleArray)a, arg_0), indent, incr, buf);
                    return;
                }
                case 6: {
                    if (IS_V2_PRETTY_PRINT) break;
                    a = (FSArray)this;
                    this.printFSArrayElements((FSArray)a, indent, incr, buf, useShortNames, printRefs, isShortForm);
                    return;
                }
            }
            if (this instanceof FSArray) {
                if (IS_V2_PRETTY_PRINT) {
                    return;
                }
                a = (FSArray)this;
                this.printFSArrayElements((FSArray)a, indent, incr, buf, useShortNames, printRefs, isShortForm);
                return;
            }
            for (FeatureImpl fi : this._typeImpl.getFeatureImpls()) {
                Misc.indent(buf, indent);
                buf.append(fi.getShortName() + ": ");
                TypeImpl range = (TypeImpl)fi.getRange();
                if (range.isPrimitive()) {
                    this.addStringOrPrimitive(buf, fi);
                    continue;
                }
                TOP val = null;
                boolean hadException = false;
                try {
                    val = this.getFeatureValue(fi);
                }
                catch (Exception e) {
                    buf.append("<exception ").append(e.getMessage()).append(">\n");
                    hadException = true;
                }
                if (hadException) continue;
                if (isShortForm) {
                    if (null == val) {
                        buf.append("<null>");
                        continue;
                    }
                    buf.append(val._getTypeImpl().getShortName()).append(':').append(val._id);
                    continue;
                }
                if (val instanceof Sofa) {
                    buf.append(((Sofa)val).getSofaID());
                    continue;
                }
                this.ppval(val, indent, incr, buf, useShortNames, printRefs, false);
            }
        }
        catch (Exception e) {
            buf.append("**Caught exception: ").append(e);
        }
    }

    public StringBuilder addStringOrPrimitive(StringBuilder sb, FeatureImpl fi) {
        TypeImpl range = (TypeImpl)fi.getRange();
        if (range.isStringOrStringSubtype()) {
            String stringVal = this.getStringValue(fi);
            stringVal = null == stringVal ? "<null>" : "\"" + Misc.elideString(stringVal, 80) + "\"";
            sb.append(stringVal);
        } else {
            sb.append(this.getFeatureValueAsString(fi));
        }
        return sb;
    }

    private void ppval(FeatureStructureImplC val, int indent, int incr, StringBuilder buf, boolean useShortNames, PrintReferences printRefs, boolean isShortForm) {
        if (val != null && !val._typeImpl.getName().equals("uima.cas.Sofa")) {
            val.prettyPrint(indent, incr, buf, useShortNames, null, printRefs, isShortForm);
        } else {
            buf.append(val == null ? "<null>" : "sofa id: " + ((SofaFS)((Object)val)).getSofaID());
        }
    }

    private void printArrayElements(int arrayLen, IntConsumer f, int indent, int incr, StringBuilder buf) {
        Misc.indent(buf, indent);
        buf.append("Array length: " + arrayLen);
        if (arrayLen == 0) {
            return;
        }
        Misc.indent(buf, indent);
        buf.append("Array elements: ");
        if (IS_V2_PRETTY_PRINT) {
            buf.append("[");
            for (int i2 = 0; i2 < arrayLen; ++i2) {
                if (i2 > 0) {
                    buf.append(", ");
                }
                f.accept(i2);
            }
            buf.append("]");
        } else {
            Misc.addElementsToStringBuilder(buf, arrayLen, arrayLen, indent, incr, (sb, i) -> f.accept((int)i));
        }
    }

    private void printFSArrayElements(FSArray fsarray, int indent, int incr, StringBuilder buf, boolean useShortNames, PrintReferences printRefs, boolean isShortForm) {
        Misc.indent(buf, indent);
        int arraylen = fsarray.size();
        buf.append("Array length: " + arraylen);
        if (arraylen == 0) {
            return;
        }
        Misc.indent(buf, indent);
        buf.append("Array elements: [");
        indent += incr;
        for (int i = 0; i < arraylen; ++i) {
            Misc.indent(buf, indent);
            this.ppval((FeatureStructureImplC)fsarray.get(i), indent, incr, buf, useShortNames, printRefs, isShortForm);
        }
        Misc.indent(buf, indent - incr);
        buf.append(']');
    }

    private void appendOrNull(StringBuilder sb, String v) {
        sb.append(v == null ? "null" : v);
    }

    public int getTypeIndexID() {
        throw new CASRuntimeException("INTERNAL_ERROR", new Object[0]);
    }

    public void _setIntLikeValue(SlotKinds.SlotKind slotKind, FeatureImpl fi, int v) {
        switch (slotKind) {
            case Slot_Boolean: {
                this.setBooleanValue(fi, v == 1);
                break;
            }
            case Slot_Byte: {
                this.setByteValue(fi, (byte)v);
                break;
            }
            case Slot_Short: {
                this.setShortValue(fi, (short)v);
                break;
            }
            case Slot_Int: {
                this.setIntValue(fi, v);
                break;
            }
            case Slot_Float: {
                this.setFloatValue(fi, CASImpl.int2float(v));
                break;
            }
            default: {
                Misc.internalError();
            }
        }
    }

    public void _setIntLikeValueNcNj(SlotKinds.SlotKind slotKind, FeatureImpl fi, int v) {
        switch (slotKind) {
            case Slot_Boolean: {
                this._setBooleanValueNcNj(fi, v == 1);
                break;
            }
            case Slot_Byte: {
                this._setByteValueNcNj(fi, (byte)v);
                break;
            }
            case Slot_Short: {
                this._setShortValueNcNj(fi, (short)v);
                break;
            }
            case Slot_Int: {
                this._setIntValueNcNj(fi, v);
                break;
            }
            case Slot_Float: {
                this._setFloatValueNcNj(fi, CASImpl.int2float(v));
                break;
            }
            default: {
                Misc.internalError();
            }
        }
    }

    public int _getIntLikeValue(SlotKinds.SlotKind slotKind, FeatureImpl f) {
        if (null == f) {
            switch (slotKind) {
                case Slot_Boolean: {
                    BooleanArray a = (BooleanArray)this;
                    return a.size() == 0 ? 0 : (a.get(0) ? 1 : 0);
                }
                case Slot_Byte: {
                    ByteArray a = (ByteArray)this;
                    return a.size() == 0 ? 0 : (int)a.get(0);
                }
                case Slot_Short: {
                    ShortArray a = (ShortArray)this;
                    return a.size() == 0 ? 0 : (int)a.get(0);
                }
                case Slot_Int: {
                    IntegerArray a = (IntegerArray)this;
                    return a.size() == 0 ? 0 : a.get(0);
                }
                case Slot_Float: {
                    FloatArray a = (FloatArray)this;
                    return a.size() == 0 ? 0 : CASImpl.float2int(a.get(0));
                }
            }
            Misc.internalError();
            return 0;
        }
        switch (slotKind) {
            case Slot_Boolean: {
                return this._getBooleanValueNc(f) ? 1 : 0;
            }
            case Slot_Byte: {
                return this._getByteValueNc(f);
            }
            case Slot_Short: {
                return this._getShortValueNc(f);
            }
            case Slot_Int: {
                return this._getIntValueNc(f);
            }
            case Slot_Float: {
                return CASImpl.float2int(this._getFloatValueNc(f));
            }
        }
        Misc.internalError();
        return 0;
    }

    @Override
    public String getFeatureValueAsString(Feature feat) {
        FeatureImpl fi = (FeatureImpl)feat;
        TypeImpl range = fi.getRangeImpl();
        if (fi.isInInt) {
            switch (range.getCode()) {
                case 3: {
                    return Float.toString(this.getFloatValue(feat));
                }
                case 23: {
                    return Boolean.toString(this.getBooleanValue(feat));
                }
                case 26: {
                    return Long.toString(this.getLongValue(feat));
                }
                case 27: {
                    return Double.toString(this.getDoubleValue(feat));
                }
                case 24: {
                    return Byte.toString(this.getByteValue(feat));
                }
                case 25: {
                    return Short.toString(this.getShortValue(feat));
                }
            }
            return Integer.toString(this.getIntValue(feat));
        }
        if (range instanceof TypeImpl_string) {
            return this.getStringValue(feat);
        }
        if (range.isRefType) {
            TOP ref = this.getFeatureValue(feat);
            return ref == null ? null : ref.toString();
        }
        Misc.internalError();
        return null;
    }

    protected boolean _inSetSortedIndex() {
        return (this._flags & 1) != 0;
    }

    protected void _setInSetSortedIndexed() {
        this._flags |= 1;
    }

    protected void _resetInSetSortedIndex() {
        this._flags &= 0xFFFFFFFE;
    }

    protected void _setJCasHashMapReserve() {
        this._flags |= 4;
    }

    public boolean _isJCasHashMapReserve() {
        return (this._flags & 4) != 0;
    }

    protected void _setPearTrampoline() {
        this._flags |= 2;
    }

    protected boolean _isPearTrampoline() {
        return (this._flags & 2) != 0;
    }

    protected FeatureImpl _getFeatFromAdjOffset(int adjOffset, boolean isInInt) {
        return this._typeImpl.getFeatureByAdjOffset(adjOffset, isInInt);
    }

    private int _getIntValueCommon(FeatureImpl feat) {
        return this._intData[feat.getAdjustedOffset()];
    }

    private int _getIntValueCommon(int adjOffset) {
        return this._intData[adjOffset];
    }

    private Object _getRefValueCommon(FeatureImpl feat) {
        return this._refData[feat.getAdjustedOffset()];
    }

    public Object _getRefValueCommon(int adjOffset) {
        return this._refData[adjOffset];
    }

    private void _setIntValueCommon(FeatureImpl fi, int v) {
        this._intData[fi.getAdjustedOffset()] = v;
        if (traceFSs) {
            this._casView.traceFSfeat(this, fi, v);
        }
    }

    private void _setIntValueCommon(int adjOffset, int v) {
        this._intData[adjOffset] = v;
        if (traceFSs) {
            this._casView.traceFSfeat(this, this._getFeatFromAdjOffset(adjOffset, true), v);
        }
    }

    private void _setRefValueCommon(FeatureImpl fi, Object v) {
        this._setRefValueCommon(fi.getAdjustedOffset(), v);
    }

    public void _setRefValueCommon(int adjOffset, Object v) {
        this._refData[adjOffset] = v;
        if (traceFSs) {
            this._casView.traceFSfeat(this, this._getFeatFromAdjOffset(adjOffset, false), v);
        }
    }

    protected void _setRefValueCommonWj(FeatureImpl fi, Object v) {
        this._setRefValueCommon(fi, v);
        this._casView.maybeLogUpdate(this, fi);
    }

    private void featureValidation(Feature feat) {
        if (!((TypeImpl)feat.getDomain()).subsumes(this._typeImpl)) {
            throw new CASRuntimeException("INAPPROP_FEAT", feat.getName(), this._typeImpl.getName());
        }
    }

    private void featureValueValidation(Feature feat, Object v) {
        TypeImpl range = (TypeImpl)feat.getRange();
        if (range.isArray() && !this.isOkArray(range, v) || !range.isArray() && !range.subsumesValue(v)) {
            throw new CASRuntimeException("INAPPROP_RANGE", feat.getName(), range.getName(), v == null ? "null" : v.getClass().getName());
        }
    }

    private boolean isOkArray(TypeImpl range, Object v) {
        if (v == null) {
            return true;
        }
        int rangeTypeCode = range.getCode();
        switch (rangeTypeCode) {
            case 28: {
                return v instanceof BooleanArray;
            }
            case 29: {
                return v instanceof ByteArray;
            }
            case 30: {
                return v instanceof ShortArray;
            }
            case 8: {
                return v instanceof IntegerArray;
            }
            case 7: {
                return v instanceof FloatArray;
            }
            case 31: {
                return v instanceof LongArray;
            }
            case 32: {
                return v instanceof DoubleArray;
            }
            case 9: {
                return v instanceof StringArray;
            }
            case 6: {
                return v instanceof FSArray;
            }
        }
        return v instanceof FSArray;
    }

    private void subStringRangeCheck(Feature feat, String v) {
        Type range = feat.getRange();
        if (range instanceof TypeImpl_stringSubtype && v != null) {
            ((TypeImpl_stringSubtype)range).validateIsInAllowedValues(v);
        }
    }

    public void _copyIntAndRefArraysFrom(FeatureStructureImplC src) {
        if (src._intData != null && this._intData != null) {
            System.arraycopy(src._intData, 0, this._intData, 0, Math.min(src._intData.length, this._intData.length));
        }
        if (src._refData != null && this._refData != null) {
            System.arraycopy(src._refData, 0, this._refData, 0, Math.min(src._refData.length, this._refData.length));
        }
    }

    public void _copyIntAndRefArraysEqTypesFrom(FeatureStructureImplC src) {
        if (this._intData != null) {
            System.arraycopy(src._intData, 0, this._intData, 0, this._typeImpl.nbrOfUsedIntDataSlots);
        }
        if (this._refData != null) {
            System.arraycopy(src._refData, 0, this._refData, 0, this._typeImpl.nbrOfUsedRefDataSlots);
        }
    }

    public void _copyIntArrayEqTypesFrom(FeatureStructureImplC src) {
        if (this._intData != null) {
            System.arraycopy(src._intData, 0, this._intData, 0, this._intData.length);
        }
    }

    public String toShortString() {
        return this._typeImpl.getShortName() + ':' + this._id;
    }

    public final TypeImpl _getTypeImpl() {
        return this._typeImpl;
    }

    protected final void _setTypeImpl(TypeImpl ti) {
        this._typeImpl = ti;
    }

    public static int compare(FeatureStructureImplC a, FeatureStructureImplC b) {
        return Integer.compare(a._id, b._id);
    }

    protected static final int wrapGetIntCatchException(MethodHandle mh) {
        try {
            return mh.invokeExact();
        }
        catch (Throwable t) {
            throw new UIMA_IllegalStateException("JCAS_NO_TYPE", null, t);
        }
    }

    private /* synthetic */ void lambda$prettyPrint$15(StringBuilder buf, DoubleArray a, int i) {
        this.appendOrNull(buf, Double.toString(a.get(i)));
    }

    private /* synthetic */ void lambda$prettyPrint$14(StringBuilder buf, LongArray a, int i) {
        this.appendOrNull(buf, Long.toString(a.get(i)));
    }

    private /* synthetic */ void lambda$prettyPrint$13(StringBuilder buf, ShortArray a, int i) {
        this.appendOrNull(buf, Short.toString(a.get(i)));
    }

    private /* synthetic */ void lambda$prettyPrint$12(StringBuilder buf, ByteArray a, int i) {
        this.appendOrNull(buf, Byte.toString(a.get(i)));
    }

    private /* synthetic */ void lambda$prettyPrint$11(StringBuilder buf, BooleanArray a, int i) {
        this.appendOrNull(buf, Boolean.toString(a.get(i)));
    }

    private /* synthetic */ void lambda$prettyPrint$10(StringBuilder buf, FloatArray a, int i) {
        this.appendOrNull(buf, Float.toString(a.get(i)));
    }

    private /* synthetic */ void lambda$prettyPrint$9(StringBuilder buf, IntegerArray a, int i) {
        this.appendOrNull(buf, Integer.toString(a.get(i)));
    }

    private /* synthetic */ void lambda$prettyPrint$8(StringBuilder buf, StringArray a, int i) {
        this.appendOrNull(buf, a.get(i));
    }

    public static class PrintReferences {
        static final int NO_LABEL = 0;
        static final int WITH_LABEL = 1;
        static final int JUST_LABEL = 2;
        private static final String refNamePrefix = "#";
        private Map<FeatureStructure, String> tree = new HashMap<FeatureStructure, String>();
        private Set<FeatureStructure> seen = new HashSet<FeatureStructure>();
        private int count = 0;

        private PrintReferences() {
        }

        boolean addReference(FeatureStructure fs) {
            String v = this.tree.get(fs);
            if (null == v) {
                this.tree.put(fs, "seen once");
                return false;
            }
            if (v.equals("seen once")) {
                this.tree.put(fs, refNamePrefix + Integer.toString(this.count++));
            }
            return true;
        }

        String getLabel(FeatureStructure ref) {
            return this.tree.get(ref);
        }

        int printInfo(FeatureStructure ref) {
            String k = this.tree.get(ref);
            if (k == null || k.equals("seen once")) {
                return 0;
            }
            if (this.seen.contains(ref)) {
                return 2;
            }
            this.seen.add(ref);
            return 1;
        }
    }
}

