/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.property;

import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.ValidationWarning;
import ezvcard.property.HasAltId;
import ezvcard.property.VCardProperty;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuredName
extends VCardProperty
implements HasAltId {
    private String family;
    private String given;
    private final List<String> additional;
    private final List<String> prefixes;
    private final List<String> suffixes;

    public StructuredName() {
        this.additional = new ArrayList<String>();
        this.prefixes = new ArrayList<String>();
        this.suffixes = new ArrayList<String>();
    }

    public StructuredName(StructuredName original) {
        super(original);
        this.family = original.family;
        this.given = original.given;
        this.additional = new ArrayList<String>(original.additional);
        this.prefixes = new ArrayList<String>(original.prefixes);
        this.suffixes = new ArrayList<String>(original.suffixes);
    }

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public String getGiven() {
        return this.given;
    }

    public void setGiven(String given) {
        this.given = given;
    }

    public List<String> getAdditionalNames() {
        return this.additional;
    }

    public List<String> getPrefixes() {
        return this.prefixes;
    }

    public List<String> getSuffixes() {
        return this.suffixes;
    }

    public List<String> getSortAs() {
        return this.parameters.getSortAs();
    }

    public void setSortAs(String family) {
        this.parameters.setSortAs(family);
    }

    public void setSortAs(String family, String given) {
        this.parameters.setSortAs(family, given);
    }

    @Override
    public String getLanguage() {
        return super.getLanguage();
    }

    @Override
    public void setLanguage(String language) {
        super.setLanguage(language);
    }

    @Override
    public String getAltId() {
        return this.parameters.getAltId();
    }

    @Override
    public void setAltId(String altId) {
        this.parameters.setAltId(altId);
    }

    @Override
    protected Map<String, Object> toStringValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("family", this.family);
        values.put("given", this.given);
        values.put("additional", this.additional);
        values.put("prefixes", this.prefixes);
        values.put("suffixes", this.suffixes);
        return values;
    }

    @Override
    protected void _validate(List<ValidationWarning> warnings, VCardVersion version, VCard vcard) {
        if (version == VCardVersion.V2_1 && (this.additional.size() > 1 || this.prefixes.size() > 1 || this.suffixes.size() > 1)) {
            warnings.add(new ValidationWarning(34, new Object[0]));
        }
    }

    @Override
    public StructuredName copy() {
        return new StructuredName(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.additional.hashCode();
        result = 31 * result + (this.family == null ? 0 : this.family.hashCode());
        result = 31 * result + (this.given == null ? 0 : this.given.hashCode());
        result = 31 * result + this.prefixes.hashCode();
        result = 31 * result + this.suffixes.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        StructuredName other = (StructuredName)obj;
        if (!this.additional.equals(other.additional)) {
            return false;
        }
        if (this.family == null ? other.family != null : !this.family.equals(other.family)) {
            return false;
        }
        if (this.given == null ? other.given != null : !this.given.equals(other.given)) {
            return false;
        }
        if (!this.prefixes.equals(other.prefixes)) {
            return false;
        }
        return this.suffixes.equals(other.suffixes);
    }
}

