/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.parameter;

import ezvcard.SupportedVersions;
import ezvcard.VCardVersion;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class VCardParameter {
    protected final String value;

    public VCardParameter(String value) {
        this(value, false);
    }

    protected VCardParameter(String value, boolean preserveCase) {
        this.value = value == null || preserveCase ? value : value.toLowerCase();
    }

    public String getValue() {
        return this.value;
    }

    public VCardVersion[] getSupportedVersions() {
        for (Field field : this.getClass().getFields()) {
            Object fieldValue;
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                fieldValue = field.get(null);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            if (fieldValue != this) continue;
            SupportedVersions supportedVersionsAnnotation = field.getAnnotation(SupportedVersions.class);
            return supportedVersionsAnnotation == null ? VCardVersion.values() : supportedVersionsAnnotation.value();
        }
        return VCardVersion.values();
    }

    public boolean isSupportedBy(VCardVersion version) {
        for (VCardVersion supportedVersion : this.getSupportedVersions()) {
            if (supportedVersion != version) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VCardParameter other = (VCardParameter)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

