/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.ParseContext;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.text.WriteContext;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.Gender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenderScribe
extends VCardPropertyScribe<Gender> {
    public GenderScribe() {
        super(Gender.class, "GENDER");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.TEXT;
    }

    @Override
    protected String _writeText(Gender property, WriteContext context) {
        VObjectPropertyValues.StructuredValueBuilder builder = new VObjectPropertyValues.StructuredValueBuilder();
        builder.append((Object)property.getGender());
        builder.append((Object)property.getText());
        return builder.build(false);
    }

    @Override
    protected Gender _parseText(String value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        VObjectPropertyValues.SemiStructuredValueIterator it = new VObjectPropertyValues.SemiStructuredValueIterator(value, 2);
        String sex = it.next();
        if (sex != null) {
            sex = sex.toUpperCase();
        }
        String text = it.next();
        Gender property = new Gender(sex);
        property.setText(text);
        return property;
    }

    @Override
    protected void _writeXml(Gender property, XCardElement parent) {
        parent.append("sex", property.getGender());
        String text = property.getText();
        if (text != null) {
            parent.append("identity", text);
        }
    }

    @Override
    protected Gender _parseXml(XCardElement element, VCardParameters parameters, ParseContext context) {
        String sex = element.first("sex");
        if (sex != null) {
            Gender property = new Gender(sex);
            property.setText(element.first("identity"));
            return property;
        }
        throw GenderScribe.missingXmlElements("sex");
    }

    @Override
    protected JCardValue _writeJson(Gender property) {
        String gender = property.getGender();
        String text = property.getText();
        if (text == null) {
            return JCardValue.single(gender);
        }
        return JCardValue.structured(gender, text);
    }

    @Override
    protected Gender _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        VObjectPropertyValues.StructuredValueIterator it = new VObjectPropertyValues.StructuredValueIterator(value.asStructured());
        String sex = it.nextValue();
        if (sex != null) {
            sex = sex.toUpperCase();
        }
        String text = it.nextValue();
        Gender property = new Gender(sex);
        property.setText(text);
        return property;
    }
}

