/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io;

import ezvcard.Messages;
import ezvcard.io.CannotParseException;
import ezvcard.io.ParseContext;

public class ParseWarning {
    private final Integer code;
    private final Integer lineNumber;
    private final String propertyName;
    private final String message;

    private ParseWarning(Integer lineNumber, String propertyName, Integer code, String message) {
        this.lineNumber = lineNumber;
        this.propertyName = propertyName;
        this.code = code;
        this.message = message;
    }

    public Integer getCode() {
        return this.code;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String toString() {
        String message = this.message;
        if (this.code != null) {
            message = "(" + this.code + ") " + message;
        }
        if (this.lineNumber == null && this.propertyName == null) {
            return message;
        }
        int code = this.lineNumber == null && this.propertyName != null ? 35 : (this.lineNumber != null && this.propertyName == null ? 37 : 36);
        return Messages.INSTANCE.getParseMessage(code, this.lineNumber, this.propertyName, message);
    }

    public static class Builder {
        private Integer lineNumber;
        private Integer code;
        private String propertyName;
        private String message;

        public Builder() {
        }

        public Builder(ParseContext context) {
            this.lineNumber(context.getLineNumber());
            this.propertyName(context.getPropertyName());
        }

        public Builder propertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public Builder lineNumber(Integer lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public Builder message(int code, Object ... args) {
            this.code = code;
            this.message = Messages.INSTANCE.getParseMessage(code, args);
            return this;
        }

        public Builder message(String message) {
            this.code = null;
            this.message = message;
            return this;
        }

        public Builder message(CannotParseException exception) {
            return this.message(exception.getCode(), exception.getArgs());
        }

        public ParseWarning build() {
            return new ParseWarning(this.lineNumber, this.propertyName, this.code, this.message);
        }
    }
}

