/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.templating.impl;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.templating.TemplateErrorMessage;
import com.openexchange.templating.impl.DocumentMetadataMatcher;
import com.openexchange.templating.impl.OXFolderHelper;
import com.openexchange.templating.impl.OXInfostoreHelper;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderManager;
import com.openexchange.tools.session.ServerSession;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OXIntegration
implements OXFolderHelper,
OXInfostoreHelper {
    private static final Logger LOG = LoggerFactory.getLogger(OXIntegration.class);
    private static final String TEMPLATE_FOLDER_NAME = "OXMF Templates";
    private final InfostoreFacade infostore;
    private static final Pattern EXPLICIT_ID = Pattern.compile("infostore://(\\d+)");

    public OXIntegration(InfostoreFacade infostore) {
        this.infostore = infostore;
    }

    @Override
    public FolderObject createPrivateTemplateFolder(ServerSession session) throws OXException {
        OXFolderManager manager = OXFolderManager.getInstance((Session)session);
        OXFolderAccess access = this.getFolderAccess(session);
        int parentFolderID = access.getDefaultFolderID(session.getUserId(), 8);
        FolderObject fo = new FolderObject();
        fo.setParentFolderID(parentFolderID);
        fo.setFolderName(TEMPLATE_FOLDER_NAME);
        OCLPermission adminPermission = new OCLPermission();
        adminPermission.setAllObjectPermission(4, 4, 4);
        adminPermission.setFolderAdmin(true);
        adminPermission.setFolderPermission(128);
        adminPermission.setEntity(session.getUserId());
        fo.setPermissions(Arrays.asList(adminPermission));
        fo.setModule(8);
        fo.setType(2);
        return manager.createFolder(fo, true, System.currentTimeMillis());
    }

    @Override
    public FolderObject getGlobalTemplateFolder(ServerSession session) throws OXException {
        return this.findTemplatesSubfolder(15, this.getFolderAccess(session), session.getContext());
    }

    @Override
    public FolderObject getPrivateTemplateFolder(ServerSession session) throws OXException {
        OXFolderAccess access = this.getFolderAccess(session);
        FolderObject privateInfostoreFolder = access.getDefaultFolder(session.getUserId(), 8);
        return this.findTemplatesSubfolder(privateInfostoreFolder, access, session.getContext());
    }

    private OXFolderAccess getFolderAccess(ServerSession session) {
        return new OXFolderAccess(session.getContext());
    }

    private FolderObject findTemplatesSubfolder(int folderId, OXFolderAccess access, Context ctx) throws OXException {
        FolderObject folderObject = access.getFolderObject(folderId);
        return this.findTemplatesSubfolder(folderObject, access, ctx);
    }

    private FolderObject findTemplatesSubfolder(FolderObject folderObject, OXFolderAccess access, Context ctx) throws OXException {
        try {
            Iterator i$ = folderObject.getSubfolderIds(true, ctx).iterator();
            while (i$.hasNext()) {
                int id = (Integer)i$.next();
                FolderObject child = access.getFolderObject(id);
                if (!child.getFolderName().equals(TEMPLATE_FOLDER_NAME)) continue;
                return child;
            }
        }
        catch (SQLException e) {
            throw TemplateErrorMessage.SQLException.create(e, new Object[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findTemplateInFolder(ServerSession session, FolderObject folder, String name) throws OXException {
        Matcher matcher;
        if (name.startsWith("infostore://") && (matcher = EXPLICIT_ID.matcher(name)).find()) {
            String id = matcher.group(1);
            InputStream is = this.infostore.getDocument(Integer.parseInt(id), -1, session);
            return this.asString(is);
        }
        try (SearchIterator iterator = this.infostore.getDocuments((long)folder.getObjectID(), new Metadata[]{Metadata.ID_LITERAL, Metadata.TITLE_LITERAL, Metadata.FILENAME_LITERAL}, session).results();){
            DocumentMetadataMatcher matcher2 = new DocumentMetadataMatcher(name);
            while (iterator.hasNext() && !matcher2.hasPerfectMatch()) {
                matcher2.propose((DocumentMetadata)iterator.next());
            }
            DocumentMetadata metadata = matcher2.getBestMatch();
            if (metadata == null) {
                String string = null;
                return string;
            }
            InputStream is = this.infostore.getDocument(metadata.getId(), -1, session);
            String string = this.asString(is);
            return string;
        }
    }

    /*
     * Loose catch block
     */
    private String asString(InputStream is) throws OXException {
        String string;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            StringBuilder builder = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                builder.append(line).append('\n');
            }
            string = builder.toString();
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("", (Throwable)e);
            String string2 = null;
            Streams.close((Closeable[])new Closeable[]{reader, is});
            return string2;
        }
        catch (IOException e2) {
            LOG.error("", (Throwable)e2);
            throw TemplateErrorMessage.IOException.create(e2, new Object[0]);
            {
                catch (Throwable throwable) {
                    Streams.close((Closeable[])new Closeable[]{reader, is});
                    throw throwable;
                }
            }
        }
        Streams.close((Closeable[])new Closeable[]{reader, is});
        return string;
    }

    @Override
    public void storeTemplateInFolder(ServerSession session, FolderObject folder, String name, String templateText) throws OXException {
        DocumentMetadataImpl metadata = new DocumentMetadataImpl();
        metadata.setFileName(name);
        metadata.setTitle(name);
        metadata.setFolderId((long)folder.getObjectID());
        metadata.setVersionComment("Created as copy from default template");
        metadata.setFileMIMEType("text/plain");
        this.infostore.saveDocument((DocumentMetadata)metadata, (InputStream)new ByteArrayInputStream(templateText.getBytes(Charsets.UTF_8)), -1L, session);
    }

    @Override
    public List<String> getNames(ServerSession session, FolderObject folder, String ... filter) throws OXException {
        HashSet<String> sieve = new HashSet<String>(Arrays.asList(filter));
        SearchIterator iterator = this.infostore.getDocuments((long)folder.getObjectID(), new Metadata[]{Metadata.FILENAME_LITERAL, Metadata.CATEGORIES_LITERAL}, session).results();
        ArrayList<String> names = new ArrayList<String>(30);
        while (iterator.hasNext()) {
            DocumentMetadata doc = (DocumentMetadata)iterator.next();
            HashSet<String> categories = null;
            if (doc.getCategories() != null && doc.getCategories().length() > 0) {
                categories = new HashSet<String>(Arrays.asList(doc.getCategories().split("\\s*,\\s*")));
            }
            if (categories != null && !categories.containsAll(sieve)) continue;
            names.add(doc.getFileName());
        }
        return names;
    }
}

