/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.templating.converter;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class AssetHelper {
    private final String prefix;

    public AssetHelper(String prefix) {
        this.prefix = prefix;
    }

    public String getLinkTo(String asset) {
        try {
            return this.prefix + URLEncoder.encode(asset, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return this.prefix + asset;
        }
    }

    public String includeJS(String asset) {
        return "<script type=\"text/javascript\" src=\"" + this.getLinkTo(asset) + "\"></script>";
    }

    public String includeCSS(String asset) {
        return "<link rel=\"stylesheet\" type=\"text/css\" href=\"" + this.getLinkTo(asset) + "\">";
    }
}

